#include "videothread.h"

videothread::videothread(QObject *parent) :
    QThread(parent)
{

}
//INICJALIZACJA WIDEO AVI
void videothread::videoInit()
{
    //capture.open(fname.toStdString());

    capture.open(1);
    if(capture.isOpened() == false)
    {
        qDebug()<<"No camera2";
        return;
    }

    this->start();
}

//Star naszego watku
void videothread::run()
{
    while(1)
    {
        //QMutex mutex;
        //mutex.lock();

        //mutex.unlock();
        capture.read(input_img);

        if(input_img.empty() == true) return;

        //TU WPISUJEMY WSZYSTKO CO DZIEJE SIE Z NASZYM OBRAZEM Z KAMERY
        cv::Mat skinMask;
        adaptivSkinDet(input_img, skinMask);
        //...

        //Konwersja do QImage
        QImage qimginput = qinputimage(skinMask);

        //Emisja sygnału do watku głównego
        emit NewCamImg(qimginput);

    }
}
void videothread::adaptivSkinDet(cv::Mat img, cv::Mat &mask)
{
    cv::Mat hsvimg;
    cv::cvtColor(img,hsvimg, CV_BGR2HSV);

    //rozmycie gaussowskie
    cv::GaussianBlur(hsvimg, hsvimg, cv::Size(17,17), 5, 5);

    //progowanie koloru skory
    cv::inRange(hsvimg, cv::Scalar(hmin, smin, vmin), cv::Scalar(hmax,smax,vmax), mask);

    //erozja
    int erode_elem = 0;
    int erode_type;
    int erode_size = 3;
    if( erode_elem == 0 )
    {
        erode_type = cv::MORPH_RECT;
    }
    else if( erode_elem == 1 )
    {
        erode_type = cv::MORPH_CROSS;
    }
    else if( erode_elem == 2)
    {
        erode_type = cv::MORPH_ELLIPSE;
    }

    //dylacja
    int dilation_elem = 0;
    int dilation_type;
    int dilation_size = 7;
    if( dilation_elem == 0 )
    {
        dilation_type = cv::MORPH_RECT;
    }
    else if( dilation_elem == 1 )
    {
        dilation_type = cv::MORPH_CROSS;
    }
    else if( dilation_elem == 2)
    {
        dilation_type = cv::MORPH_ELLIPSE;
    }

    cv::Mat element1 = cv::getStructuringElement( erode_type,
                                           cv::Size( 2*erode_size + 1, 2*erode_size+1 ),
                                           cv::Point( erode_size, erode_size ) );
    cv::Mat element = cv::getStructuringElement( dilation_type,
                                           cv::Size( 2*dilation_size + 1, 2*dilation_size+1 ),
                                           cv::Point( dilation_size, dilation_size ) );
    /// Apply the dilation operation
    cv::erode(mask, mask,element1);
    cv::dilate( mask, mask, element );

    //cv::inRange(hsvimg, cv::Scalar(hmin, 15, 15), cv::Scalar(hmax,250,250), mask);
}


QImage videothread::qinputimage(const cv::Mat &mat)
{
    // 8-bits unsigned, NO. OF CHANNELS=1
    if(mat.type()==CV_8UC1)
    {
        // Set the color table (used to translate colour indexes to qRgb values)
        QVector<QRgb> colorTable;
        for (int i=0; i<256; i++)
            colorTable.push_back(qRgb(i,i,i));
        // Copy input Mat
        const uchar *qImageBuffer = (const uchar*)mat.data;
        // Create QImage with same dimensions as input Mat
        QImage img(qImageBuffer, mat.cols, mat.rows, mat.step, QImage::Format_Indexed8);
        img.setColorTable(colorTable);
        return img;
    }
    // 8-bits unsigned, NO. OF CHANNELS=3
    if(mat.type()==CV_8UC3)
    {
        // Copy input Mat
        const uchar *qImageBuffer = (const uchar*)mat.data;
        // Create QImage with same dimensions as input Mat
        QImage img(qImageBuffer, mat.cols, mat.rows, mat.step, QImage::Format_RGB888);
        return img.rgbSwapped();
    }
    else
    {
        qDebug() << "ERROR: Mat could not be converted to QImage.";
        return QImage();
    }
}

