/*
 * Decompiled with CFR 0.152.
 */
package distributedmodel;

import distributedmodel.DSConfig;
import distributedmodel.Network;
import distributedmodel.Node;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.SoftwareDS;

public class DistributedSystem {
    private final Network mNet;
    private final Node[] mNodes;
    private final DSConfig mConfig;

    public DistributedSystem(DSConfig config) {
        this.mConfig = config;
        this.mNet = new Network(config.getNumberOfNodes(), config.getConnectionDelay(), config.getUnitTransmissionDelay());
        this.mNodes = new Node[this.mNet.getNetworkSize()];
        for (int i = 0; i < this.mNet.getNetworkSize(); ++i) {
            this.mNodes[i] = new Node(this.mNet.getEndpoint(i));
        }
    }

    public DistributedSystem(DSConfig config, double[][] initial_data_states) {
        this.mConfig = config;
        this.mNet = new Network(config.getNumberOfNodes(), config.getConnectionDelay(), config.getUnitTransmissionDelay());
        this.mNodes = new Node[this.mNet.getNetworkSize()];
        for (int i = 0; i < this.mNet.getNetworkSize(); ++i) {
            this.mNodes[i] = new Node(this.mNet.getEndpoint(i), initial_data_states[i]);
        }
    }

    public void loadProgramToNodes(SoftwareDS s) {
        for (int i = 0; i < this.mNet.getNetworkSize(); ++i) {
            this.mNodes[i].loadSoftware(s);
        }
    }

    public Node getNode(int i) {
        return this.mNodes[i];
    }

    public DSConfig getConfiguration() {
        return this.mConfig;
    }

    public void runSystem() {
        int i;
        for (i = 0; i < this.mNet.getNetworkSize(); ++i) {
            this.mNodes[i].startSoftware();
        }
        for (i = 0; i < this.mNet.getNetworkSize(); ++i) {
            try {
                this.mNodes[i].exitSoftware();
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DistributedSystem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\nData in the system of nodes:\n");
        for (Node node : this.mNodes) {
            sb.append(node.toString());
        }
        return sb.toString();
    }
}

