/*
 * Decompiled with CFR 0.152.
 */
package labs;

import java.awt.Dimension;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.util.ShapeUtilities;

public abstract class BaseLab {
    public abstract void testAll();

    protected static double[] generateRandomData(int dataSize) {
        double[] data = new double[dataSize];
        for (int i = 0; i < dataSize; ++i) {
            data[i] = Math.random();
        }
        return data;
    }

    protected static double[][] generateRandomDataForNodes(int nNodes, int dataSize) {
        double[][] data = new double[nNodes][];
        for (int i = 0; i < nNodes; ++i) {
            data[i] = BaseLab.generateRandomData(dataSize);
        }
        return data;
    }

    protected static JFreeChart makeChart(XYSeriesCollection seriesCollection, String chartTitle, String xLabel, String yLabel) {
        JFreeChart chart = ChartFactory.createXYLineChart(chartTitle, xLabel, yLabel, seriesCollection, PlotOrientation.VERTICAL, true, true, false);
        XYPlot plot = (XYPlot)chart.getPlot();
        XYLineAndShapeRenderer r = (XYLineAndShapeRenderer)plot.getRenderer();
        for (int i = 0; i < plot.getSeriesCount(); ++i) {
            r.setSeriesShape(i, ShapeUtilities.createDiamond(5.0f));
            r.setSeriesShapesVisible(i, true);
        }
        return chart;
    }

    protected static void displayChart(JFreeChart chart) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(2);
        ChartPanel chartPanel = new ChartPanel(chart){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(630, 480);
            }
        };
        f.add(chartPanel);
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }
}

