/*
 * Decompiled with CFR 0.152.
 */
package labs;

import algorithms.Utils;
import algorithms.distributed.Sort;
import algorithms.shared.SortSM;
import distributedmodel.DistributedSystem;
import distributedmodel.Node;
import java.util.Arrays;
import labs.BaseLabMixed;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class Lab03
extends BaseLabMixed {
    private void testSharedAlgorithms() {
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        XYSeries exp1 = this.seriesOfRuns("Serial version", (double[] data) -> SortSM.serialQuicksort(data));
        seriesCollection.addSeries(exp1);
        XYSeries exp2 = this.seriesOfRuns("ForkJoin version", (double[] data) -> SortSM.QuicksortForkJoin(data));
        seriesCollection.addSeries(exp2);
        JFreeChart chart = Lab03.makeChart(seriesCollection, "Quicksort performance (shared memory)", "Number of elements to reduce", "Execution time [s]");
        Lab03.displayChart(chart);
    }

    private void testSortAlgorithmsDS() {
        boolean beVerbose = false;
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        XYSeries exp1 = this.seriesOfRuns("Bitonic sort", (Node node) -> Sort.bitonicSortAsc(node, beVerbose));
        seriesCollection.addSeries(exp1);
        JFreeChart chart = Lab03.makeChart(seriesCollection, "Sort algorithms performance (distributed system)", "Number of nodes (= elements to sort)", "Execution time [s]");
        Lab03.displayChart(chart);
    }

    @Override
    protected void initSharedMemory(double[] data) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = Math.random();
        }
    }

    @Override
    protected void initNodesWithData(DistributedSystem ds) {
        for (int i = 0; i < ds.getConfiguration().getNumberOfNodes(); ++i) {
            double[] data = new double[]{Math.random()};
            ds.getNode(i).setMyData(data);
        }
    }

    @Override
    public void testAll() {
        double[] tmp1 = new double[]{Math.random()};
        double[] tmp2 = new double[]{Math.random(), Math.random()};
        double[] res = Utils.merge(tmp1, tmp2);
        System.out.format("tmp 1 = %s%n", Arrays.toString(tmp1));
        System.out.format("tmp 2 = %s%n", Arrays.toString(tmp2));
        System.out.format("res = %s%n", Arrays.toString(res));
    }
}

