/*
 * Decompiled with CFR 0.152.
 */
package labs;

import distributedmodel.DistributedSystem;
import labs.BaseLabDS;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import software.TimeConsumingTaskOnOneNode;
import software.TimeConsumingTaskParallelized;

public class TimeConsumingTaskSimulation
extends BaseLabDS {
    public static long UNIT_PROCESSING_TIME_MILLIS = 300L;

    @Override
    public void testAll() {
        boolean beVerbose = true;
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        XYSeries exp1 = this.seriesOfRuns("One node version", new TimeConsumingTaskOnOneNode(UNIT_PROCESSING_TIME_MILLIS), beVerbose);
        seriesCollection.addSeries(exp1);
        XYSeries exp2 = this.seriesOfRuns("Parallel version", new TimeConsumingTaskParallelized(UNIT_PROCESSING_TIME_MILLIS), beVerbose);
        seriesCollection.addSeries(exp2);
        JFreeChart chart = TimeConsumingTaskSimulation.makeChart(seriesCollection, "Heavy operation performance", "Number of nodes", "Execution time [s]");
        TimeConsumingTaskSimulation.displayChart(chart);
    }

    @Override
    protected void initNodesWithData(DistributedSystem ds) {
        ds.getNode(0).setMyData(TimeConsumingTaskSimulation.generateRandomData(16));
    }
}

