/*
 * Decompiled with CFR 0.152.
 */
package software;

import algorithms.distributed.BasicCommunication;
import distributedmodel.Node;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.SoftwareDS;

public class TimeConsumingTaskParallelized
implements SoftwareDS {
    private final long mProcessingTime;

    public TimeConsumingTaskParallelized(long processing_time_milis) {
        this.mProcessingTime = processing_time_milis;
    }

    public TimeConsumingTaskParallelized() {
        this(500L);
    }

    @Override
    public void instructions(Node node) {
        BasicCommunication.scatter(node);
        double[] myData = node.getMyData();
        double result = 0.0;
        for (int i = 0; i < myData.length; ++i) {
            try {
                Thread.sleep(this.mProcessingTime);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(TimeConsumingTaskParallelized.class.getName()).log(Level.SEVERE, null, ex);
            }
            result += myData[i];
        }
        myData[0] = result;
        node.setMyData(myData);
        BasicCommunication.reduce(node, (a, b) -> a + b);
    }
}

