/*
 * Decompiled with CFR 0.152.
 */
package algorithms;

public class Utils {
    public static int binlog(int bits) {
        int log = 0;
        if ((bits & 0xFFFF0000) != 0) {
            bits >>>= 16;
            log = 16;
        }
        if (bits >= 256) {
            bits >>>= 8;
            log += 8;
        }
        if (bits >= 16) {
            bits >>>= 4;
            log += 4;
        }
        if (bits >= 4) {
            bits >>>= 2;
            log += 2;
        }
        return log + (bits >>> 1);
    }

    public static double[] flatten2dArray(double[][] array) {
        int size = 0;
        for (double[] e : array) {
            size += e.length;
        }
        double[] result = new double[size];
        int pos = 0;
        for (double[] e : array) {
            System.arraycopy(e, 0, result, pos, e.length);
            pos += e.length;
        }
        return result;
    }

    public static double[] merge(double[] a1, double[] a2) {
        double[] result = new double[a1.length + a2.length];
        int i1 = 0;
        int i2 = 0;
        for (int j = 0; j < result.length; ++j) {
            result[j] = i1 < a1.length && (i2 == a2.length || a1[i1] <= a2[i2]) ? a1[i1++] : a2[i2++];
        }
        return result;
    }
}

