/*
 * Decompiled with CFR 0.152.
 */
package algorithms.shared;

import algorithms.Utils;
import java.util.ArrayList;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.DoubleBinaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicCommunicationSharedMem {
    public static void reduce(final double[] array, final DoubleBinaryOperator op) {
        int i;
        int nThreads = array.length / 2;
        CyclicBarrier barrier = new CyclicBarrier(nThreads);
        Thread[] workers = new Thread[nThreads];
        for (i = 0; i < nThreads; ++i) {
            class Reducer
            implements Runnable {
                final int myIdx;
                final CyclicBarrier barrier;

                public Reducer(int myIdx, CyclicBarrier b) {
                    this.myIdx = myIdx;
                    this.barrier = b;
                }

                @Override
                public void run() {
                    int mask = 1;
                    int powerOfTwo = 1;
                    for (int i = 0; i < Utils.binlog(array.length); ++i) {
                        if ((this.myIdx & mask) == 0 && (this.myIdx & powerOfTwo) == 0) {
                            double v1 = array[this.myIdx ^ powerOfTwo];
                            array[this.myIdx] = op.applyAsDouble(array[this.myIdx], v1);
                        }
                        mask ^= powerOfTwo;
                        powerOfTwo <<= 1;
                        try {
                            this.barrier.await();
                            continue;
                        }
                        catch (InterruptedException | BrokenBarrierException ex) {
                            Logger.getLogger(BasicCommunicationSharedMem.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
            workers[i] = new Thread(new Reducer(2 * i, barrier));
            workers[i].start();
        }
        for (i = 0; i < nThreads; ++i) {
            try {
                workers[i].join();
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(BasicCommunicationSharedMem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void reduceV2(final double[] array, final DoubleBinaryOperator op) {
        int nRunnables;
        int nThreads = nRunnables = array.length / 2;
        ExecutorService es = Executors.newFixedThreadPool(nThreads);
        CyclicBarrier barrier = new CyclicBarrier(nRunnables);
        class Reducer2
        implements Callable<Double> {
            final int myIdx;
            final CyclicBarrier barrier;

            public Reducer2(int myIdx, CyclicBarrier b) {
                this.myIdx = myIdx;
                this.barrier = b;
            }

            @Override
            public Double call() throws Exception {
                int mask = 1;
                int powerOfTwo = 1;
                for (int i = 0; i < Utils.binlog(array.length); ++i) {
                    if ((this.myIdx & mask) == 0 && (this.myIdx & powerOfTwo) == 0) {
                        double v1 = array[this.myIdx ^ powerOfTwo];
                        array[this.myIdx] = op.applyAsDouble(array[this.myIdx], v1);
                    }
                    mask ^= powerOfTwo;
                    powerOfTwo <<= 1;
                    try {
                        this.barrier.await();
                        continue;
                    }
                    catch (InterruptedException | BrokenBarrierException ex) {
                        Logger.getLogger(BasicCommunicationSharedMem.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                return 0.0;
            }
        }
        ArrayList<Reducer2> tasks = new ArrayList<Reducer2>();
        for (int i = 0; i < nRunnables; ++i) {
            tasks.add(new Reducer2(2 * i, barrier));
        }
        try {
            es.invokeAll(tasks);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(BasicCommunicationSharedMem.class.getName()).log(Level.SEVERE, null, ex);
        }
        es.shutdown();
    }

    public static void scanSerial(double[] array, DoubleBinaryOperator op) {
        for (int i = 1; i < array.length; ++i) {
            array[i] = op.applyAsDouble(array[i - 1], array[i]);
            try {
                Thread.sleep(5L);
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(BasicCommunicationSharedMem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void scan(final double[] array, final DoubleBinaryOperator op) {
        int i;
        int nThreads = array.length - 1;
        CyclicBarrier barrier = new CyclicBarrier(nThreads);
        Thread[] workers = new Thread[nThreads];
        for (i = 0; i < nThreads; ++i) {
            class Scanner
            implements Runnable {
                final int myIdx;
                final CyclicBarrier barrier;

                public Scanner(int myIdx, CyclicBarrier b) {
                    this.myIdx = myIdx;
                    this.barrier = b;
                }

                @Override
                public void run() {
                    int powerOfTwo = 1;
                    for (int i = 0; i < Utils.binlog(array.length); ++i) {
                        double myValue = array[this.myIdx];
                        try {
                            this.barrier.await();
                        }
                        catch (InterruptedException | BrokenBarrierException ex) {
                            Logger.getLogger(BasicCommunicationSharedMem.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        if (this.myIdx + powerOfTwo < array.length) {
                            double v1 = array[this.myIdx + powerOfTwo];
                            array[this.myIdx + powerOfTwo] = op.applyAsDouble(v1, myValue);
                        }
                        powerOfTwo <<= 1;
                        try {
                            this.barrier.await();
                        }
                        catch (InterruptedException | BrokenBarrierException ex) {
                            Logger.getLogger(BasicCommunicationSharedMem.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        try {
                            Thread.sleep(5L);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(BasicCommunicationSharedMem.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
            workers[i] = new Thread(new Scanner(i, barrier));
            workers[i].start();
        }
        for (i = 0; i < nThreads; ++i) {
            try {
                workers[i].join();
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(BasicCommunicationSharedMem.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

