/*
 * Decompiled with CFR 0.152.
 */
package algorithms.shared;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SortSM {
    public static void serialQuicksort(double[] array) {
        SortSM.serialQuicksort(array, 0, array.length - 1);
    }

    private static void serialQuicksort(double[] array, int sPos, int ePos) {
        if (sPos < ePos) {
            double pivot = array[ePos];
            int i = sPos - 1;
            for (int j = sPos; j < ePos; ++j) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(SortSM.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (!(array[j] <= pivot)) continue;
                double tmp = array[j];
                array[j] = array[++i];
                array[i] = tmp;
            }
            int q = i + 1;
            array[ePos] = array[q];
            array[q] = pivot;
            SortSM.serialQuicksort(array, sPos, q - 1);
            SortSM.serialQuicksort(array, q + 1, ePos);
        }
    }

    public static void QuicksortForkJoin(double[] array) {
        ForkJoinPool pool = new ForkJoinPool();
        pool.invoke(new QuickSortAction(array));
    }

    private static class QuickSortAction
    extends RecursiveAction {
        static final int THRESHOLD = 10;
        final double[] array;
        final int sPos;
        final int ePos;

        QuickSortAction(double[] array, int sPos, int ePos) {
            this.array = array;
            this.sPos = sPos;
            this.ePos = ePos;
        }

        QuickSortAction(double[] array) {
            this(array, 0, array.length - 1);
        }

        @Override
        protected void compute() {
            if (this.ePos - this.sPos < 10) {
                SortSM.serialQuicksort(this.array, this.sPos, this.ePos);
            } else {
                double pivot = this.array[this.ePos];
                int i = this.sPos - 1;
                for (int j = this.sPos; j < this.ePos; ++j) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(SortSM.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    if (!(this.array[j] <= pivot)) continue;
                    double tmp = this.array[j];
                    this.array[j] = this.array[++i];
                    this.array[i] = tmp;
                }
                int q = i + 1;
                this.array[this.ePos] = this.array[q];
                this.array[q] = pivot;
                QuickSortAction.invokeAll(new QuickSortAction(this.array, this.sPos, q - 1), new QuickSortAction(this.array, q + 1, this.ePos));
            }
        }
    }
}

