/*
 * Decompiled with CFR 0.152.
 */
package distributedmodel;

import distributedmodel.DataPacket;
import distributedmodel.NetworkEndpoint;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import software.SoftwareDS;

public class Node
implements Runnable {
    private final NetworkEndpoint mNetEndpoint;
    private final int mId;
    private final Thread mThread;
    private double[] mData;
    private SoftwareDS mSoftware;

    Node(NetworkEndpoint netEndpoint, double[] initialData) {
        this(netEndpoint);
        if (initialData != null) {
            this.mData = (double[])initialData.clone();
        }
    }

    Node(NetworkEndpoint netEndpoint) {
        this.mNetEndpoint = netEndpoint;
        this.mId = netEndpoint.getId();
        this.mThread = new Thread(this);
    }

    public double[] getMyData() {
        return this.mData;
    }

    public void setMyData(double[] data) {
        this.mData = data;
    }

    public void send(int destinationId, double[] data, boolean verbose) {
        if (data != null) {
            if (verbose) {
                System.out.printf("Node %d tries to send data to node %d%n", this.mId, destinationId);
            }
            try {
                this.mNetEndpoint.send(destinationId, data);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(Node.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            throw new RuntimeException(String.format("Node %d tries to send nothing (data is null).%n", this.mId));
        }
    }

    public void send(int destinationId, double[] data) {
        this.send(destinationId, data, true);
    }

    public void sendMyData(int destinationId, boolean verbose) {
        this.send(destinationId, this.mData, verbose);
    }

    public void sendMyData(int destinationId) {
        this.send(destinationId, this.mData);
    }

    public void sendForward(DataPacket dp) {
        try {
            this.mNetEndpoint.send(dp);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Node.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public DataPacket receive(boolean verbose) {
        DataPacket dp = null;
        if (verbose) {
            System.out.printf("Node %d waits to receive data%n", this.mId);
        }
        try {
            dp = this.mNetEndpoint.receive();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Node.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (verbose) {
            if (dp != null) {
                System.out.printf("Node %d received data packet: %s%n", this.mId, dp.toString());
            } else {
                System.out.printf("Node %d failed to receive data!%n", this.mId);
            }
        }
        return dp;
    }

    public DataPacket receive() {
        return this.receive(true);
    }

    public void receiveAndSet(boolean verbose) {
        this.setMyData(this.receive(verbose).getData());
    }

    public void receiveAndSet() {
        this.receiveAndSet(true);
    }

    public int getNumberOfAllNodes() {
        return this.mNetEndpoint.getNumberOfChannels();
    }

    public int getMyId() {
        return this.mId;
    }

    void loadSoftware(SoftwareDS s) {
        this.mSoftware = s;
    }

    void startSoftware() {
        this.mThread.start();
    }

    void exitSoftware() throws InterruptedException {
        this.mThread.join();
    }

    @Override
    public void run() {
        if (this.mSoftware == null) {
            throw new RuntimeException(String.format("Node %d does not have any program to execute!", this.mId));
        }
        this.mSoftware.instructions(this);
    }

    public String toString() {
        if (this.mData != null) {
            return String.format("Node %d has data: %s%n", this.mId, Arrays.toString(this.mData));
        }
        return String.format("Node %d does not have any data.%n", this.mId);
    }
}

