/*
 * Decompiled with CFR 0.152.
 */
package labs;

import java.util.Arrays;
import labs.BaseLab;
import org.jfree.data.xy.XYSeries;
import software.SoftwareSM;

public abstract class BaseLabSM
extends BaseLab {
    protected double singleMeasurement(double[] data, SoftwareSM soft, boolean verbose) {
        if (verbose) {
            System.out.printf("Before: %s%n", Arrays.toString(data));
        }
        long startTime = System.currentTimeMillis();
        soft.instructions(data);
        long stopTime = System.currentTimeMillis();
        if (verbose) {
            System.out.printf("After: %s%n", Arrays.toString(data));
        }
        double elapsedTime = (double)(stopTime - startTime) / 1000.0;
        return elapsedTime;
    }

    protected double singleMeasurement(double[] data, SoftwareSM soft) {
        return this.singleMeasurement(data, soft, true);
    }

    protected double singleTestRun(int nElements, SoftwareSM soft, boolean verbose) {
        double[] data = new double[nElements];
        this.initSharedMemory(data);
        double exTime = this.singleMeasurement(data, soft, verbose);
        if (verbose) {
            System.out.printf("Processing took: %.2f sec.%n", exTime);
        }
        return exTime;
    }

    protected XYSeries seriesOfRuns(String expName, SoftwareSM soft, boolean verbose) {
        int[] nElements = new int[]{2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
        double[] exTimes = new double[nElements.length];
        for (int i = 0; i < nElements.length; ++i) {
            exTimes[i] = this.singleTestRun(nElements[i], soft, verbose);
        }
        XYSeries series = new XYSeries((Comparable)((Object)expName));
        for (int i = 0; i < nElements.length; ++i) {
            series.add((double)nElements[i], exTimes[i]);
        }
        return series;
    }

    protected abstract void initSharedMemory(double[] var1);
}

