/*
 * Decompiled with CFR 0.152.
 */
package labs;

import algorithms.distributed.BasicCommunication;
import distributedmodel.DistributedSystem;
import labs.BaseLabDS;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class Lab01R
extends BaseLabDS {
    @Override
    public void testAll() {
        boolean beVerbose = false;
        XYSeriesCollection seriesCollection2 = new XYSeriesCollection();
        XYSeries exp1 = this.seriesOfRuns("Naive version", node -> BasicCommunication.reduceNaive(node, (a, b) -> a + b), beVerbose);
        seriesCollection2.addSeries(exp1);
        XYSeries exp2 = this.seriesOfRuns("Correct version", node -> BasicCommunication.reduce(node, (a, b) -> a + b), beVerbose);
        seriesCollection2.addSeries(exp2);
        JFreeChart chart = Lab01R.makeChart(seriesCollection2, "Reduce performance", "Number of nodes", "Execution time [s]");
        Lab01R.displayChart(chart);
    }

    @Override
    protected void initNodesWithData(DistributedSystem ds) {
        int nNodes = ds.getConfiguration().getNumberOfNodes();
        double[][] initial_datas = Lab01R.generateRandomDataForNodes(nNodes, 1);
        for (int i = 0; i < nNodes; ++i) {
            ds.getNode(i).setMyData(initial_datas[i]);
        }
    }
}

