/*
 * Decompiled with CFR 0.152.
 */
package distributedmodel;

import distributedmodel.DataPacket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicBoolean;

class SynchronousNetworkChannel {
    private final BlockingQueue<DataPacket> mQueue;
    private final long mDelayConnect;
    private final long mDelayTransmit;
    private final AtomicBoolean mEnterLock;
    private final AtomicBoolean mExitLock;

    public SynchronousNetworkChannel(long delay_connect_milis, long delay_transmit_milis) {
        this.mDelayConnect = delay_connect_milis;
        this.mDelayTransmit = delay_transmit_milis;
        this.mQueue = new SynchronousQueue<DataPacket>();
        this.mEnterLock = new AtomicBoolean(true);
        this.mExitLock = new AtomicBoolean(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(DataPacket dp) throws InterruptedException {
        AtomicBoolean atomicBoolean = this.mEnterLock;
        synchronized (atomicBoolean) {
            if (this.mEnterLock.get()) {
                this.mEnterLock.wait();
            }
            this.mEnterLock.set(true);
        }
        Thread.sleep(this.mDelayConnect);
        this.mQueue.put(dp);
        Thread.sleep((long)dp.getData().length * this.mDelayTransmit);
        atomicBoolean = this.mExitLock;
        synchronized (atomicBoolean) {
            this.mExitLock.set(false);
            this.mExitLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataPacket receive() throws InterruptedException {
        AtomicBoolean atomicBoolean = this.mEnterLock;
        synchronized (atomicBoolean) {
            this.mEnterLock.set(false);
            this.mEnterLock.notify();
        }
        DataPacket dp = this.mQueue.take();
        AtomicBoolean atomicBoolean2 = this.mExitLock;
        synchronized (atomicBoolean2) {
            if (this.mExitLock.get()) {
                this.mExitLock.wait();
            }
            this.mExitLock.set(true);
        }
        return dp;
    }
}

