/*
 * Decompiled with CFR 0.152.
 */
package labs;

import distributedmodel.DSConfig;
import distributedmodel.DistributedSystem;
import java.util.Arrays;
import java.util.function.Consumer;
import labs.BaseLab;
import org.jfree.data.xy.XYSeries;
import software.SoftwareDS;
import software.SoftwareSM;

public abstract class BaseLabMixed
extends BaseLab {
    public static long DELAY_CONNECT_MILLIS = 100L;
    public static long DELAY_TRANSMIT_MILLIS = 10L;

    protected double singleMeasurement(DistributedSystem ds, SoftwareDS soft, boolean verbose) {
        ds.loadProgramToNodes(soft);
        if (verbose) {
            System.out.printf("BEFORE: %s%n", ds.toString());
        }
        long startTime = System.currentTimeMillis();
        ds.runSystem();
        long stopTime = System.currentTimeMillis();
        if (verbose) {
            System.out.printf("AFTER: %s%n", ds.toString());
        }
        double elapsedTime = (double)(stopTime - startTime) / 1000.0;
        return elapsedTime;
    }

    protected double singleMeasurement(DistributedSystem ds, SoftwareDS soft) {
        return this.singleMeasurement(ds, soft, true);
    }

    protected double singleTestRun(int nNodes, SoftwareDS soft, boolean verbose) {
        DSConfig config = new DSConfig(nNodes, DELAY_CONNECT_MILLIS, DELAY_TRANSMIT_MILLIS);
        DistributedSystem ds = new DistributedSystem(config);
        this.initNodesWithData(ds);
        double exTime = this.singleMeasurement(ds, soft, verbose);
        if (verbose) {
            System.out.printf("Processing took: %.2f sec.%n", exTime);
        }
        return exTime;
    }

    protected double singleTestRun(int nNodes, SoftwareDS soft) {
        return this.singleTestRun(nNodes, soft, true);
    }

    protected double singleTestRun(DSConfig conf, Consumer<DistributedSystem> nodeInitCode, SoftwareDS soft, boolean verbose) {
        DistributedSystem ds = new DistributedSystem(conf);
        nodeInitCode.accept(ds);
        double exTime = this.singleMeasurement(ds, soft, verbose);
        if (verbose) {
            System.out.printf("Processing took: %.2f sec.%n", exTime);
        }
        return exTime;
    }

    protected double singleTestRun(DSConfig conf, Consumer<DistributedSystem> nodeInitCode, SoftwareDS soft) {
        return this.singleTestRun(conf, nodeInitCode, soft, true);
    }

    protected XYSeries seriesOfRuns(String expName, SoftwareDS soft, boolean verbose) {
        int[] nNodes = new int[]{2, 4, 8, 16, 32};
        double[] exTimes = new double[nNodes.length];
        for (int i = 0; i < nNodes.length; ++i) {
            exTimes[i] = this.singleTestRun(nNodes[i], soft, verbose);
        }
        XYSeries series = new XYSeries((Comparable)((Object)expName));
        for (int i = 0; i < nNodes.length; ++i) {
            series.add((double)nNodes[i], exTimes[i]);
        }
        return series;
    }

    protected XYSeries seriesOfRuns(String expName, SoftwareDS soft) {
        return this.seriesOfRuns(expName, soft, true);
    }

    protected XYSeries seriesOfRuns(String expName, Consumer<DistributedSystem> nodeInitCode, SoftwareDS soft, boolean verbose) {
        int[] nNodes = new int[]{2, 4, 8, 16, 32};
        double[] exTimes = new double[nNodes.length];
        for (int i = 0; i < nNodes.length; ++i) {
            DSConfig config = new DSConfig(nNodes[i], DELAY_CONNECT_MILLIS, DELAY_TRANSMIT_MILLIS);
            exTimes[i] = this.singleTestRun(config, nodeInitCode, soft, verbose);
        }
        XYSeries series = new XYSeries((Comparable)((Object)expName));
        for (int i = 0; i < nNodes.length; ++i) {
            series.add((double)nNodes[i], exTimes[i]);
        }
        return series;
    }

    protected XYSeries seriesOfRuns(String expName, Consumer<DistributedSystem> nodeInitCode, SoftwareDS soft) {
        return this.seriesOfRuns(expName, nodeInitCode, soft, true);
    }

    protected double singleMeasurement(double[] data, SoftwareSM soft, boolean verbose) {
        if (verbose) {
            System.out.printf("Before: %s%n", Arrays.toString(data));
        }
        long startTime = System.currentTimeMillis();
        soft.instructions(data);
        long stopTime = System.currentTimeMillis();
        if (verbose) {
            System.out.printf("After: %s%n", Arrays.toString(data));
        }
        double elapsedTime = (double)(stopTime - startTime) / 1000.0;
        return elapsedTime;
    }

    protected double singleMeasurement(double[] data, SoftwareSM soft) {
        return this.singleMeasurement(data, soft, true);
    }

    protected double singleTestRun(int nElements, SoftwareSM soft, boolean verbose) {
        double[] data = new double[nElements];
        this.initSharedMemory(data);
        double exTime = this.singleMeasurement(data, soft, verbose);
        if (verbose) {
            System.out.printf("Processing took: %.2f sec.%n", exTime);
        }
        return exTime;
    }

    protected double singleTestRun(int nElements, SoftwareSM soft) {
        return this.singleTestRun(nElements, soft, true);
    }

    protected XYSeries seriesOfRuns(String expName, SoftwareSM soft, boolean verbose) {
        int[] nElements = new int[]{2, 4, 8, 16, 32, 64, 128};
        double[] exTimes = new double[nElements.length];
        for (int i = 0; i < nElements.length; ++i) {
            exTimes[i] = this.singleTestRun(nElements[i], soft, verbose);
        }
        XYSeries series = new XYSeries((Comparable)((Object)expName));
        for (int i = 0; i < nElements.length; ++i) {
            series.add((double)nElements[i], exTimes[i]);
        }
        return series;
    }

    protected XYSeries seriesOfRuns(String expName, SoftwareSM soft) {
        return this.seriesOfRuns(expName, soft, true);
    }

    protected abstract void initSharedMemory(double[] var1);

    protected abstract void initNodesWithData(DistributedSystem var1);
}

