/*
 * Decompiled with CFR 0.152.
 */
package labs;

import algorithms.distributed.BasicCommunication;
import algorithms.shared.BasicCommunicationSharedMem;
import distributedmodel.DistributedSystem;
import distributedmodel.Node;
import labs.BaseLabMixed;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class Lab02
extends BaseLabMixed {
    private void testDistributedAlgorithms() {
        boolean beVerbose = true;
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        XYSeries exp1 = this.seriesOfRuns("Naive version", (Node node) -> BasicCommunication.scanNaive(node, (a, b) -> a + b), beVerbose);
        seriesCollection.addSeries(exp1);
        XYSeries exp2 = this.seriesOfRuns("Correct version", (Node node) -> BasicCommunication.scan(node, (a, b) -> a + b), beVerbose);
        seriesCollection.addSeries(exp2);
        JFreeChart chart = Lab02.makeChart(seriesCollection, "Scan performance (distributed system)", "Number of nodes", "Execution time [s]");
        Lab02.displayChart(chart);
    }

    private void testSharedAlgorithms() {
        boolean beVerbose = true;
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        XYSeries exp1 = this.seriesOfRuns("Serial version", (double[] data) -> BasicCommunicationSharedMem.scanSerial(data, (a, b) -> a + b), beVerbose);
        seriesCollection.addSeries(exp1);
        XYSeries exp2 = this.seriesOfRuns("Correct version", (double[] data) -> BasicCommunicationSharedMem.scan(data, (a, b) -> a + b), beVerbose);
        seriesCollection.addSeries(exp2);
        JFreeChart chart = Lab02.makeChart(seriesCollection, "Scan performance (shared memory)", "Number of elements to reduce", "Execution time [s]");
        Lab02.displayChart(chart);
    }

    @Override
    protected void initSharedMemory(double[] data) {
        for (int j = 0; j < data.length; ++j) {
            data[j] = 1.0;
        }
    }

    @Override
    protected void initNodesWithData(DistributedSystem ds) {
        for (int j = 0; j < ds.getConfiguration().getNumberOfNodes(); ++j) {
            ds.getNode(j).setMyData(new double[]{1.0});
        }
    }

    @Override
    public void testAll() {
        this.testDistributedAlgorithms();
        this.testSharedAlgorithms();
    }
}

