/*
 * Decompiled with CFR 0.152.
 */
package algorithms.distributed;

import algorithms.Utils;
import distributedmodel.DataPacket;
import distributedmodel.Node;
import java.util.function.DoubleBinaryOperator;

public class BasicCommunication {
    public static void broadcast(Node node, boolean verbose) {
        int myIdx = node.getMyId();
        int nNodes = node.getNumberOfAllNodes();
        int mask = nNodes - 1;
        int powerOfTwo = nNodes;
        for (int i = Utils.binlog(powerOfTwo) - 1; i >= 0; --i) {
            if ((myIdx & (mask ^= (powerOfTwo >>= 1))) != 0) continue;
            if ((myIdx & powerOfTwo) == 0) {
                node.sendMyData(myIdx ^ powerOfTwo, verbose);
                continue;
            }
            node.receiveAndSet(verbose);
        }
    }

    public static void broadcast(Node node) {
        BasicCommunication.broadcast(node, true);
    }

    public static double[][] broadcastAll2All(Node node, boolean verbose) {
        int myIdx = node.getMyId();
        int nNodes = node.getNumberOfAllNodes();
        double[][] result = new double[nNodes][];
        int right = (myIdx + 1) % nNodes;
        double[] dataToSend = node.getMyData();
        result[myIdx] = (double[])dataToSend.clone();
        for (int i = 1; i < nNodes; ++i) {
            int source;
            DataPacket dpReceived = null;
            if (myIdx % 2 == 0) {
                node.send(right, dataToSend, verbose);
            } else {
                dpReceived = node.receive(verbose);
            }
            if (myIdx % 2 != 0) {
                node.send(right, dataToSend, verbose);
            } else {
                dpReceived = node.receive(verbose);
            }
            if (dpReceived != null) {
                dataToSend = dpReceived.getData();
            }
            if ((source = (myIdx - i) % nNodes) < 0) {
                source += nNodes;
            }
            result[source] = (double[])dataToSend.clone();
        }
        return result;
    }

    public static double[][] broadcastAll2AllNaive(Node node, boolean verbose) {
        int myIdx = node.getMyId();
        int nNodes = node.getNumberOfAllNodes();
        double[][] result = new double[nNodes][];
        double[] myInitialData = (double[])node.getMyData().clone();
        for (int i = 0; i < nNodes; ++i) {
            if (i != 0) {
                if (myIdx == 0) {
                    node.receiveAndSet(verbose);
                } else if (myIdx == i) {
                    node.send(0, myInitialData, verbose);
                }
            }
            BasicCommunication.broadcast(node, verbose);
            result[i] = (double[])node.getMyData().clone();
        }
        return result;
    }

    public static void broadcastNaive(Node node, boolean verbose) {
        int nNodes = node.getNumberOfAllNodes();
        int myIdx = node.getMyId();
        if (node.getMyData() != null) {
            node.sendMyData(myIdx + 1, verbose);
        } else {
            node.receiveAndSet(verbose);
            if (myIdx != nNodes - 1) {
                node.sendMyData(myIdx + 1, verbose);
            }
        }
    }

    public static void broadcastNaive(Node node) {
        BasicCommunication.broadcastNaive(node, true);
    }

    public static double[] exchangeWith(Node node, int otherId, double[] myData, boolean verbose) {
        double[] result;
        int myId = node.getMyId();
        if (myId < otherId) {
            node.send(otherId, myData, verbose);
            result = node.receive(verbose).getData();
        } else if (myId > otherId) {
            result = node.receive(verbose).getData();
            node.send(otherId, myData, verbose);
        } else {
            throw new RuntimeException(String.format("Node %d tries to exchange data with itself.%n", myId));
        }
        return result;
    }

    public static double[] exchangeWith(Node node, int otherId, double[] myData) {
        return BasicCommunication.exchangeWith(node, otherId, myData, true);
    }

    public static double exchangeWith(Node node, int otherId, double myData, boolean verbose) {
        double[] result;
        int myId = node.getMyId();
        if (myId < otherId) {
            node.send(otherId, new double[]{myData}, verbose);
            result = node.receive(verbose).getData();
        } else if (myId > otherId) {
            result = node.receive(verbose).getData();
            node.send(otherId, new double[]{myData}, verbose);
        } else {
            throw new RuntimeException(String.format("Node %d tries to exchange data with itself.%n", myId));
        }
        return result[0];
    }

    public static double exchangeWith(Node node, int otherId, double myData) {
        return BasicCommunication.exchangeWith(node, otherId, myData, true);
    }

    public static void reduce(Node node, DoubleBinaryOperator op, boolean verbose) {
        int myIdx = node.getMyId();
        int nNodes = node.getNumberOfAllNodes();
        int mask = 0;
        int powerOfTwo = 1;
        for (int i = 0; i < Utils.binlog(nNodes); ++i) {
            if ((myIdx & mask) == 0) {
                if ((myIdx & powerOfTwo) != 0) {
                    node.sendMyData(myIdx ^ powerOfTwo, verbose);
                } else {
                    DataPacket dp = node.receive(verbose);
                    double[] extData = dp.getData();
                    double[] myData = node.getMyData();
                    myData[0] = op.applyAsDouble(myData[0], extData[0]);
                    node.setMyData(myData);
                }
            }
            mask ^= powerOfTwo;
            powerOfTwo <<= 1;
        }
    }

    public static void reduce(Node node, DoubleBinaryOperator op) {
        BasicCommunication.reduce(node, op, true);
    }

    public static void reduceNaive(Node node, DoubleBinaryOperator op, boolean verbose) {
        int nNodes = node.getNumberOfAllNodes();
        int myIdx = node.getMyId();
        if (myIdx != nNodes - 1) {
            DataPacket dp = node.receive(verbose);
            double[] extData = dp.getData();
            double[] myData = node.getMyData();
            myData[0] = op.applyAsDouble(myData[0], extData[0]);
            node.setMyData(myData);
        }
        if (myIdx != 0) {
            node.sendMyData(myIdx - 1, verbose);
        }
    }

    public static void reduceNaive(Node node, DoubleBinaryOperator op) {
        BasicCommunication.reduceNaive(node, op, true);
    }

    public static void scatter(Node node, boolean verbose) {
        int myIdx = node.getMyId();
        int nNodes = node.getNumberOfAllNodes();
        int mask = nNodes - 1;
        int powerOfTwo = nNodes;
        for (int i = Utils.binlog(powerOfTwo) - 1; i >= 0; --i) {
            if ((myIdx & (mask ^= (powerOfTwo >>= 1))) != 0) continue;
            if ((myIdx & powerOfTwo) == 0) {
                double[] myData = node.getMyData();
                double[] myNewData = new double[myData.length / 2];
                double[] dataToSend = new double[myData.length - myNewData.length];
                System.arraycopy(myData, 0, myNewData, 0, myNewData.length);
                System.arraycopy(myData, myNewData.length, dataToSend, 0, dataToSend.length);
                node.setMyData(myNewData);
                node.send(myIdx ^ powerOfTwo, dataToSend, verbose);
                continue;
            }
            node.receiveAndSet(verbose);
        }
    }

    public static void scatter(Node node) {
        BasicCommunication.scatter(node, true);
    }

    public static void scatterNaive(Node node, boolean verbose) {
        int myIdx = node.getMyId();
        int nNodes = node.getNumberOfAllNodes();
        if (myIdx == 0) {
            double[] myData = node.getMyData();
            int partSize = myData.length / nNodes;
            double[] myNewData = new double[partSize];
            System.arraycopy(myData, 0, myNewData, 0, partSize);
            node.setMyData(myNewData);
            for (int i = 1; i < nNodes; ++i) {
                double[] dataToSend = new double[partSize];
                System.arraycopy(myData, i * partSize, dataToSend, 0, partSize);
                node.send(i, dataToSend, verbose);
            }
        } else {
            node.receiveAndSet(verbose);
        }
    }

    public static void scatterNaive(Node node) {
        BasicCommunication.scatterNaive(node, true);
    }

    public static void scanNaive(Node node, DoubleBinaryOperator op, boolean verbose) {
        int myIdx = node.getMyId();
        int nNodes = node.getNumberOfAllNodes();
        if (myIdx != 0) {
            double[] receivedData = node.receive(verbose).getData();
            double[] myData = node.getMyData();
            myData[0] = op.applyAsDouble(myData[0], receivedData[0]);
            node.setMyData(myData);
        }
        if (myIdx != nNodes - 1) {
            int destIdx = myIdx + 1;
            node.sendMyData(destIdx, verbose);
        }
    }

    public static void scanNaive(Node node, DoubleBinaryOperator op) {
        BasicCommunication.scanNaive(node, op, true);
    }

    public static void scan(Node node, DoubleBinaryOperator op, boolean verbose) {
        int i;
        int nNodes = node.getNumberOfAllNodes();
        int myIdx = node.getMyId();
        int mask = 0;
        int powerOfTwo = 1;
        for (i = 0; i < Utils.binlog(nNodes); ++i) {
            if ((myIdx & mask) == mask) {
                if ((myIdx & powerOfTwo) == 0) {
                    node.sendMyData(myIdx ^ powerOfTwo, verbose);
                } else {
                    DataPacket dp = node.receive(verbose);
                    double[] extData = dp.getData();
                    double[] myData = node.getMyData();
                    myData[0] = op.applyAsDouble(myData[0], extData[0]);
                    node.setMyData(myData);
                }
            }
            mask ^= powerOfTwo;
            powerOfTwo <<= 1;
        }
        for (i = Utils.binlog(nNodes) - 2; i >= 0; --i) {
            powerOfTwo = 1 << i;
            mask = powerOfTwo - 1;
            if ((myIdx & mask) != mask) continue;
            if ((myIdx & powerOfTwo) == powerOfTwo) {
                int destIdx = myIdx + powerOfTwo;
                if (destIdx >= nNodes - 1) continue;
                node.sendMyData(myIdx + powerOfTwo, verbose);
                continue;
            }
            int srcIdx = myIdx - powerOfTwo;
            if (srcIdx < 0) continue;
            DataPacket dp = node.receive(verbose);
            double[] extData = dp.getData();
            double[] myData = node.getMyData();
            myData[0] = op.applyAsDouble(myData[0], extData[0]);
            node.setMyData(myData);
        }
    }

    public static void scan(Node node, DoubleBinaryOperator op) {
        BasicCommunication.scan(node, op, true);
    }
}

