/*
 * Decompiled with CFR 0.152.
 */
package labs;

import distributedmodel.DSConfig;
import distributedmodel.DistributedSystem;
import labs.BaseLab;
import org.jfree.data.xy.XYSeries;
import software.SoftwareDS;

public abstract class BaseLabDS
extends BaseLab {
    public static long DELAY_CONNECT_MILLIS = 100L;
    public static long DELAY_TRANSMIT_MILLIS = 10L;

    protected double singleMeasurement(DistributedSystem ds, SoftwareDS soft, boolean verbose) {
        ds.loadProgramToNodes(soft);
        if (verbose) {
            System.out.printf("BEFORE: %s%n", ds.toString());
        }
        long startTime = System.currentTimeMillis();
        ds.runSystem();
        long stopTime = System.currentTimeMillis();
        if (verbose) {
            System.out.printf("AFTER: %s%n", ds.toString());
        }
        double elapsedTime = (double)(stopTime - startTime) / 1000.0;
        return elapsedTime;
    }

    protected double singleMeasurement(DistributedSystem ds, SoftwareDS soft) {
        return this.singleMeasurement(ds, soft, true);
    }

    protected double singleTestRun(int nNodes, SoftwareDS soft, boolean verbose) {
        DSConfig config = new DSConfig(nNodes, DELAY_CONNECT_MILLIS, DELAY_TRANSMIT_MILLIS);
        DistributedSystem ds = new DistributedSystem(config);
        this.initNodesWithData(ds);
        double exTime = this.singleMeasurement(ds, soft, verbose);
        if (verbose) {
            System.out.printf("Processing took: %.2f sec.%n", exTime);
        }
        return exTime;
    }

    protected XYSeries seriesOfRuns(String expName, SoftwareDS soft, boolean verbose) {
        int[] nNodes = new int[]{2, 4, 8, 16};
        double[] exTimes = new double[nNodes.length];
        for (int i = 0; i < nNodes.length; ++i) {
            exTimes[i] = this.singleTestRun(nNodes[i], soft, verbose);
        }
        XYSeries series = new XYSeries((Comparable)((Object)expName));
        for (int i = 0; i < nNodes.length; ++i) {
            series.add((double)nNodes[i], exTimes[i]);
        }
        return series;
    }

    protected abstract void initNodesWithData(DistributedSystem var1);
}

