/*
 * Decompiled with CFR 0.152.
 */
package algorithms.distributed;

import algorithms.Utils;
import algorithms.distributed.BasicCommunication;
import distributedmodel.Node;
import java.util.Arrays;

public class Sort {
    public static void compareExchange(Node node, int otherNode, Direction d, boolean verbose) {
        if (d == Direction.ASCENDING) {
            Sort.compareExchangeAsc(node, otherNode, verbose);
        } else {
            Sort.compareExchangeDesc(node, otherNode, verbose);
        }
    }

    private static void compareExchangeAsc(Node node, int otherNode, boolean verbose) {
        double myData = node.getMyData()[0];
        double otherData = BasicCommunication.exchangeWith(node, otherNode, myData, verbose);
        if (node.getMyId() < otherNode) {
            node.setMyData(new double[]{Math.min(myData, otherData)});
        } else {
            node.setMyData(new double[]{Math.max(myData, otherData)});
        }
    }

    private static void compareExchangeDesc(Node node, int otherNode, boolean verbose) {
        double myData = node.getMyData()[0];
        double otherData = BasicCommunication.exchangeWith(node, otherNode, myData, verbose);
        if (node.getMyId() > otherNode) {
            node.setMyData(new double[]{Math.min(myData, otherData)});
        } else {
            node.setMyData(new double[]{Math.max(myData, otherData)});
        }
    }

    public static void bitonicSortAsc(Node node, boolean verbose) {
        int myId = node.getMyId();
        double myData = node.getMyData()[0];
        int nNodes = node.getNumberOfAllNodes();
        int d = Utils.binlog(nNodes);
        for (int i = 0; i < d; ++i) {
            for (int j = i; j >= 0; --j) {
                int otherId = myId ^ 1 << j;
                double otherData = BasicCommunication.exchangeWith(node, otherId, myData, verbose);
                myData = (myId & 1 << i + 1) != 0 != ((myId & 1 << j) != 0) ? Math.max(myData, otherData) : Math.min(myData, otherData);
            }
        }
        node.setMyData(new double[]{myData});
    }

    public static void bitonicSortGeneralAsc(Node node, boolean verbose) {
        int myId = node.getMyId();
        int nNodes = node.getNumberOfAllNodes();
        int d = Utils.binlog(nNodes);
        double[] myData = node.getMyData();
        Arrays.sort(myData);
        for (int i = 0; i < d; ++i) {
            for (int j = i; j >= 0; --j) {
                int otherId = myId ^ 1 << j;
                double[] otherData = BasicCommunication.exchangeWith(node, otherId, myData, verbose);
                double[] merged = Utils.merge(myData, otherData);
                int midPos = merged.length >>> 1;
                if ((myId & 1 << i + 1) != 0 != ((myId & 1 << j) != 0)) {
                    myData = new double[merged.length - midPos];
                    System.arraycopy(merged, midPos, myData, 0, myData.length);
                    continue;
                }
                myData = new double[midPos];
                System.arraycopy(merged, 0, myData, 0, myData.length);
            }
        }
        node.setMyData(myData);
    }

    public static void compareSplit(Node node, int otherId, boolean verbose) {
        double[] myNewData;
        double[] otherdata = BasicCommunication.exchangeWith(node, otherId, node.getMyData(), verbose);
        double[] merged = Utils.merge(node.getMyData(), otherdata);
        int midPos = merged.length >>> 1;
        if (node.getMyId() < otherId) {
            myNewData = new double[midPos];
            System.arraycopy(merged, 0, myNewData, 0, myNewData.length);
        } else {
            myNewData = new double[merged.length - midPos];
            System.arraycopy(merged, midPos, myNewData, 0, myNewData.length);
        }
        node.setMyData(myNewData);
    }

    public static enum Direction {
        ASCENDING,
        DESCENDING;

    }
}

