/*
 * Decompiled with CFR 0.152.
 */
package distributedmodel;

import distributedmodel.DataPacket;
import distributedmodel.SynchronousNetworkChannel;

class NetworkEndpoint {
    private final int mId;
    private final SynchronousNetworkChannel[] mChannels;

    public NetworkEndpoint(int id, SynchronousNetworkChannel[] channels) {
        this.mId = id;
        this.mChannels = channels;
    }

    int getId() {
        return this.mId;
    }

    int getNumberOfChannels() {
        return this.mChannels.length;
    }

    DataPacket receive() throws InterruptedException {
        return this.mChannels[this.mId].receive();
    }

    void send(int destinationId, double[] data) throws InterruptedException {
        DataPacket dp = new DataPacket(data, this.mId, destinationId);
        this.send(dp);
    }

    void send(DataPacket dp) throws InterruptedException {
        if (dp.getDestinationId() == this.mId) {
            throw new RuntimeException(String.format("Node %d tries to send data to itself.", this.mId));
        }
        if (dp.getDestinationId() >= this.getNumberOfChannels()) {
            throw new RuntimeException(String.format("Node %d tries to send data to nonexisting node %d.", this.mId, dp.getDestinationId()));
        }
        this.mChannels[dp.getDestinationId()].send(dp);
    }
}

