/*
 *  This code is for Parallel and Distributed Algorithms
 *  laboratory at Gdansk University of Technology
 */
package algorithms.distributed;

import algorithms.Utils;
import algorithms.shared.SortSM;
import distributedmodel.Node;
import java.util.Arrays;

/**
 *
 * @author Karol Draszawka <kadr@eti.pg.gda.pl>
 */
public class Sort {
    
    public enum Half{
        LOWER,
        UPPER
    }
    
    /** Bitonic sort of the first elements of each node data.
     * 
     * @param node
     */
    public static void bitonicSortAsc(Node node){
        int myId = node.getMyId();
        double myData = node.getMyData()[0];
        int nNodes = node.getNumberOfAllNodes();
        int d = Utils.binlog(nNodes);
        
        for(int i = 0; i<d; ++i){
            for(int j = i; j >= 0; --j){
                int otherId = myId^(1<<j);
                double otherData = BasicCommunication.exchangeWith(node,
                        otherId, myData);
                
                //if in myId (i+1)-th bit is not equal to j-th bit
                if( ((myId&(1<<(i+1))) != 0) != ((myId&(1<<j)) != 0) ){
                    myData = Math.max(myData, otherData);
                }else{
                    myData = Math.min(myData, otherData);
                }
            }
        }
        node.setMyData(new double[]{myData});
    }
    
  
    
    
    /** Bitonic sort, when each node has n/nNodes part of the data. It is
     * important that each node has the same amount of data. Sorts in decreasing
     * order.
     * 
     * @param node
     */
    public static void bitonicSortGeneralizedDesc(Node node){
        
        //TODO
        throw new UnsupportedOperationException("Not supported yet.");
        
    }
    
    
    
    
    /** Exchanges data (has to be sorted in descending order!) between two nodes
     * that called the function with IDs of each other, then each of them merges
     * the data and takes a half of it, lower or upper depending of Half h
     * argument.
     * 
     * Example: 
     *          Before: node.myData = [10 6 4 1], otherId myData = [9 5 4 3], h = LOWER
     *          After:  node.myData = [4 4 3 1]
     * 
     *          Before: node.myData = [10 6 4 1], otherId myData = [9 5 4 3], h = UPPER
     *          After:  node.myData = [10 9 6 5]
     * 
     * 
     * @param node
     * @param otherId
     * @param h
     */
    public static void compareSplitDescending(Node node, int otherId, Half h){
        // OPTIONAL TODO
        // you can use Utils.mergeDescending helper function
        
    }
    
}
