/*
 *  This code is for Parallel and Distributed Algorithms
 *  laboratory at Gdansk University of Technology
 */
package algorithms.shared;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;

/**
 *
 * @author Karol Draszawka <kadr@eti.pg.gda.pl>
 */
public class SortSM {
    
    public static void serialQuicksort(double[] array){
        serialQuicksort(array, 0, array.length-1);
    }
    
    private static void serialQuicksort(double[] array, int sPos, int ePos){
        if(sPos < ePos){
            //Partition phase
            double pivot = array[ePos];
            int i = sPos - 1;
            for (int j = sPos; j<ePos; ++j){
                
                if(array[j]<=pivot){
                    ++i;
                    double tmp = array[j];
                    array[j] = array[i];
                    array[i] = tmp;
                }
            }
            int q = i+1;    //q is the partition point 
            array[ePos] = array[q];
            array[q] = pivot;
            
            //Recurential calls
            serialQuicksort(array, sPos, q-1);
            serialQuicksort(array, q+1, ePos);
        }
    }
    
    
    
    
    
    private static class QuickSortAction extends RecursiveAction{

        private QuickSortAction(double[] array) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void compute() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        
    }
    
    public static void QuicksortDescendingForkJoin(double[] array){
        ForkJoinPool pool = new ForkJoinPool();
        pool.invoke(new QuickSortAction(array));
    }
    
    
    
    
    
    private static class MaxToHead extends RecursiveAction{
        static final int THRESHOLD = 10;
        final double[] array;
        final int sPos;
        final int ePos;
        
        MaxToHead(double[] array, int sPos, int ePos){
            this.array = array; this.sPos = sPos; this.ePos = ePos;
        }
        MaxToHead(double[] array){
            this(array, 0, array.length-1);
        }
        
        @Override
        protected void compute() {
            if ((ePos - sPos) < THRESHOLD){
                computeDirectly();
            }
            else{
                int midPos = (ePos+sPos)/2;
                
                invokeAll(new MaxToHead(array, sPos, midPos-1),
                          new MaxToHead(array, midPos, ePos));
                
                array[sPos] = Math.max(array[sPos], array[midPos]);
            }
        
        }
        
        private void computeDirectly(){
            double maxValue = array[sPos];
            for(int i=sPos+1; i<ePos; ++i){
                if(array[i]>maxValue){
                    maxValue = array[i];
                }
            }
            array[sPos] = maxValue;  //maxValue to the first place
        }
        
    }
    
    
    public static void MaxToHeadForkJoin(double[] array){
        ForkJoinPool pool = new ForkJoinPool();
        pool.invoke(new MaxToHead(array));
    }
    
    
    
    
    
}
