/*
 *  This code is for Parallel and Distributed Algorithms
 *  laboratory at Gdansk University of Technology
 */

package algorithms.shared;

import datastructures.Matrix;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Karol Draszawka <kadr@eti.pg.gda.pl>
 */
public class MatrixOperationsSM {
    
    
    public static Matrix multiplyMtx(Matrix a, Matrix b,
                            int nThreadsPerRow, int nThreadsPerCol)
    {
        if(a.getNCols() != b.getNRows()){
            throw new RuntimeException("Matrices inner sizes mismatch");
        }
        if (a.getNRows()%nThreadsPerRow != 0){
            throw new RuntimeException("nThreadsPerRow has to divide "
                    + "the number of rows of matrix a.");
        }
        if (b.getNCols()%nThreadsPerCol != 0){
            throw new RuntimeException("nThreadsPerCol has to divide "
                    + "the number of columns of matrix b.");
        }
        
        Thread[][] workers = new Thread[nThreadsPerRow][nThreadsPerCol];
        final Matrix result = new Matrix(a.getNRows(), b.getNCols());
        
        
        // TODO
        // ...
        
        return result;
    }
    
    
}
