%% skrypt realizuje automat komorkowy "Zycie bez smierci"  012345678/3

close all;
clear all;
clc;

% bez tych trzech linijek animacja nie bedzie dzialac pod Windowsem:
opengl software;
figure(1)
set(gcf,'Renderer','OpenGL');
% dla animacji robionych pod Linuxem mozna te powyzsze linijki wykasowac

rozmiar = 50; % rozmiar planszy: 50x50

zycie = zeros(rozmiar,rozmiar);	   % biezaca plansza zycia
liczbaCykli = 100;                   % ile iteracji zrobic

zycie = fWczytajZycie(zycie,'formyZycia/clock.txt',24,24);


for n=1:liczbaCykli

    %--- KROK 1 ----------------------------------------------------
    % wyswietl cykl z tablicy zycie
    
    % najpierw znajdujemy niezerowe komorki na planszy zycia   
    [I,J] = find(zycie);
    % i tylko je wyswietlamy:
    % najpierw J - kolumny, potem 50-I - wiersze do gory nogami 
    % (bo y rosnie w gore, a numery wierszy rosna w dol)
    plot(J,rozmiar-I,'.','Marker', 's', 'MarkerFaceColor', 'b', 'MarkerSize', 4);
    axis([1 rozmiar 1 rozmiar]);
    daspect([1,1,1])    
    % napisz, ktory to cykl:
    text(2,2.5,['cykl ' num2str(n)]);
        
    %--- KROK 2 ----------------------------------------------------
    % oblicz stany komorek do nastepnego cyklu:
    
    zyciePom= zeros(rozmiar,rozmiar); % tworzymy plansze do odtwarzania zycia "za chwile"
    % dla kazdej z komorek polanszy zycie obliczamy, ile maja sasiadow
    % i w zaleznosci od ich liczby wstawiamy do zyciePom jedynke lub nic
    % nie wstawiamy
    
    for w=1:rozmiar
        for k=1:rozmiar
            sasiedzi = fPoliczSasiadow(zycie,w,k);
            if zycie(w,k)==1
                zyciePom(w,k)=1;
            elseif zycie(w,k)==0 && sasiedzi==3
                zyciePom(w,k)=1;
            end        
        end
    end
    
    %--- KROK 3 ----------------------------------------------------
    % przepisujemy wartosci z zyciePom do zycie
    
    % zerujemy znowu tablice zycie
    zycie= zeros(rozmiar,rozmiar);
    % gdzie w zyciuePom sa jedynki?
    [I,J] = find(zyciePom);
    liczbaNieZer = length(I);    
       
    % przepisujemy jedynki z zycie do zyciePom
    for m=1:liczbaNieZer
        zycie(I(m),J(m)) = zyciePom(I(m),J(m));
    end    
    
    % wykasuj ponizsze 4 linijki, jezeli twoja regula pozwala ozywac
    % martwym komorkom nieposiadajacym zywych sasiadow!!!!
    if liczbaNieZer==0
        disp('Wszystkie komorki umarly - nie dzialam dalej!');
        break;
    end

    F(n) = getframe;
end

movie2avi(F, 'ukosnikBezSmierci.avi', 'compression', 'None','fps',3,'quality',100)
