%% funkcja wczytuje na plansze forme zycia z pliku o danej nazwie
% forma zycia pojawi sie w x-tym wierszu i y-tej kolumnie tablicy

function planszaZwrotna = fWczytajZycie(plansza,nazwaPliku,x,y)

M = importdata(nazwaPliku,',');
[w, k] = size(M);

for n=1:w
	for m=1:k
		plansza(x+n,y+m) = M(n,m);
	end
end

% musimy przypisac do planszaZwrotna kazda komorke ze zmiennej plansza
% bo takie przypisanie:
%       planszaZwrotna = plansza
% niestety, nie zadzialaloby

% tworzymy kopie planszy - na poczatku zawiera same zera
% najpierw narzucamy te same rozmiary:
[wP,kP] = size(plansza);
planszaZwrotna = zeros(wP,kP);

% szukamy wspolrzedne niezerowych komorek w planszy:
[I,J] = find(plansza);
liczbaNieZer = length(I);

% przepisujemy tylko niezerowe wartosci do kopii planszy
for n=1:liczbaNieZer
    planszaZwrotna(I(n),J(n)) = plansza(I(n),J(n));
end

end

