//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop
#include "Filtry.h"
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#define PIXELSIZE 25
#define FILTR_DP_L 0
#define FILTR_DP_R 1
#define FILTR_GP_L 20
#define FILTR_GP_R 21
#define FILTR_M_L 30
#define FILTR_M_R 31
#define FILTR_L_L 40
#define FILTR_L_R 41

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TForm1 *Form1;

struct slajdy
{
   int FiltrDPnrSlajdu;
   int FiltrGPnrSlajdu;
   int FiltrMnrSlajdu;
   int FiltrLnrSlajdu;
};

struct okno
{
   int x;
   int y;
};
// -> matrix przechowuje wartosci kolorow pikseli
struct matrix
{
       int FiltrDP_L[12][12];
       int FiltrDP_R[12][12];
       int FiltrGP_L[12][12];
       int FiltrGP_R[12][12];
       int FiltrM_L[12][12];
       int FiltrM_R[12][12];
       int FiltrL_L[12][12];
       int FiltrL_R[12][12];
       okno OknoFDP_L;
       okno OknoFDP_R;
       okno OknoFGP_L;
       okno OknoFGP_R;
       okno OknoFM_L;
       okno OknoFM_R;
       okno OknoFL_L;
       okno OknoFL_R;
};

matrix Macierz;
int PixelW; // pixel wynikowy
slajdy Slajdy;



//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
         // inicjalizacja grafiki
         inicjalizacja();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::wyjscie1Click(TObject *Sender)
{
        PostQuitMessage(0);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Oprogramie1Click(TObject *Sender)
{
        MessageBox(NULL,"Mirosaw Czenczak\nMariusz uba\nDariusz Raczko","Autorzy programu",MB_ICONEXCLAMATION);
}


void RysujMacierz(int filtr)
{
   int i,j,kolor;

   for(i=0; i<12; i++)
      for(j=0; j<12; j++)
      {
         switch(filtr)
         {
            case FILTR_DP_L:
               kolor=Macierz.FiltrDP_L[i][j];
               Form1->FiltrDPImageLeft->Canvas->Pen->Color = clGray;
               Form1->FiltrDPImageLeft->Canvas->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrDPImageLeft->Canvas->FillRect(Rect(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE,i*PIXELSIZE+PIXELSIZE));
               Form1->FiltrDPImageLeft->Canvas->Rectangle(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE+1,i*PIXELSIZE+PIXELSIZE+1);
               break;
            case FILTR_DP_R:
               kolor=Macierz.FiltrDP_R[i][j];
               Form1->FiltrDPImageRight->Canvas->Pen->Color = clGray;
               Form1->FiltrDPImageRight->Canvas->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrDPImageRight->Canvas->FillRect(Rect(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE,i*PIXELSIZE+PIXELSIZE));
               Form1->FiltrDPImageRight->Canvas->Rectangle(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE+1,i*PIXELSIZE+PIXELSIZE+1);
               break;
             case FILTR_GP_L:
               kolor=Macierz.FiltrGP_L[i][j];
               Form1->FiltrGPImageLeft->Canvas->Pen->Color = clGray;
               Form1->FiltrGPImageLeft->Canvas->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrGPImageLeft->Canvas->FillRect(Rect(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE,i*PIXELSIZE+PIXELSIZE));
               Form1->FiltrGPImageLeft->Canvas->Rectangle(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE+1,i*PIXELSIZE+PIXELSIZE+1);
               break;
            case FILTR_GP_R:
               kolor=Macierz.FiltrGP_R[i][j];
               Form1->FiltrGPImageRight->Canvas->Pen->Color = clGray;
               Form1->FiltrGPImageRight->Canvas->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrGPImageRight->Canvas->FillRect(Rect(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE,i*PIXELSIZE+PIXELSIZE));
               Form1->FiltrGPImageRight->Canvas->Rectangle(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE+1,i*PIXELSIZE+PIXELSIZE+1);
               break;
            case FILTR_M_L:
               kolor=Macierz.FiltrM_L[i][j];
               Form1->FiltrMImageLeft->Canvas->Pen->Color = clGray;
               Form1->FiltrMImageLeft->Canvas->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrMImageLeft->Canvas->FillRect(Rect(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE,i*PIXELSIZE+PIXELSIZE));
               Form1->FiltrMImageLeft->Canvas->Rectangle(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE+1,i*PIXELSIZE+PIXELSIZE+1);
               break;
            case FILTR_M_R:
               kolor=Macierz.FiltrM_R[i][j];
               Form1->FiltrMImageRight->Canvas->Pen->Color = clGray;
               Form1->FiltrMImageRight->Canvas->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrMImageRight->Canvas->FillRect(Rect(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE,i*PIXELSIZE+PIXELSIZE));
               Form1->FiltrMImageRight->Canvas->Rectangle(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE+1,i*PIXELSIZE+PIXELSIZE+1);
               break;
            case FILTR_L_L:
               kolor=Macierz.FiltrL_L[i][j];
               Form1->FiltrLImageLeft->Canvas->Pen->Color = clGray;
               Form1->FiltrLImageLeft->Canvas->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrLImageLeft->Canvas->FillRect(Rect(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE,i*PIXELSIZE+PIXELSIZE));
               Form1->FiltrLImageLeft->Canvas->Rectangle(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE+1,i*PIXELSIZE+PIXELSIZE+1);
               break;
            case FILTR_L_R:
               kolor=Macierz.FiltrL_R[i][j];
               Form1->FiltrLImageRight->Canvas->Pen->Color = clGray;
               Form1->FiltrLImageRight->Canvas->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrLImageRight->Canvas->FillRect(Rect(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE,i*PIXELSIZE+PIXELSIZE));
               Form1->FiltrLImageRight->Canvas->Rectangle(j*PIXELSIZE,i*PIXELSIZE,j*PIXELSIZE+PIXELSIZE+1,i*PIXELSIZE+PIXELSIZE+1);
               break;
         }
      }
}

void inicjalizacja(void)
{
        // zaladowanie miniaturowych obrazkow z pliku
        Form1->FiltrGPzachod1->Picture->Bitmap->LoadFromFile("images\\zachod.bmp");
        Form1->FiltrGPzachod2->Picture->Bitmap->LoadFromFile("images\\zachod.bmp");
        Form1->FiltrDPzachod1->Picture->Bitmap->LoadFromFile("images\\zachod.bmp");
        Form1->FiltrDPzachod2->Picture->Bitmap->LoadFromFile("images\\zachod.bmp");
        Form1->FiltrMzachod1->Picture->Bitmap->LoadFromFile("images\\zachod.bmp");
        Form1->FiltrMzachod2->Picture->Bitmap->LoadFromFile("images\\zachod.bmp");
        Form1->FiltrLzachod1->Picture->Bitmap->LoadFromFile("images\\zachod.bmp");
        Form1->FiltrLzachod2->Picture->Bitmap->LoadFromFile("images\\zachod.bmp");
        // zaladowanie obrazow z plikow do przykladow
        Form1->FiltrDP_P1_ImageLeft->Picture->Bitmap->LoadFromFile("images\\FDP_P1.bmp");
        Form1->FiltrDP_P1_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P1.bmp");
        Form1->FiltrDP_P2_ImageLeft->Picture->Bitmap->LoadFromFile("images\\FDP_P2.bmp");
        Form1->FiltrDP_P2_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P2.bmp");
        Form1->FiltrGP_P1_ImageLeft->Picture->Bitmap->LoadFromFile("images\\FDP_P1.bmp");
        Form1->FiltrGP_P1_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P1.bmp");
        Form1->FiltrGP_P2_ImageLeft->Picture->Bitmap->LoadFromFile("images\\FDP_P2.bmp");
        Form1->FiltrGP_P2_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P2.bmp");
        Form1->FiltrL_P1_ImageLeft->Picture->Bitmap->LoadFromFile("images\\FDP_P1.bmp");
        Form1->FiltrL_P1_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P1.bmp");
        Form1->FiltrL_P2_ImageLeft->Picture->Bitmap->LoadFromFile("images\\FDP_P2.bmp");
        Form1->FiltrL_P2_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P2.bmp");
        Form1->FiltrM_P1_ImageLeft->Picture->Bitmap->LoadFromFile("images\\FDP_P1.bmp");
        Form1->FiltrM_P1_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P1.bmp");
        Form1->FiltrM_P2_ImageLeft->Picture->Bitmap->LoadFromFile("images\\FDP_P2.bmp");
        Form1->FiltrM_P2_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P2.bmp");
        Form1->FiltrM_P3_ImageLeft->Picture->Bitmap->LoadFromFile("images\\zaszumiony.bmp");
        Form1->FiltrM_P3_ImageRight->Picture->Bitmap->LoadFromFile("images\\zaszumiony.bmp");
        // zaladowanie wzoru
        Form1->FiltrDPWzor->Picture->Bitmap->LoadFromFile("images\\wzor.bmp");
        Form1->FiltrGPWzor->Picture->Bitmap->LoadFromFile("images\\wzor.bmp");
        Form1->FiltrLWzor->Picture->Bitmap->LoadFromFile("images\\wzor.bmp");
        // ramki dookola obrazkow
        TPoint punkty[5];
        punkty[0].x=0; punkty[1].x=99; punkty[2].x=99;  punkty[3].x=0;  punkty[4].x=0;
        punkty[0].y=0; punkty[1].y=0;  punkty[2].y=74;  punkty[3].y=74; punkty[4].y=0;
        Form1->FiltrGPzachod1->Canvas->Pen->Color = clBlack;
        Form1->FiltrGPzachod1->Canvas->Polyline(punkty,4);
        Form1->FiltrGPzachod2->Canvas->Pen->Color = clBlack;
        Form1->FiltrGPzachod2->Canvas->Polyline(punkty,4);
        Form1->FiltrDPzachod1->Canvas->Pen->Color = clBlack;
        Form1->FiltrDPzachod1->Canvas->Polyline(punkty,4);
        Form1->FiltrDPzachod2->Canvas->Pen->Color = clBlack;
        Form1->FiltrDPzachod2->Canvas->Polyline(punkty,4);
        Form1->FiltrMzachod1->Canvas->Pen->Color = clBlack;
        Form1->FiltrMzachod1->Canvas->Polyline(punkty,4);
        Form1->FiltrMzachod2->Canvas->Pen->Color = clBlack;
        Form1->FiltrMzachod2->Canvas->Polyline(punkty,4);

        ///////////////////////////
        // Filtr dolnoprzepustowy
        ///////////////////////////
        // linie powiekszenia
        Form1->TloFDP->Canvas->Brush->Color = clBtnFace;
        Form1->TloFDP->Canvas->FillRect(TRect(0,0,970,550));
        Form1->TloFDP->Canvas->MoveTo(12,312);
        Form1->TloFDP->Canvas->LineTo(111,371);
        Form1->TloFDP->Canvas->MoveTo(12,12);
        Form1->TloFDP->Canvas->LineTo(111,361);
        Form1->TloFDP->Canvas->MoveTo(312,12);
        Form1->TloFDP->Canvas->LineTo(119,361);
        Form1->TloFDP->Canvas->MoveTo(312,312);
        Form1->TloFDP->Canvas->LineTo(146,361);
        // mini obrazek
        // ramka
        Form1->FiltrDPzachod1->Canvas->MoveTo(10,10);
        Form1->FiltrDPzachod1->Canvas->LineTo(20,10);
        Form1->FiltrDPzachod1->Canvas->LineTo(20,20);
        Form1->FiltrDPzachod1->Canvas->LineTo(10,20);
        Form1->FiltrDPzachod1->Canvas->LineTo(10,10);
        // linie
        Form1->FiltrDPzachod1->Canvas->MoveTo(10,10);
        Form1->FiltrDPzachod1->Canvas->LineTo(8,0);
        Form1->FiltrDPzachod1->Canvas->MoveTo(20,10);
        Form1->FiltrDPzachod1->Canvas->LineTo(25,0);
        Form1->FiltrDPzachod1->Canvas->MoveTo(20,20);
        Form1->FiltrDPzachod1->Canvas->LineTo(84,0);
        Form1->FiltrDPzachod1->Canvas->MoveTo(10,20);
        Form1->FiltrDPzachod1->Canvas->LineTo(0,14);
         // linie powiekszenia
        Form1->TloFDP->Canvas->MoveTo(650+12,312);
        Form1->TloFDP->Canvas->LineTo(650+111,371);
        Form1->TloFDP->Canvas->MoveTo(650+12,12);
        Form1->TloFDP->Canvas->LineTo(650+111,361);
        Form1->TloFDP->Canvas->MoveTo(650+312,12);
        Form1->TloFDP->Canvas->LineTo(650+119,361);
        Form1->TloFDP->Canvas->MoveTo(650+312,312);
        Form1->TloFDP->Canvas->LineTo(650+146,361);
        // mini obrazek
        // ramka
        Form1->FiltrDPzachod2->Canvas->MoveTo(10,10);
        Form1->FiltrDPzachod2->Canvas->LineTo(20,10);
        Form1->FiltrDPzachod2->Canvas->LineTo(20,20);
        Form1->FiltrDPzachod2->Canvas->LineTo(10,20);
        Form1->FiltrDPzachod2->Canvas->LineTo(10,10);
        // linie
        Form1->FiltrDPzachod2->Canvas->MoveTo(10,10);
        Form1->FiltrDPzachod2->Canvas->LineTo(8,0);
        Form1->FiltrDPzachod2->Canvas->MoveTo(20,10);
        Form1->FiltrDPzachod2->Canvas->LineTo(25,0);
        Form1->FiltrDPzachod2->Canvas->MoveTo(20,20);
        Form1->FiltrDPzachod2->Canvas->LineTo(84,0);
        Form1->FiltrDPzachod2->Canvas->MoveTo(10,20);
        Form1->FiltrDPzachod2->Canvas->LineTo(0,14);

        ///////////////////////////
        // Filtr gornoprzepustowy
        ///////////////////////////
        // linie powiekszenia
        Form1->TloFGP->Canvas->Brush->Color = clBtnFace;
        Form1->TloFGP->Canvas->FillRect(TRect(0,0,970,550));
        Form1->TloFGP->Canvas->MoveTo(12,312);
        Form1->TloFGP->Canvas->LineTo(111,371);
        Form1->TloFGP->Canvas->MoveTo(12,12);
        Form1->TloFGP->Canvas->LineTo(111,361);
        Form1->TloFGP->Canvas->MoveTo(312,12);
        Form1->TloFGP->Canvas->LineTo(119,361);
        Form1->TloFGP->Canvas->MoveTo(312,312);
        Form1->TloFGP->Canvas->LineTo(146,361);
        // mini obrazek
        // ramka
        Form1->FiltrGPzachod1->Canvas->MoveTo(10,10);
        Form1->FiltrGPzachod1->Canvas->LineTo(20,10);
        Form1->FiltrGPzachod1->Canvas->LineTo(20,20);
        Form1->FiltrGPzachod1->Canvas->LineTo(10,20);
        Form1->FiltrGPzachod1->Canvas->LineTo(10,10);
        // linie
        Form1->FiltrGPzachod1->Canvas->MoveTo(10,10);
        Form1->FiltrGPzachod1->Canvas->LineTo(8,0);
        Form1->FiltrGPzachod1->Canvas->MoveTo(20,10);
        Form1->FiltrGPzachod1->Canvas->LineTo(25,0);
        Form1->FiltrGPzachod1->Canvas->MoveTo(20,20);
        Form1->FiltrGPzachod1->Canvas->LineTo(84,0);
        Form1->FiltrGPzachod1->Canvas->MoveTo(10,20);
        Form1->FiltrGPzachod1->Canvas->LineTo(0,14);
         // linie powiekszenia
        Form1->TloFGP->Canvas->MoveTo(650+12,312);
        Form1->TloFGP->Canvas->LineTo(650+111,371);
        Form1->TloFGP->Canvas->MoveTo(650+12,12);
        Form1->TloFGP->Canvas->LineTo(650+111,361);
        Form1->TloFGP->Canvas->MoveTo(650+312,12);
        Form1->TloFGP->Canvas->LineTo(650+119,361);
        Form1->TloFGP->Canvas->MoveTo(650+312,312);
        Form1->TloFGP->Canvas->LineTo(650+146,361);
        // mini obrazek
        // ramka
        Form1->FiltrGPzachod2->Canvas->MoveTo(10,10);
        Form1->FiltrGPzachod2->Canvas->LineTo(20,10);
        Form1->FiltrGPzachod2->Canvas->LineTo(20,20);
        Form1->FiltrGPzachod2->Canvas->LineTo(10,20);
        Form1->FiltrGPzachod2->Canvas->LineTo(10,10);
        // linie
        Form1->FiltrGPzachod2->Canvas->MoveTo(10,10);
        Form1->FiltrGPzachod2->Canvas->LineTo(8,0);
        Form1->FiltrGPzachod2->Canvas->MoveTo(20,10);
        Form1->FiltrGPzachod2->Canvas->LineTo(25,0);
        Form1->FiltrGPzachod2->Canvas->MoveTo(20,20);
        Form1->FiltrGPzachod2->Canvas->LineTo(84,0);
        Form1->FiltrGPzachod2->Canvas->MoveTo(10,20);
        Form1->FiltrGPzachod2->Canvas->LineTo(0,14);

        ////////////////////
        // Filtr medianowy
        ////////////////////
        // linie powiekszenia
        Form1->TloFM->Canvas->Brush->Color = clBtnFace;
        Form1->TloFM->Canvas->FillRect(TRect(0,0,970,550));
        Form1->TloFM->Canvas->MoveTo(12,312);
        Form1->TloFM->Canvas->LineTo(111,371);
        Form1->TloFM->Canvas->MoveTo(12,12);
        Form1->TloFM->Canvas->LineTo(111,361);
        Form1->TloFM->Canvas->MoveTo(312,12);
        Form1->TloFM->Canvas->LineTo(119,361);
        Form1->TloFM->Canvas->MoveTo(312,312);
        Form1->TloFM->Canvas->LineTo(146,361);
        // mini obrazek
        // ramka
        Form1->FiltrMzachod1->Canvas->MoveTo(10,10);
        Form1->FiltrMzachod1->Canvas->LineTo(20,10);
        Form1->FiltrMzachod1->Canvas->LineTo(20,20);
        Form1->FiltrMzachod1->Canvas->LineTo(10,20);
        Form1->FiltrMzachod1->Canvas->LineTo(10,10);
        // linie
        Form1->FiltrMzachod1->Canvas->MoveTo(10,10);
        Form1->FiltrMzachod1->Canvas->LineTo(8,0);
        Form1->FiltrMzachod1->Canvas->MoveTo(20,10);
        Form1->FiltrMzachod1->Canvas->LineTo(25,0);
        Form1->FiltrMzachod1->Canvas->MoveTo(20,20);
        Form1->FiltrMzachod1->Canvas->LineTo(84,0);
        Form1->FiltrMzachod1->Canvas->MoveTo(10,20);
        Form1->FiltrMzachod1->Canvas->LineTo(0,14);
         // linie powiekszenia
        Form1->TloFM->Canvas->MoveTo(650+12,312);
        Form1->TloFM->Canvas->LineTo(650+111,371);
        Form1->TloFM->Canvas->MoveTo(650+12,12);
        Form1->TloFM->Canvas->LineTo(650+111,361);
        Form1->TloFM->Canvas->MoveTo(650+312,12);
        Form1->TloFM->Canvas->LineTo(650+119,361);
        Form1->TloFM->Canvas->MoveTo(650+312,312);
        Form1->TloFM->Canvas->LineTo(650+146,361);
        // mini obrazek
        // ramka
        Form1->FiltrMzachod2->Canvas->MoveTo(10,10);
        Form1->FiltrMzachod2->Canvas->LineTo(20,10);
        Form1->FiltrMzachod2->Canvas->LineTo(20,20);
        Form1->FiltrMzachod2->Canvas->LineTo(10,20);
        Form1->FiltrMzachod2->Canvas->LineTo(10,10);
        // linie
        Form1->FiltrMzachod2->Canvas->MoveTo(10,10);
        Form1->FiltrMzachod2->Canvas->LineTo(8,0);
        Form1->FiltrMzachod2->Canvas->MoveTo(20,10);
        Form1->FiltrMzachod2->Canvas->LineTo(25,0);
        Form1->FiltrMzachod2->Canvas->MoveTo(20,20);
        Form1->FiltrMzachod2->Canvas->LineTo(84,0);
        Form1->FiltrMzachod2->Canvas->MoveTo(10,20);
        Form1->FiltrMzachod2->Canvas->LineTo(0,14);

        ////////////////////
        // Filtr Laplace'a
        ////////////////////
        // linie powiekszenia
        Form1->TloFL->Canvas->Brush->Color = clBtnFace;
        Form1->TloFL->Canvas->FillRect(TRect(0,0,970,550));
        Form1->TloFL->Canvas->MoveTo(12,312);
        Form1->TloFL->Canvas->LineTo(111,371);
        Form1->TloFL->Canvas->MoveTo(12,12);
        Form1->TloFL->Canvas->LineTo(111,361);
        Form1->TloFL->Canvas->MoveTo(312,12);
        Form1->TloFL->Canvas->LineTo(119,361);
        Form1->TloFL->Canvas->MoveTo(312,312);
        Form1->TloFL->Canvas->LineTo(146,361);
        // mini obrazek
        // ramka
        Form1->FiltrLzachod1->Canvas->MoveTo(10,10);
        Form1->FiltrLzachod1->Canvas->LineTo(20,10);
        Form1->FiltrLzachod1->Canvas->LineTo(20,20);
        Form1->FiltrLzachod1->Canvas->LineTo(10,20);
        Form1->FiltrLzachod1->Canvas->LineTo(10,10);
        // linie
        Form1->FiltrLzachod1->Canvas->MoveTo(10,10);
        Form1->FiltrLzachod1->Canvas->LineTo(8,0);
        Form1->FiltrLzachod1->Canvas->MoveTo(20,10);
        Form1->FiltrLzachod1->Canvas->LineTo(25,0);
        Form1->FiltrLzachod1->Canvas->MoveTo(20,20);
        Form1->FiltrLzachod1->Canvas->LineTo(84,0);
        Form1->FiltrLzachod1->Canvas->MoveTo(10,20);
        Form1->FiltrLzachod1->Canvas->LineTo(0,14);
         // linie powiekszenia
        Form1->TloFL->Canvas->MoveTo(650+12,312);
        Form1->TloFL->Canvas->LineTo(650+111,371);
        Form1->TloFL->Canvas->MoveTo(650+12,12);
        Form1->TloFL->Canvas->LineTo(650+111,361);
        Form1->TloFL->Canvas->MoveTo(650+312,12);
        Form1->TloFL->Canvas->LineTo(650+119,361);
        Form1->TloFL->Canvas->MoveTo(650+312,312);
        Form1->TloFL->Canvas->LineTo(650+146,361);
        // mini obrazek
        // ramka
        Form1->FiltrLzachod2->Canvas->MoveTo(10,10);
        Form1->FiltrLzachod2->Canvas->LineTo(20,10);
        Form1->FiltrLzachod2->Canvas->LineTo(20,20);
        Form1->FiltrLzachod2->Canvas->LineTo(10,20);
        Form1->FiltrLzachod2->Canvas->LineTo(10,10);
        // linie
        Form1->FiltrLzachod2->Canvas->MoveTo(10,10);
        Form1->FiltrLzachod2->Canvas->LineTo(8,0);
        Form1->FiltrLzachod2->Canvas->MoveTo(20,10);
        Form1->FiltrLzachod2->Canvas->LineTo(25,0);
        Form1->FiltrLzachod2->Canvas->MoveTo(20,20);
        Form1->FiltrLzachod2->Canvas->LineTo(84,0);
        Form1->FiltrLzachod2->Canvas->MoveTo(10,20);
        Form1->FiltrLzachod2->Canvas->LineTo(0,14);

        ////////////////////////////////////////
        // Ladowanie z plikow wartosci pikseli
        ////////////////////////////////////////
        FILE *fpDP, *fpGP, *fpM, *fpL;

        int i,j;

        char kolorDP[4],kolorGP[4],kolorM[4],kolorL[4];  // maksymalnie 3 znaki -> 0..255  + \0

        // incjalizacja PRAWEGO powiekszenia obrazka
        // przez odczytanie wartosci pikseli z plikow
        fpDP = fopen("zoom\\FiltrDP.txt","rt");
        fpGP = fopen("zoom\\FiltrGP.txt","rt");
        fpM  = fopen("zoom\\FiltrM.txt","rt");
        fpL  = fopen("zoom\\FiltrL.txt","rt");

        for(i=0; i<12; i++)
        {
            for(j=0; j<12; j++)
            {
               fscanf(fpDP,"%s ",kolorDP);
               fscanf(fpGP,"%s ",kolorGP);
               fscanf(fpM,"%s ",kolorM);
               fscanf(fpL,"%s ",kolorL);
               Macierz.FiltrDP_L[i][j] = atoi(kolorDP);
               Macierz.FiltrGP_L[i][j] = atoi(kolorGP);
               Macierz.FiltrM_L[i][j] = atoi(kolorM);
               Macierz.FiltrL_L[i][j] = atoi(kolorL);
               Macierz.FiltrDP_R[i][j] = 255;
               Macierz.FiltrGP_R[i][j] = 255;
               Macierz.FiltrM_R[i][j] = 255;
               Macierz.FiltrL_R[i][j] = 255;
            }
        }
        fclose(fpDP);
        fclose(fpGP);
        fclose(fpM);
        fclose(fpL);
        RysujMacierz(FILTR_DP_L);
        RysujMacierz(FILTR_GP_L);
        RysujMacierz(FILTR_M_L);
        RysujMacierz(FILTR_L_L);
        RysujMacierz(FILTR_DP_R);
        RysujMacierz(FILTR_GP_R);
        RysujMacierz(FILTR_M_R);
        RysujMacierz(FILTR_L_R);
        // inicjalizacja okien filtru (okna prostokatne 3x3)
        Macierz.OknoFDP_L.x = 0;
        Macierz.OknoFDP_L.y = 0;
        Macierz.OknoFGP_L.x = 0;
        Macierz.OknoFGP_L.y = 0;
        Macierz.OknoFM_L.x = 0;
        Macierz.OknoFM_L.y = 0;
        Macierz.OknoFL_L.x = 0;
        Macierz.OknoFL_L.y = 0;
        // inicjalizacja okien filtru (okna prostokatne 1x1)
        Macierz.OknoFDP_R.x = 1;
        Macierz.OknoFDP_R.y = 1;
        Macierz.OknoFGP_R.x = 1;
        Macierz.OknoFGP_R.y = 1;
        Macierz.OknoFM_R.x = 1;
        Macierz.OknoFM_R.y = 1;
        Macierz.OknoFL_R.x = 1;
        Macierz.OknoFL_R.y = 1;
        // ustawienie numerow slajdow na startowe (0)
        Slajdy.FiltrDPnrSlajdu = 0;
        Slajdy.FiltrGPnrSlajdu = 0;
        Slajdy.FiltrMnrSlajdu = 0;
        Slajdy.FiltrLnrSlajdu = 0;
}

//----------------------------------------------------------------------

void RysujOkno(int filtr)
{
   int i,j,kolor;

   switch(filtr)
   {
      case FILTR_DP_L:
         Form1->FiltrDPImageLeft->Canvas->Pen->Color = clRed;
         Form1->FiltrDPImageLeft->Canvas->Pen->Width = 2;
         Form1->FiltrDPImageLeft->Canvas->MoveTo(Macierz.OknoFDP_L.x*PIXELSIZE+1,Macierz.OknoFDP_L.y*PIXELSIZE+1);
         Form1->FiltrDPImageLeft->Canvas->LineTo(Macierz.OknoFDP_L.x*PIXELSIZE+1+3*PIXELSIZE,Macierz.OknoFDP_L.y*PIXELSIZE);
         Form1->FiltrDPImageLeft->Canvas->LineTo(Macierz.OknoFDP_L.x*PIXELSIZE+3*PIXELSIZE,Macierz.OknoFDP_L.y*PIXELSIZE+3*PIXELSIZE);
         Form1->FiltrDPImageLeft->Canvas->LineTo(Macierz.OknoFDP_L.x*PIXELSIZE,Macierz.OknoFDP_L.y*PIXELSIZE+3*PIXELSIZE);
         Form1->FiltrDPImageLeft->Canvas->LineTo(Macierz.OknoFDP_L.x*PIXELSIZE+1,Macierz.OknoFDP_L.y*PIXELSIZE+1);
         Form1->FiltrDPImageLeft->Canvas->Pen->Width = 1;
         break;
      case FILTR_GP_L:
         Form1->FiltrGPImageLeft->Canvas->Pen->Color = clRed;
         Form1->FiltrGPImageLeft->Canvas->Pen->Width = 2;
         Form1->FiltrGPImageLeft->Canvas->MoveTo(Macierz.OknoFGP_L.x*PIXELSIZE+1,Macierz.OknoFGP_L.y*PIXELSIZE+1);
         Form1->FiltrGPImageLeft->Canvas->LineTo(Macierz.OknoFGP_L.x*PIXELSIZE+1+3*PIXELSIZE,Macierz.OknoFGP_L.y*PIXELSIZE);
         Form1->FiltrGPImageLeft->Canvas->LineTo(Macierz.OknoFGP_L.x*PIXELSIZE+3*PIXELSIZE,Macierz.OknoFGP_L.y*PIXELSIZE+3*PIXELSIZE);
         Form1->FiltrGPImageLeft->Canvas->LineTo(Macierz.OknoFGP_L.x*PIXELSIZE,Macierz.OknoFGP_L.y*PIXELSIZE+3*PIXELSIZE);
         Form1->FiltrGPImageLeft->Canvas->LineTo(Macierz.OknoFGP_L.x*PIXELSIZE+1,Macierz.OknoFGP_L.y*PIXELSIZE+1);
         Form1->FiltrGPImageLeft->Canvas->Pen->Width = 1;
         break;
      case FILTR_M_L:
         Form1->FiltrMImageLeft->Canvas->Pen->Color = clRed;
         Form1->FiltrMImageLeft->Canvas->Pen->Width = 2;
         Form1->FiltrMImageLeft->Canvas->MoveTo(Macierz.OknoFM_L.x*PIXELSIZE+1,Macierz.OknoFM_L.y*PIXELSIZE+1);
         Form1->FiltrMImageLeft->Canvas->LineTo(Macierz.OknoFM_L.x*PIXELSIZE+1+3*PIXELSIZE,Macierz.OknoFM_L.y*PIXELSIZE);
         Form1->FiltrMImageLeft->Canvas->LineTo(Macierz.OknoFM_L.x*PIXELSIZE+3*PIXELSIZE,Macierz.OknoFM_L.y*PIXELSIZE+3*PIXELSIZE);
         Form1->FiltrMImageLeft->Canvas->LineTo(Macierz.OknoFM_L.x*PIXELSIZE,Macierz.OknoFM_L.y*PIXELSIZE+3*PIXELSIZE);
         Form1->FiltrMImageLeft->Canvas->LineTo(Macierz.OknoFM_L.x*PIXELSIZE+1,Macierz.OknoFM_L.y*PIXELSIZE+1);
         Form1->FiltrMImageLeft->Canvas->Pen->Width = 1;
         break;
      case FILTR_L_L:
         Form1->FiltrLImageLeft->Canvas->Pen->Color = clRed;
         Form1->FiltrLImageLeft->Canvas->Pen->Width = 2;
         Form1->FiltrLImageLeft->Canvas->MoveTo(Macierz.OknoFL_L.x*PIXELSIZE+1,Macierz.OknoFL_L.y*PIXELSIZE+1);
         Form1->FiltrLImageLeft->Canvas->LineTo(Macierz.OknoFL_L.x*PIXELSIZE+1+3*PIXELSIZE,Macierz.OknoFL_L.y*PIXELSIZE);
         Form1->FiltrLImageLeft->Canvas->LineTo(Macierz.OknoFL_L.x*PIXELSIZE+3*PIXELSIZE,Macierz.OknoFL_L.y*PIXELSIZE+3*PIXELSIZE);
         Form1->FiltrLImageLeft->Canvas->LineTo(Macierz.OknoFL_L.x*PIXELSIZE,Macierz.OknoFL_L.y*PIXELSIZE+3*PIXELSIZE);
         Form1->FiltrLImageLeft->Canvas->LineTo(Macierz.OknoFL_L.x*PIXELSIZE+1,Macierz.OknoFL_L.y*PIXELSIZE+1);
         Form1->FiltrLImageLeft->Canvas->Pen->Width = 1;
         break;
      case FILTR_DP_R:
         Form1->FiltrDPImageRight->Canvas->Pen->Color = clRed;
         Form1->FiltrDPImageRight->Canvas->Pen->Width = 2;
         Form1->FiltrDPImageRight->Canvas->MoveTo(Macierz.OknoFDP_R.x*PIXELSIZE,Macierz.OknoFDP_R.y*PIXELSIZE);
         Form1->FiltrDPImageRight->Canvas->LineTo(Macierz.OknoFDP_R.x*PIXELSIZE+PIXELSIZE+1,Macierz.OknoFDP_R.y*PIXELSIZE);
         Form1->FiltrDPImageRight->Canvas->LineTo(Macierz.OknoFDP_R.x*PIXELSIZE+PIXELSIZE+1,Macierz.OknoFDP_R.y*PIXELSIZE+PIXELSIZE+1);
         Form1->FiltrDPImageRight->Canvas->LineTo(Macierz.OknoFDP_R.x*PIXELSIZE,Macierz.OknoFDP_R.y*PIXELSIZE+PIXELSIZE+1);
         Form1->FiltrDPImageRight->Canvas->LineTo(Macierz.OknoFDP_R.x*PIXELSIZE,Macierz.OknoFDP_R.y*PIXELSIZE);
         Form1->FiltrDPImageRight->Canvas->Pen->Width = 1;
         break;
      case FILTR_GP_R:
         Form1->FiltrGPImageRight->Canvas->Pen->Color = clRed;
         Form1->FiltrGPImageRight->Canvas->Pen->Width = 2;
         Form1->FiltrGPImageRight->Canvas->MoveTo(Macierz.OknoFGP_R.x*PIXELSIZE,Macierz.OknoFGP_R.y*PIXELSIZE);
         Form1->FiltrGPImageRight->Canvas->LineTo(Macierz.OknoFGP_R.x*PIXELSIZE+PIXELSIZE+1,Macierz.OknoFGP_R.y*PIXELSIZE);
         Form1->FiltrGPImageRight->Canvas->LineTo(Macierz.OknoFGP_R.x*PIXELSIZE+PIXELSIZE+1,Macierz.OknoFGP_R.y*PIXELSIZE+PIXELSIZE+1);
         Form1->FiltrGPImageRight->Canvas->LineTo(Macierz.OknoFGP_R.x*PIXELSIZE,Macierz.OknoFGP_R.y*PIXELSIZE+PIXELSIZE+1);
         Form1->FiltrGPImageRight->Canvas->LineTo(Macierz.OknoFGP_R.x*PIXELSIZE,Macierz.OknoFGP_R.y*PIXELSIZE);
         Form1->FiltrGPImageRight->Canvas->Pen->Width = 1;
         break;
      case FILTR_M_R:
         Form1->FiltrMImageRight->Canvas->Pen->Color = clRed;
         Form1->FiltrMImageRight->Canvas->Pen->Width = 2;
         Form1->FiltrMImageRight->Canvas->MoveTo(Macierz.OknoFM_R.x*PIXELSIZE,Macierz.OknoFM_R.y*PIXELSIZE);
         Form1->FiltrMImageRight->Canvas->LineTo(Macierz.OknoFM_R.x*PIXELSIZE+PIXELSIZE+1,Macierz.OknoFM_R.y*PIXELSIZE);
         Form1->FiltrMImageRight->Canvas->LineTo(Macierz.OknoFM_R.x*PIXELSIZE+PIXELSIZE+1,Macierz.OknoFM_R.y*PIXELSIZE+PIXELSIZE+1);
         Form1->FiltrMImageRight->Canvas->LineTo(Macierz.OknoFM_R.x*PIXELSIZE,Macierz.OknoFM_R.y*PIXELSIZE+PIXELSIZE+1);
         Form1->FiltrMImageRight->Canvas->LineTo(Macierz.OknoFM_R.x*PIXELSIZE,Macierz.OknoFM_R.y*PIXELSIZE);
         Form1->FiltrMImageRight->Canvas->Pen->Width = 1;
         break;
      case FILTR_L_R:
         Form1->FiltrLImageRight->Canvas->Pen->Color = clRed;
         Form1->FiltrLImageRight->Canvas->Pen->Width = 2;
         Form1->FiltrLImageRight->Canvas->MoveTo(Macierz.OknoFL_R.x*PIXELSIZE,Macierz.OknoFL_R.y*PIXELSIZE);
         Form1->FiltrLImageRight->Canvas->LineTo(Macierz.OknoFL_R.x*PIXELSIZE+PIXELSIZE+1,Macierz.OknoFL_R.y*PIXELSIZE);
         Form1->FiltrLImageRight->Canvas->LineTo(Macierz.OknoFL_R.x*PIXELSIZE+PIXELSIZE+1,Macierz.OknoFL_R.y*PIXELSIZE+PIXELSIZE+1);
         Form1->FiltrLImageRight->Canvas->LineTo(Macierz.OknoFL_R.x*PIXELSIZE,Macierz.OknoFL_R.y*PIXELSIZE+PIXELSIZE+1);
         Form1->FiltrLImageRight->Canvas->LineTo(Macierz.OknoFL_R.x*PIXELSIZE,Macierz.OknoFL_R.y*PIXELSIZE);
         Form1->FiltrLImageRight->Canvas->Pen->Width = 1;
         break;
   }
}

void ShowInfo(int filtr, int x, int y, int width, int height, int pointerX, int pointerY, char* tekst)
{
   switch(filtr)
   {
      case FILTR_DP_L:
         // tekst
         Form1->FiltrDPInfo->Left = x+10;
         Form1->FiltrDPInfo->Top = y+10;
         Form1->FiltrDPInfo->Width = width;
         Form1->FiltrDPInfo->Height = height;
         Form1->FiltrDPInfo->Text = tekst;
         Form1->FiltrDPInfo->Visible = true;
         // obramowanie
         Form1->FiltrDPInfoBg->Left = x;
         Form1->FiltrDPInfoBg->Top = y;
         Form1->FiltrDPInfoBg->Width = width+20;
         Form1->FiltrDPInfoBg->Height = height+20;
         Form1->FiltrDPInfoBg->Visible = true;
         // wskaznik
         Form1->FiltrDPPointer1->Left = pointerX-10;
         Form1->FiltrDPPointer1->Top = pointerY-5;
         Form1->FiltrDPPointer1->Width = width/18;
         Form1->FiltrDPPointer1->Height = height/12;
         Form1->FiltrDPPointer1->Visible = true;
         Form1->FiltrDPPointer2->Left = pointerX+(x+(width+20)/2-pointerX)/8-15;
         Form1->FiltrDPPointer2->Top = pointerY+(y+(height+20)/2-pointerY)/8-8;
         Form1->FiltrDPPointer2->Width = width/12;
         Form1->FiltrDPPointer2->Height = height/8;
         Form1->FiltrDPPointer2->Visible = true;
         Form1->FiltrDPPointer3->Left = pointerX+(x+(width+20)/2-pointerX)/3-30;
         Form1->FiltrDPPointer3->Top = pointerY+(y+(height+20)/2-pointerY)/3-15;
         Form1->FiltrDPPointer3->Width = width/6;
         Form1->FiltrDPPointer3->Height = height/4;
         Form1->FiltrDPPointer3->Visible = true;
         break;
      case FILTR_GP_L:
         // tekst
         Form1->FiltrGPInfo->Left = x+10;
         Form1->FiltrGPInfo->Top = y+10;
         Form1->FiltrGPInfo->Width = width;
         Form1->FiltrGPInfo->Height = height;
         Form1->FiltrGPInfo->Text = tekst;
         Form1->FiltrGPInfo->Visible = true;
         // obramowanie
         Form1->FiltrGPInfoBg->Left = x;
         Form1->FiltrGPInfoBg->Top = y;
         Form1->FiltrGPInfoBg->Width = width+20;
         Form1->FiltrGPInfoBg->Height = height+20;
         Form1->FiltrGPInfoBg->Visible = true;
         // wskaznik
         Form1->FiltrGPPointer1->Left = pointerX-10;
         Form1->FiltrGPPointer1->Top = pointerY-5;
         Form1->FiltrGPPointer1->Width = width/18;
         Form1->FiltrGPPointer1->Height = height/12;
         Form1->FiltrGPPointer1->Visible = true;
         Form1->FiltrGPPointer2->Left = pointerX+(x+(width+20)/2-pointerX)/8-15;
         Form1->FiltrGPPointer2->Top = pointerY+(y+(height+20)/2-pointerY)/8-8;
         Form1->FiltrGPPointer2->Width = width/12;
         Form1->FiltrGPPointer2->Height = height/8;
         Form1->FiltrGPPointer2->Visible = true;
         Form1->FiltrGPPointer3->Left = pointerX+(x+(width+20)/2-pointerX)/3-30;
         Form1->FiltrGPPointer3->Top = pointerY+(y+(height+20)/2-pointerY)/3-15;
         Form1->FiltrGPPointer3->Width = width/6;
         Form1->FiltrGPPointer3->Height = height/4;
         Form1->FiltrGPPointer3->Visible = true;
         break;
      case FILTR_M_L:
          // tekst
         Form1->FiltrMInfo->Left = x+10;
         Form1->FiltrMInfo->Top = y+10;
         Form1->FiltrMInfo->Width = width;
         Form1->FiltrMInfo->Height = height;
         Form1->FiltrMInfo->Text = tekst;
         Form1->FiltrMInfo->Visible = true;
         // obramowanie
         Form1->FiltrMInfoBg->Left = x;
         Form1->FiltrMInfoBg->Top = y;
         Form1->FiltrMInfoBg->Width = width+20;
         Form1->FiltrMInfoBg->Height = height+20;
         Form1->FiltrMInfoBg->Visible = true;
         // wskaznik
         Form1->FiltrMPointer1->Left = pointerX-10;
         Form1->FiltrMPointer1->Top = pointerY-5;
         Form1->FiltrMPointer1->Width = width/18;
         Form1->FiltrMPointer1->Height = height/12;
         Form1->FiltrMPointer1->Visible = true;
         Form1->FiltrMPointer2->Left = pointerX+(x+(width+20)/2-pointerX)/8-15;
         Form1->FiltrMPointer2->Top = pointerY+(y+(height+20)/2-pointerY)/8-8;
         Form1->FiltrMPointer2->Width = width/12;
         Form1->FiltrMPointer2->Height = height/8;
         Form1->FiltrMPointer2->Visible = true;
         Form1->FiltrMPointer3->Left = pointerX+(x+(width+20)/2-pointerX)/3-30;
         Form1->FiltrMPointer3->Top = pointerY+(y+(height+20)/2-pointerY)/3-15;
         Form1->FiltrMPointer3->Width = width/6;
         Form1->FiltrMPointer3->Height = height/4;
         Form1->FiltrMPointer3->Visible = true;
         break;
      case FILTR_L_L:
         // tekst
         Form1->FiltrLInfo->Left = x+10;
         Form1->FiltrLInfo->Top = y+10;
         Form1->FiltrLInfo->Width = width;
         Form1->FiltrLInfo->Height = height;
         Form1->FiltrLInfo->Text = tekst;
         Form1->FiltrLInfo->Visible = true;
         // obramowanie
         Form1->FiltrLInfoBg->Left = x;
         Form1->FiltrLInfoBg->Top = y;
         Form1->FiltrLInfoBg->Width = width+20;
         Form1->FiltrLInfoBg->Height = height+20;
         Form1->FiltrLInfoBg->Visible = true;
         // wskaznik
         Form1->FiltrLPointer1->Left = pointerX-10;
         Form1->FiltrLPointer1->Top = pointerY-5;
         Form1->FiltrLPointer1->Width = width/18;
         Form1->FiltrLPointer1->Height = height/12;
         Form1->FiltrLPointer1->Visible = true;
         Form1->FiltrLPointer2->Left = pointerX+(x+(width+20)/2-pointerX)/8-15;
         Form1->FiltrLPointer2->Top = pointerY+(y+(height+20)/2-pointerY)/8-8;
         Form1->FiltrLPointer2->Width = width/12;
         Form1->FiltrLPointer2->Height = height/8;
         Form1->FiltrLPointer2->Visible = true;
         Form1->FiltrLPointer3->Left = pointerX+(x+(width+20)/2-pointerX)/3-30;
         Form1->FiltrLPointer3->Top = pointerY+(y+(height+20)/2-pointerY)/3-15;
         Form1->FiltrLPointer3->Width = width/6;
         Form1->FiltrLPointer3->Height = height/4;
         Form1->FiltrLPointer3->Visible = true;
         break;
   }
}

void HideInfo(int filtr)
{
switch(filtr)
   {
      case FILTR_DP_L:
         Form1->FiltrDPInfo->Visible = false;
         Form1->FiltrDPInfoBg->Visible = false;
         Form1->FiltrDPPointer1->Visible = false;
         Form1->FiltrDPPointer2->Visible = false;
         Form1->FiltrDPPointer3->Visible = false;
         break;
      case FILTR_GP_L:
         Form1->FiltrGPInfo->Visible = false;
         Form1->FiltrGPInfoBg->Visible = false;
         Form1->FiltrGPPointer1->Visible = false;
         Form1->FiltrGPPointer2->Visible = false;
         Form1->FiltrGPPointer3->Visible = false;
         break;
      case FILTR_M_L:
         Form1->FiltrMInfo->Visible = false;
         Form1->FiltrMInfoBg->Visible = false;
         Form1->FiltrMPointer1->Visible = false;
         Form1->FiltrMPointer2->Visible = false;
         Form1->FiltrMPointer3->Visible = false;
         break;
      case FILTR_L_L:
         Form1->FiltrLInfo->Visible = false;
         Form1->FiltrLInfoBg->Visible = false;
         Form1->FiltrLPointer1->Visible = false;
         Form1->FiltrLPointer2->Visible = false;
         Form1->FiltrLPointer3->Visible = false;
         break;
   }
}
//////////////////////////////////////////////
//
//    P  R  E  Z  E  N  T  A  C  J  A
//
//////////////////////////////////////////////
void Prezentacja(int filtr)
{
  int kolor, kolorT;
  
   switch(filtr)
   {
      ///////////////////////////
      // FILTR DOLNOPRZEPUSTOWY
      ///////////////////////////
      case FILTR_DP_L:
        switch(Slajdy.FiltrDPnrSlajdu)
         {
            case 1:
               Form1->FiltrDPDalej->Caption = "Dalej >";
               RysujOkno(FILTR_DP_L);
               RysujOkno(FILTR_DP_R);
               WyswietlKolor(FILTR_DP_L,0,0);
               WyswietlKolor(FILTR_DP_L,1,0);
               WyswietlKolor(FILTR_DP_L,2,0);
               WyswietlKolor(FILTR_DP_L,0,1);
               WyswietlKolor(FILTR_DP_L,1,1);
               WyswietlKolor(FILTR_DP_L,2,1);
               WyswietlKolor(FILTR_DP_L,0,2);
               WyswietlKolor(FILTR_DP_L,1,2);
               WyswietlKolor(FILTR_DP_L,2,2);
               ShowInfo(FILTR_DP_L, 100, 70, 240, 80, 60, 60,
               "Najpierw do obrazu wejciowego \"przykladana\" jest maska, ktora "
               "moze miec rozny ksztalt i wielkosc np. maska 2x2, 3x3(tutaj uzyta) "
               "5x5 i wieksze, jak i w postaci krzyza. W zaleznosci od wielkosci maski, "
               "uzyskany efekt moze byc silniejszy lub slabszy.");
               break;
            case 2:
               ShowInfo(FILTR_DP_L, 570, 10, 250, 100, 500, 160,
               "Maska o rozmiarze 3x3 piksele.\n"
               "Wszystkie wagi w tej masce sa ustawione na '1', aby "
               "cale otoczenie piksela badanego bylo brane w tej samej proporcji "
               "Takie ustawienie daje nam efekt \"wycinania\" z obrazu wysokich "
               "czestotliwosci.\n"
               "Nie jest to jednak jedyne ustawienie maski dla filtru dolnoprzepustowego.");
               break;
            case 3:
               ShowInfo(FILTR_DP_L, 230, 210, 150, 50, 380, 330,
               "Nowy piksel w obrazie wynikowym jest wyznaczany z ponizszego wzoru. ");
               break;
            case 4:
               Form1->FiltrDPWzor->Picture->Bitmap->LoadFromFile("images\\wzorL.bmp");
               Form1->FiltrDPWzor2->Picture->Bitmap->LoadFromFile("images\\wzor2.bmp");
               ShowInfo(FILTR_DP_L, 630, 170, 240, 60, 570, 300,
               "Na jego podstawie sumujemy wszystkie iloczyny pikseli z otoczenia K piksela bazowego(ktory nie musi byc akurat srodkowym) "
               "z ich wagami w masce.");
               // uaktywnienie pikseli do animacji
               Form1->FiltrDPPixel1->Visible = true; Form1->FiltrDPPixelT1->Visible = true;
               Form1->FiltrDPPixel2->Visible = true; Form1->FiltrDPPixelT2->Visible = true;
               Form1->FiltrDPPixel3->Visible = true; Form1->FiltrDPPixelT3->Visible = true;
               Form1->FiltrDPPixel4->Visible = true; Form1->FiltrDPPixelT4->Visible = true;
               Form1->FiltrDPPixel5->Visible = true; Form1->FiltrDPPixelT5->Visible = true;
               Form1->FiltrDPPixel6->Visible = true; Form1->FiltrDPPixelT6->Visible = true;
               Form1->FiltrDPPixel7->Visible = true; Form1->FiltrDPPixelT7->Visible = true;
               Form1->FiltrDPPixel8->Visible = true; Form1->FiltrDPPixelT8->Visible = true;
               Form1->FiltrDPPixel9->Visible = true; Form1->FiltrDPPixelT9->Visible = true;
               Form1->FiltrDPMatrixTimer->Enabled = true;
               Form1->FiltrDPMaskaTimer->Enabled = true;
               break;
            case 5:
               Form1->FiltrDPWzor->Picture->Bitmap->LoadFromFile("images\\wzorM.bmp");
               Form1->FiltrDPWzor2->Picture->Bitmap->LoadFromFile("images\\wzor2b.bmp");
               ShowInfo(FILTR_DP_L, 650, 220, 180, 60, 570, 360,
               "Tak otrzymana sume dzielimy przez zsumowane wagi z maski(w naszym przypadku = 9) aby uzyskany "
               "wynik miescil sie w przedziale <0,255>");
               break;
            case 6:
               HideInfo(FILTR_DP_L);
               Form1->FiltrDPWzor->Picture->Bitmap->LoadFromFile("images\\wzor.bmp");
               kolor = PoliczPixelW(FILTR_DP_L,0,0);
               if (kolor>128) kolorT=0; else kolorT = 255;
               Form1->FiltrDPPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrDPPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrDPPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
               Form1->FiltrDPPixelWT->Caption     = IntToStr(kolor);
               Form1->FiltrDPPixelW->Visible = true;
               Form1->FiltrDPPixelWT->Visible = true;
               ShowInfo(FILTR_DP_L, 600, 315, 220, 80, 850, 480,
               "W wyniku tej operacji dostajemy wartosc jasnosci piksela, ktory zostanie "
               "umieszczony w obrazie wynikowym.");
               break;
            case 7:
               HideInfo(FILTR_DP_L);
               Form1->FiltrDPPixelWTimer->Enabled = true;
               break;
            case 8:
               RysujMacierz(FILTR_DP_L); RysujMacierz(FILTR_DP_R);
               Macierz.OknoFDP_L.x = 1; Macierz.OknoFDP_L.y = 0;
               Macierz.OknoFDP_R.x = 2; Macierz.OknoFDP_R.y = 1;
               RysujOkno(FILTR_DP_L); RysujOkno(FILTR_DP_R);
               WyswietlKolor(FILTR_DP_L,1,0);
               WyswietlKolor(FILTR_DP_L,2,0);
               WyswietlKolor(FILTR_DP_L,3,0);
               WyswietlKolor(FILTR_DP_L,1,1);
               WyswietlKolor(FILTR_DP_L,2,1);
               WyswietlKolor(FILTR_DP_L,3,1);
               WyswietlKolor(FILTR_DP_L,1,2);
               WyswietlKolor(FILTR_DP_L,2,2);
               WyswietlKolor(FILTR_DP_L,3,2);
               break;
            case 9:
               Form1->FiltrDPMatrixTimer->Enabled = true;
               break;
            case 10:
                kolor = PoliczPixelW(FILTR_DP_L,1,0);
                if (kolor>128) kolorT=0; else kolorT = 255;
                Form1->FiltrDPPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrDPPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrDPPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
                Form1->FiltrDPPixelWT->Caption     = IntToStr(kolor);
                Form1->FiltrDPPixelW->Left = 850; Form1->FiltrDPPixelW->Top = 472;
                Form1->FiltrDPPixelWT->Left = 853; Form1->FiltrDPPixelWT->Top = 477;
                break;
            case 11:
                Form1->FiltrDPPixelWTimer->Enabled = true;
                break;
            case 12:
               RysujMacierz(FILTR_DP_L); RysujMacierz(FILTR_DP_R);
               Macierz.OknoFDP_L.x = 2; Macierz.OknoFDP_L.y = 0;
               Macierz.OknoFDP_R.x = 3; Macierz.OknoFDP_R.y = 1;
               RysujOkno(FILTR_DP_L); RysujOkno(FILTR_DP_R);
               WyswietlKolor(FILTR_DP_L,2,0);
               WyswietlKolor(FILTR_DP_L,3,0);
               WyswietlKolor(FILTR_DP_L,4,0);
               WyswietlKolor(FILTR_DP_L,2,1);
               WyswietlKolor(FILTR_DP_L,3,1);
               WyswietlKolor(FILTR_DP_L,4,1);
               WyswietlKolor(FILTR_DP_L,2,2);
               WyswietlKolor(FILTR_DP_L,3,2);
               WyswietlKolor(FILTR_DP_L,4,2);
               break;
            case 13:
                Form1->FiltrDPMatrixTimer->Enabled = true;
                break;
            case 14:
                kolor = PoliczPixelW(FILTR_DP_L,2,0);
                if (kolor>128) kolorT=0; else kolorT = 255;
                Form1->FiltrDPPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrDPPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrDPPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
                Form1->FiltrDPPixelWT->Caption     = IntToStr(kolor);
                Form1->FiltrDPPixelW->Left = 850; Form1->FiltrDPPixelW->Top = 472;
                Form1->FiltrDPPixelWT->Left = 853; Form1->FiltrDPPixelWT->Top = 477;
                break;
            case 15:
                Form1->FiltrDPDalej->Caption = "Auto >";
                Form1->FiltrDPPixelWTimer->Enabled = true;
                RysujMacierz(FILTR_DP_L); RysujMacierz(FILTR_DP_R);
                break;
            case 16:
                Form1->FiltrDPAutoTimer->Enabled = true;
                break;
            case 17:
                ShowInfo(FILTR_DP_L, 200, 20, 140, 40, 155, 80,
                "W wyniku operacji filtrowania wszystkie takie \"ostre\" punkty jak ten ....");
                break;
            case 18:
                ShowInfo(FILTR_DP_L, 150, 120, 140, 40, 85, 200,
                "...i ten, zostaja \"rozmyte\"");
                break;
            case 19:
                ShowInfo(FILTR_DP_L, 350, 120, 180, 80, 285, 100,
                "Wyraznie zaznaczone krawedzie obiektow, tak jak ta, zostaja zastapione....");
                break;
            case 20:
                ShowInfo(FILTR_DP_L, 550, 120, 180, 60, 920, 100,
                "plynnym przejsciem tonalnym(niska czestotliwosc), co powoduje efekt rozmazywania, mieszania sie obiektow");
                break;
            case 21:
                ShowInfo(FILTR_DP_L, 350, 140, 240, 70, 250, 250,
                "Najwyzsza mozliwa czestotliwoscia w obrazie jest wystepowanie naprzemienne"
                " najnizszej <0> i najwyzszej <255> wartosci piksela, co mozemy zaobserwowac w tym fragmencie obrazu");
                break;
            case 22:
                ShowInfo(FILTR_DP_L, 550, 140, 160, 50, 850, 250,
                "Jak widac po filtracji czestotliwosc ta zostaje znacznie stlumiona");
                Form1->FiltrDPDalej->Caption = "Przyklady >>>";
                break;
            case 24:
                Form1->PageControl1->SelectNextPage(true,true);
                break;
            default:
                Form1->PageControl1->SelectNextPage(true,true);
                break;
         }
         break;

      ///////////////////////////
      // FILTR GORNOPRZEPUSTOWY
      ///////////////////////////
      case FILTR_GP_L:
         switch(Slajdy.FiltrGPnrSlajdu)
         {
           case 1:
               Form1->FiltrGPDalej->Caption = "Dalej >";
               RysujOkno(FILTR_GP_L);
               RysujOkno(FILTR_GP_R);
               WyswietlKolor(FILTR_GP_L,0,0);
               WyswietlKolor(FILTR_GP_L,1,0);
               WyswietlKolor(FILTR_GP_L,2,0);
               WyswietlKolor(FILTR_GP_L,0,1);
               WyswietlKolor(FILTR_GP_L,1,1);
               WyswietlKolor(FILTR_GP_L,2,1);
               WyswietlKolor(FILTR_GP_L,0,2);
               WyswietlKolor(FILTR_GP_L,1,2);
               WyswietlKolor(FILTR_GP_L,2,2);
               ShowInfo(FILTR_GP_L, 100, 100, 180, 40, 60, 60,
               "Tak jak w poprzednim filtrze przykladamy maske(tutaj 3x3) do obrazu.");
               break;
            case 2:
               ShowInfo(FILTR_GP_L, 600, 10, 300, 110, 500, 160,
               "W przypadku filtru gornoprzepustowego pojawiaja sie ujemne wspolczynniki wagowe. "
               "Piksele narozne nie sa brane pod uwage (wagi ustawione na 0). "
               "Piksel centralny ma wage dodatnia. "
               "Takie ustawienie daje nam efekt wzmacniania w obrazie wysokich czestotliwosci.\n"
               "Jest to jedno z wielu ustawien dla filtru gornoprzepustowego.");
               break;
            case 3:
               ShowInfo(FILTR_GP_L, 230, 210, 150, 50, 380, 330,
               "Nowy piksel w obrazie wynikowym jest wyznaczany z ponizszego wzoru. ");
               break;
            case 4:
               Form1->FiltrGPWzor->Picture->Bitmap->LoadFromFile("images\\wzorL.bmp");
               Form1->FiltrGPWzor2->Picture->Bitmap->LoadFromFile("images\\wzor2.bmp");
               ShowInfo(FILTR_GP_L, 630, 170, 240, 60, 570, 300,
               "Na jego podstawie sumujemy wszystkie iloczyny pikseli z otoczenia K piksela bazowego "
               "z ich wagami w masce.");
               // uaktywnienie pikseli do animacji
               Form1->FiltrGPPixel1->Visible = true; Form1->FiltrGPPixelT1->Visible = true;
               Form1->FiltrGPPixel2->Visible = true; Form1->FiltrGPPixelT2->Visible = true;
               Form1->FiltrGPPixel3->Visible = true; Form1->FiltrGPPixelT3->Visible = true;
               Form1->FiltrGPPixel4->Visible = true; Form1->FiltrGPPixelT4->Visible = true;
               Form1->FiltrGPPixel5->Visible = true; Form1->FiltrGPPixelT5->Visible = true;
               Form1->FiltrGPPixel6->Visible = true; Form1->FiltrGPPixelT6->Visible = true;
               Form1->FiltrGPPixel7->Visible = true; Form1->FiltrGPPixelT7->Visible = true;
               Form1->FiltrGPPixel8->Visible = true; Form1->FiltrGPPixelT8->Visible = true;
               Form1->FiltrGPPixel9->Visible = true; Form1->FiltrGPPixelT9->Visible = true;
               Form1->FiltrGPMatrixTimer->Enabled = true;
               Form1->FiltrGPMaskaTimer->Enabled = true;
               break;
            case 5:
               Form1->FiltrGPWzor->Picture->Bitmap->LoadFromFile("images\\wzorM.bmp");
               Form1->FiltrGPWzor2->Picture->Bitmap->LoadFromFile("images\\wzor2c.bmp");
               ShowInfo(FILTR_GP_L, 650, 160, 280, 120, 570, 360,
               "Tak otrzymana sume dzielimy przez zsumowane wagi z maski (w naszym przypadku = 1). "
               "Jezeli otrzymany wynik nie miesci sie w przedziale <0,255>, co moze byc dosc czestym przypadkiem, gdyz filtr"
               " gornoprzepustowy przy wzmacnianiu czestotliwosci wysokich zwieksza ich zakres poza mozliwe wartosci dla piksela, musimy"
               " skrocic je zamieniajac wieksze (powyzej 255) na wartosc 255 i ujemne na 0");
               break;
            case 6:
               HideInfo(FILTR_GP_L);
               Form1->FiltrDPWzor->Picture->Bitmap->LoadFromFile("images\\wzor.bmp");
               kolor = PoliczPixelW(FILTR_GP_L,0,0);
               if (kolor>128) kolorT=0; else kolorT = 255;
               Form1->FiltrGPPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrGPPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrGPPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
               Form1->FiltrGPPixelWT->Caption     = IntToStr(kolor);
               Form1->FiltrGPPixelW->Visible = true;
               Form1->FiltrGPPixelWT->Visible = true;
               ShowInfo(FILTR_GP_L, 600, 315, 220, 50, 850, 480,
               "W wyniku tej operacji dostajemy wartosc jasnosci piksela, ktory zostanie "
               "umieszczony w obrazie wynikowym.");
               break;
            case 7:
               HideInfo(FILTR_GP_L);
               Form1->FiltrGPPixelWTimer->Enabled = true;
               break;
            case 8:
               RysujMacierz(FILTR_GP_L); RysujMacierz(FILTR_GP_R);
               Macierz.OknoFGP_L.x = 1; Macierz.OknoFGP_L.y = 0;
               Macierz.OknoFGP_R.x = 2; Macierz.OknoFGP_R.y = 1;
               RysujOkno(FILTR_GP_L); RysujOkno(FILTR_GP_R);
               WyswietlKolor(FILTR_GP_L,1,0);
               WyswietlKolor(FILTR_GP_L,2,0);
               WyswietlKolor(FILTR_GP_L,3,0);
               WyswietlKolor(FILTR_GP_L,1,1);
               WyswietlKolor(FILTR_GP_L,2,1);
               WyswietlKolor(FILTR_GP_L,3,1);
               WyswietlKolor(FILTR_GP_L,1,2);
               WyswietlKolor(FILTR_GP_L,2,2);
               WyswietlKolor(FILTR_GP_L,3,2);
               break;
            case 9:
               Form1->FiltrGPMatrixTimer->Enabled = true;
               break;
            case 10:
                kolor = PoliczPixelW(FILTR_GP_L,1,0);
                if (kolor>128) kolorT=0; else kolorT = 255;
                Form1->FiltrGPPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrGPPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrGPPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
                Form1->FiltrGPPixelWT->Caption     = IntToStr(kolor);
                Form1->FiltrGPPixelW->Left = 850; Form1->FiltrGPPixelW->Top = 472;
                Form1->FiltrGPPixelWT->Left = 853; Form1->FiltrGPPixelWT->Top = 477;
                break;
            case 11:
                Form1->FiltrGPPixelWTimer->Enabled = true;
                break;
            case 12:
               RysujMacierz(FILTR_GP_L); RysujMacierz(FILTR_GP_R);
               Macierz.OknoFGP_L.x = 2; Macierz.OknoFGP_L.y = 0;
               Macierz.OknoFGP_R.x = 3; Macierz.OknoFGP_R.y = 1;
               RysujOkno(FILTR_GP_L); RysujOkno(FILTR_GP_R);
               WyswietlKolor(FILTR_GP_L,2,0);
               WyswietlKolor(FILTR_GP_L,3,0);
               WyswietlKolor(FILTR_GP_L,4,0);
               WyswietlKolor(FILTR_GP_L,2,1);
               WyswietlKolor(FILTR_GP_L,3,1);
               WyswietlKolor(FILTR_GP_L,4,1);
               WyswietlKolor(FILTR_GP_L,2,2);
               WyswietlKolor(FILTR_GP_L,3,2);
               WyswietlKolor(FILTR_GP_L,4,2);
               break;
            case 13:
                Form1->FiltrGPMatrixTimer->Enabled = true;
                break;
            case 14:
                kolor = PoliczPixelW(FILTR_GP_L,2,0);
                if (kolor>128) kolorT=0; else kolorT = 255;
                Form1->FiltrGPPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrGPPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrGPPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
                Form1->FiltrGPPixelWT->Caption     = IntToStr(kolor);
                Form1->FiltrGPPixelW->Left = 850; Form1->FiltrGPPixelW->Top = 472;
                Form1->FiltrGPPixelWT->Left = 853; Form1->FiltrGPPixelWT->Top = 477;
                break;
            case 15:
                Form1->FiltrGPDalej->Caption = "Auto >";
                Form1->FiltrGPPixelWTimer->Enabled = true;
                RysujMacierz(FILTR_GP_L); RysujMacierz(FILTR_GP_R);
                break;
            case 16:
                Form1->FiltrGPAutoTimer->Enabled = true;
                break;
            case 17:
                ShowInfo(FILTR_GP_L, 450, 15, 220, 50, 820, 80,
                "W obrazie po filtracji wyraznie polepszyl sie kontrast i lepiej widac teraz przykladowe cyfry...");
                break;
            case 18:
                ShowInfo(FILTR_GP_L, 530, 145, 160, 30, 800, 250,
                "... jak i fragment sinusoidy");
                Form1->FiltrGPDalej->Caption = "Przyklady >>>";
                break;
            case 19:
                Form1->PageControl1->SelectNextPage(true,true);
                break;
            default:
                Form1->PageControl1->SelectNextPage(true,true);
                break;
         }
         break;

      ///////////////////////////
      // FILTR MEDIANOWY
      ///////////////////////////
      case FILTR_M_L:
          switch(Slajdy.FiltrMnrSlajdu)
         {
           case 1:
               Form1->FiltrMDalej->Caption = "Dalej >";
               RysujOkno(FILTR_M_L);
               RysujOkno(FILTR_M_R);
               WyswietlKolor(FILTR_M_L,0,0);
               WyswietlKolor(FILTR_M_L,1,0);
               WyswietlKolor(FILTR_M_L,2,0);
               WyswietlKolor(FILTR_M_L,0,1);
               WyswietlKolor(FILTR_M_L,1,1);
               WyswietlKolor(FILTR_M_L,2,1);
               WyswietlKolor(FILTR_M_L,0,2);
               WyswietlKolor(FILTR_M_L,1,2);
               WyswietlKolor(FILTR_M_L,2,2);
               ShowInfo(FILTR_M_L, 100, 100, 180, 40, 60, 60,
               "Tak jak w poprzednich filtrach przykladamy maske(tutaj 3x3) do obrazu.");
               break;
            case 2:
               ShowInfo(FILTR_M_L, 350, 70, 270, 110, 380, 120,
               "Najwazniejsza rzecza odrozniajaca filtr medianowy od juz poznanych filtrow "
               "jest to, ze nie uzywa on wspolczynnikow wagowych do wyliczenia wynikowego piksela, lecz "
               "piksel ten jest wybierany jako mediana (czyli wartosc srodkowa -->nie srednia !) z pikseli objetych maska. "
               " Aby wyznaczyc mediane trzeba najpierw piksele posortowac (rosnaco lub malejaco) i wybrac piksel srodkowy. ");
               break;
            case 3:
               ShowInfo(FILTR_M_L, 430, 280, 180, 60, 400, 430,
               " Te piksele trzeba posortowac aby wyznaczyc piksel srodkowy ");
               // uaktywnienie pikseli do animacji
               Form1->FiltrMPixel1->Visible = true; Form1->FiltrMPixelT1->Visible = true;
               Form1->FiltrMPixel2->Visible = true; Form1->FiltrMPixelT2->Visible = true;
               Form1->FiltrMPixel3->Visible = true; Form1->FiltrMPixelT3->Visible = true;
               Form1->FiltrMPixel4->Visible = true; Form1->FiltrMPixelT4->Visible = true;
               Form1->FiltrMPixel5->Visible = true; Form1->FiltrMPixelT5->Visible = true;
               Form1->FiltrMPixel6->Visible = true; Form1->FiltrMPixelT6->Visible = true;
               Form1->FiltrMPixel7->Visible = true; Form1->FiltrMPixelT7->Visible = true;
               Form1->FiltrMPixel8->Visible = true; Form1->FiltrMPixelT8->Visible = true;
               Form1->FiltrMPixel9->Visible = true; Form1->FiltrMPixelT9->Visible = true;
               Form1->FiltrMMatrixTimer->Enabled = true;
               Form1->FiltrMWzor2->Picture->Bitmap->LoadFromFile("images\\sort.bmp");
               break;
            case 4:
               Form1->FiltrMWzor2->Picture->Bitmap->LoadFromFile("images\\sort2.bmp");
               HideInfo(FILTR_M_L);
               Form1->FiltrMSortTimer->Enabled = true;
               break;
            case 5:
               HideInfo(FILTR_M_L);
               kolor = PoliczPixelW(FILTR_M_L,0,0);
               if (kolor>128) kolorT=0; else kolorT = 255;
               Form1->FiltrMPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrMPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrMPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
               Form1->FiltrMPixelWT->Caption     = IntToStr(kolor);
               Form1->FiltrMPixelW->Visible = true;
               Form1->FiltrMPixelWT->Visible = true;
               Form1->FiltrMWzor2->Picture->Bitmap->LoadFromFile("images\\sort2m.bmp");
               ShowInfo(FILTR_M_L, 560, 250, 220, 60, 470, 440,
               "Jako piksel wynikowy bierzemy srodkowy (mediana) i umieszczamy w obrazie wynikowym.");
               break;
            case 6:
               HideInfo(FILTR_M_L);
               Form1->FiltrMPixelWTimer->Enabled = true;
               break;
            case 7:
               RysujMacierz(FILTR_M_L); RysujMacierz(FILTR_M_R);
               Macierz.OknoFM_L.x = 1; Macierz.OknoFM_L.y = 0;
               Macierz.OknoFM_R.x = 2; Macierz.OknoFM_R.y = 1;
               RysujOkno(FILTR_M_L); RysujOkno(FILTR_M_R);
               WyswietlKolor(FILTR_M_L,1,0);
               WyswietlKolor(FILTR_M_L,2,0);
               WyswietlKolor(FILTR_M_L,3,0);
               WyswietlKolor(FILTR_M_L,1,1);
               WyswietlKolor(FILTR_M_L,2,1);
               WyswietlKolor(FILTR_M_L,3,1);
               WyswietlKolor(FILTR_M_L,1,2);
               WyswietlKolor(FILTR_M_L,2,2);
               WyswietlKolor(FILTR_M_L,3,2);
               break;
            case 8:
                Form1->FiltrMWzor2->Picture->Bitmap->LoadFromFile("images\\sort.bmp");
                Form1->FiltrMMatrixTimer->Enabled = true;
                break;
            case 9:
                Form1->FiltrMWzor2->Picture->Bitmap->LoadFromFile("images\\sort2.bmp");
                Form1->FiltrMSortTimer->Enabled = true;
                break;
            case 10:
                kolor = PoliczPixelW(FILTR_M_L,1,0);
                if (kolor>128) kolorT=0; else kolorT = 255;
                Form1->FiltrMPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrMPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrMPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
                Form1->FiltrMPixelWT->Caption     = IntToStr(kolor);
                Form1->FiltrMPixelW->Left = 850; Form1->FiltrMPixelW->Top = 450;
                Form1->FiltrMPixelWT->Left = 853; Form1->FiltrMPixelWT->Top = 455;
                Form1->FiltrMWzor2->Picture->Bitmap->LoadFromFile("images\\sort2m.bmp");
                break;
            case 11:
                Form1->FiltrMPixelWTimer->Enabled = true;
                break;
            case 12:
               RysujMacierz(FILTR_M_L); RysujMacierz(FILTR_M_R);
               Macierz.OknoFM_L.x = 2; Macierz.OknoFM_L.y = 0;
               Macierz.OknoFM_R.x = 3; Macierz.OknoFM_R.y = 1;
               RysujOkno(FILTR_M_L); RysujOkno(FILTR_M_R);
               WyswietlKolor(FILTR_M_L,2,0);
               WyswietlKolor(FILTR_M_L,3,0);
               WyswietlKolor(FILTR_M_L,4,0);
               WyswietlKolor(FILTR_M_L,2,1);
               WyswietlKolor(FILTR_M_L,3,1);
               WyswietlKolor(FILTR_M_L,4,1);
               WyswietlKolor(FILTR_M_L,2,2);
               WyswietlKolor(FILTR_M_L,3,2);
               WyswietlKolor(FILTR_M_L,4,2);
               break;
            case 13:
                Form1->FiltrMWzor2->Picture->Bitmap->LoadFromFile("images\\sort.bmp");
                Form1->FiltrMMatrixTimer->Enabled = true;
                break;
            case 14:
                Form1->FiltrMWzor2->Picture->Bitmap->LoadFromFile("images\\sort2.bmp");
                Form1->FiltrMSortTimer->Enabled = true;
                break;
            case 15:
                kolor = PoliczPixelW(FILTR_M_L,2,0);
                if (kolor>128) kolorT=0; else kolorT = 255;
                Form1->FiltrMPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrMPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrMPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
                Form1->FiltrMPixelWT->Caption     = IntToStr(kolor);
                Form1->FiltrMPixelW->Left = 850; Form1->FiltrMPixelW->Top = 450;
                Form1->FiltrMPixelWT->Left = 853; Form1->FiltrMPixelWT->Top = 455;
                Form1->FiltrMWzor2->Picture->Bitmap->LoadFromFile("images\\sort2m.bmp");
                break;
            case 16:
                Form1->FiltrMDalej->Caption = "Auto >";
                Form1->FiltrMPixelWTimer->Enabled = true;
                RysujMacierz(FILTR_M_L); RysujMacierz(FILTR_M_R);
                break;
            case 17:
                Form1->FiltrMAutoTimer->Enabled = true;
                break;
            case 18:
               ShowInfo(FILTR_M_L, 350, 50, 260, 100, 390, 80,
               "Filtr medianowy daje bardzo dobre efekty podczas \"odszumiania\" obrazu, czyli"
               " eliminacji pikseli bedacych zakloceniami definiowanymi jako nadmiernie rozniace sie jasnoscia od reszty."
               " Takie piksele beda pomijane podczas sortowania, gdyz wszystkie skrajne wartosci trafiaja na poczatek i koniec"
               " posortowanej listy kolorow, a my wybieramy piksel srodkowy(medianowy).");
               break;
            case 19:
               ShowInfo(FILTR_M_L, 250, 90, 260, 80, 110, 200,
               "Jak latwo zauwazyc pojedyncze piksele (takie, ktore maja sasiadow w wiekszosci znacznie odbiegajacych od niego jasnoscia)"
               " zostaja pomijane. Dotyczy to zarowno pikseli ciemnych na jasnym tle, jak i jasnych na ciemnym tle.");
               Form1->FiltrMDalej->Caption = "Przyklady >>>";
               break;
            case 20:
                Form1->PageControl1->SelectNextPage(true,true);
                break;
            default:
                Form1->PageControl1->SelectNextPage(true,true);
                break;
         }
         break;

      ///////////////////////////
      // FILTR LAPLACE'A
      ///////////////////////////
      case FILTR_L_L:
         switch(Slajdy.FiltrLnrSlajdu)
         {
            case 1:
               Form1->FiltrLDalej->Caption = "Dalej >";
               RysujOkno(FILTR_L_L);
               RysujOkno(FILTR_L_R);
               WyswietlKolor(FILTR_L_L,0,0);
               WyswietlKolor(FILTR_L_L,1,0);
               WyswietlKolor(FILTR_L_L,2,0);
               WyswietlKolor(FILTR_L_L,0,1);
               WyswietlKolor(FILTR_L_L,1,1);
               WyswietlKolor(FILTR_L_L,2,1);
               WyswietlKolor(FILTR_L_L,0,2);
               WyswietlKolor(FILTR_L_L,1,2);
               WyswietlKolor(FILTR_L_L,2,2);
               ShowInfo(FILTR_L_L, 100, 100, 240, 40, 60, 60,
               "Tak jak w filtrach gorno- i dolnoprzepustowych przykladamy maske (tutaj 3x3) do obrazu.");
               break;
            case 2:
               ShowInfo(FILTR_L_L, 570, 10, 281, 80, 500, 160,
               "Maska o rozmiarze 3x3 piksele.\n"
               "Wagi w tej masce powstaly z sumowania dwoch pochodnych: w kierunku pionowym i poziomym. "
               "Ich suma tworzy tzw. maske Laplace'a:");
               Form1->Laplace->Visible = true;
               break;
            case 3:
               Form1->Laplace->Visible = false;
               ShowInfo(FILTR_L_L, 230, 210, 150, 50, 380, 330,
               "Nowy piksel w obrazie wynikowym jest wyznaczany z ponizszego wzoru. ");
               break;
            case 4:
               Form1->FiltrLWzor->Picture->Bitmap->LoadFromFile("images\\wzorL.bmp");
               Form1->FiltrLWzor2->Picture->Bitmap->LoadFromFile("images\\wzor2.bmp");
               ShowInfo(FILTR_L_L, 630, 170, 240, 60, 570, 300,
               "Sumujemy wszystkie iloczyny pikseli z otoczenia K piksela bazowego "
               "z ich wagami w masce.");
               // uaktywnienie pikseli do animacji
               Form1->FiltrLPixel1->Visible = true; Form1->FiltrLPixelT1->Visible = true;
               Form1->FiltrLPixel2->Visible = true; Form1->FiltrLPixelT2->Visible = true;
               Form1->FiltrLPixel3->Visible = true; Form1->FiltrLPixelT3->Visible = true;
               Form1->FiltrLPixel4->Visible = true; Form1->FiltrLPixelT4->Visible = true;
               Form1->FiltrLPixel5->Visible = true; Form1->FiltrLPixelT5->Visible = true;
               Form1->FiltrLPixel6->Visible = true; Form1->FiltrLPixelT6->Visible = true;
               Form1->FiltrLPixel7->Visible = true; Form1->FiltrLPixelT7->Visible = true;
               Form1->FiltrLPixel8->Visible = true; Form1->FiltrLPixelT8->Visible = true;
               Form1->FiltrLPixel9->Visible = true; Form1->FiltrLPixelT9->Visible = true;
               Form1->FiltrLMatrixTimer->Enabled = true;
               Form1->FiltrLMaskaTimer->Enabled = true;
               break;
            case 5:
               Form1->FiltrLWzor->Picture->Bitmap->LoadFromFile("images\\wzorM.bmp");
               Form1->FiltrLWzor2->Picture->Bitmap->LoadFromFile("images\\wzor2c.bmp");
               ShowInfo(FILTR_L_L, 620, 220, 280, 110, 570, 360,
               "W wyniku sumowania wag z maski otrzymamy wartosc rowna 0. Poniewaz nie mozna dzielic przez 0"
               " zostawiamy wartosc z poprzedniego sumowania bez zmian (czyli dzielimy przez 1), ale musimy w zwiazku z tym"
               " sprawdzic zakres tak wyliczonej jasnosci piksela i tam gdzie to trzeba zredukowac wartosc do dopuszczalnego dla"
               " piksela przedzialu <0,255> (podobnie jak to mialo miejsce dla filtru gornoprzepustowego)");
               break;
            case 6:
               HideInfo(FILTR_L_L);
               Form1->FiltrLWzor->Picture->Bitmap->LoadFromFile("images\\wzor.bmp");
               kolor = PoliczPixelW(FILTR_L_L,0,0);
               if (kolor>128) kolorT=0; else kolorT = 255;
               Form1->FiltrLPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrLPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
               Form1->FiltrLPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
               Form1->FiltrLPixelWT->Caption     = IntToStr(kolor);
               Form1->FiltrLPixelW->Visible = true;
               Form1->FiltrLPixelWT->Visible = true;
               ShowInfo(FILTR_L_L, 600, 315, 220, 80, 850, 480,
               "W wyniku tej operacji dostajemy wartosc jasnosci piksela, ktory zostanie "
               "umieszczony w obrazie wynikowym.");
               break;
            case 7:
               HideInfo(FILTR_L_L);
               Form1->FiltrLPixelWTimer->Enabled = true;
               break;
            case 8:
               RysujMacierz(FILTR_L_L); RysujMacierz(FILTR_L_R);
               Macierz.OknoFL_L.x = 1; Macierz.OknoFL_L.y = 0;
               Macierz.OknoFL_R.x = 2; Macierz.OknoFL_R.y = 1;
               RysujOkno(FILTR_L_L); RysujOkno(FILTR_L_R);
               WyswietlKolor(FILTR_L_L,1,0);
               WyswietlKolor(FILTR_L_L,2,0);
               WyswietlKolor(FILTR_L_L,3,0);
               WyswietlKolor(FILTR_L_L,1,1);
               WyswietlKolor(FILTR_L_L,2,1);
               WyswietlKolor(FILTR_L_L,3,1);
               WyswietlKolor(FILTR_L_L,1,2);
               WyswietlKolor(FILTR_L_L,2,2);
               WyswietlKolor(FILTR_L_L,3,2);
               break;
            case 9:
               Form1->FiltrLMatrixTimer->Enabled = true;
               break;
            case 10:
                kolor = PoliczPixelW(FILTR_L_L,1,0);
                if (kolor>128) kolorT=0; else kolorT = 255;
                Form1->FiltrLPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrLPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrLPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
                Form1->FiltrLPixelWT->Caption     = IntToStr(kolor);
                Form1->FiltrLPixelW->Left = 850; Form1->FiltrLPixelW->Top = 472;
                Form1->FiltrLPixelWT->Left = 853; Form1->FiltrLPixelWT->Top = 477;
                break;
            case 11:
                Form1->FiltrLPixelWTimer->Enabled = true;
                break;
            case 12:
               RysujMacierz(FILTR_L_L); RysujMacierz(FILTR_L_R);
               Macierz.OknoFL_L.x = 2; Macierz.OknoFL_L.y = 0;
               Macierz.OknoFL_R.x = 3; Macierz.OknoFL_R.y = 1;
               RysujOkno(FILTR_L_L); RysujOkno(FILTR_L_R);
               WyswietlKolor(FILTR_L_L,2,0);
               WyswietlKolor(FILTR_L_L,3,0);
               WyswietlKolor(FILTR_L_L,4,0);
               WyswietlKolor(FILTR_L_L,2,1);
               WyswietlKolor(FILTR_L_L,3,1);
               WyswietlKolor(FILTR_L_L,4,1);
               WyswietlKolor(FILTR_L_L,2,2);
               WyswietlKolor(FILTR_L_L,3,2);
               WyswietlKolor(FILTR_L_L,4,2);
               break;
            case 13:
                Form1->FiltrLMatrixTimer->Enabled = true;
                break;
            case 14:
                kolor = PoliczPixelW(FILTR_L_L,2,0);
                if (kolor>128) kolorT=0; else kolorT = 255;
                Form1->FiltrLPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrLPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
                Form1->FiltrLPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
                Form1->FiltrLPixelWT->Caption     = IntToStr(kolor);
                Form1->FiltrLPixelW->Left = 850; Form1->FiltrLPixelW->Top = 472;
                Form1->FiltrLPixelWT->Left = 853; Form1->FiltrLPixelWT->Top = 477;
                break;
            case 15:
                Form1->FiltrLDalej->Caption = "Auto >";
                Form1->FiltrLPixelWTimer->Enabled = true;
                RysujMacierz(FILTR_L_L); RysujMacierz(FILTR_L_R);
                break;
            case 16:
                Form1->FiltrLAutoTimer->Enabled = true;
                break;
            case 17:
               ShowInfo(FILTR_L_L, 350, 30, 280, 110, 800, 200,
               " Jak widac po uzyskanym wyniku filtr Laplace nadaje sie dobrze do wykrywania krawedzi obiektow (konturow),"
               " poniewaz w obrazie wynikowym wyodrebnia je w postaci jasnych pikseli. Ciemne piksele informuja nas o braku krawedzi"
               " lub o wystepowaniu bardzo niewielkich roznic w jasnosci");
               Form1->FiltrLDalej->Caption = "Przyklady >>>";
               break;
            case 18:
                Form1->PageControl1->SelectNextPage(true,true);
                break;
            default:
                Form1->PageControl1->SelectNextPage(true,true);
                break;
         }
         break;
   }
}



void __fastcall TForm1::FiltrDPDalejClick(TObject *Sender)
{
   Slajdy.FiltrDPnrSlajdu++;
   Prezentacja(FILTR_DP_L);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrGPDalejClick(TObject *Sender)
{
   Slajdy.FiltrGPnrSlajdu++;
   Prezentacja(FILTR_GP_L);
}
//---------------------------------------------------------------------------


void __fastcall TForm1::FiltrDPMaskaTimerTimer(TObject *Sender)
{
 // wspolrzedne przeznaczenia
   int X[9] = {180, 255, 330, 405, 480, 555, 630, 705, 780};
   int Y[9] = {450, 450, 450, 450, 450, 450, 450, 450, 450};
   // wspolrzedne poczatkowe
   int mX[9] = {450, 474, 498, 450, 474, 498, 450, 474, 498};
   int mY[9] = {120, 120, 120, 144, 144, 144, 168, 168, 168};
   static int time=0;

   time++;
   // ramki
   Form1->FiltrDPMaska1->Left = mX[0]+(int)((time/50.0)*(X[0]-mX[0]));
   Form1->FiltrDPMaska1->Top  = mY[0]+(int)((time/50.0)*(Y[0]-mY[0]));
   Form1->FiltrDPMaska2->Left = mX[1]+(int)((time/50.0)*(X[1]-mX[1]));
   Form1->FiltrDPMaska2->Top  = mY[1]+(int)((time/50.0)*(Y[1]-mY[1]));
   Form1->FiltrDPMaska3->Left = mX[2]+(int)((time/50.0)*(X[2]-mX[2]));
   Form1->FiltrDPMaska3->Top  = mY[2]+(int)((time/50.0)*(Y[2]-mY[2]));
   Form1->FiltrDPMaska4->Left = mX[3]+(int)((time/50.0)*(X[3]-mX[3]));
   Form1->FiltrDPMaska4->Top  = mY[3]+(int)((time/50.0)*(Y[3]-mY[3]));
   Form1->FiltrDPMaska5->Left = mX[4]+(int)((time/50.0)*(X[4]-mX[4]));
   Form1->FiltrDPMaska5->Top  = mY[4]+(int)((time/50.0)*(Y[4]-mY[4]));
   Form1->FiltrDPMaska6->Left = mX[5]+(int)((time/50.0)*(X[5]-mX[5]));
   Form1->FiltrDPMaska6->Top  = mY[5]+(int)((time/50.0)*(Y[5]-mY[5]));
   Form1->FiltrDPMaska7->Left = mX[6]+(int)((time/50.0)*(X[6]-mX[6]));
   Form1->FiltrDPMaska7->Top  = mY[6]+(int)((time/50.0)*(Y[6]-mY[6]));
   Form1->FiltrDPMaska8->Left = mX[7]+(int)((time/50.0)*(X[7]-mX[7]));
   Form1->FiltrDPMaska8->Top  = mY[7]+(int)((time/50.0)*(Y[7]-mY[7]));
   Form1->FiltrDPMaska9->Left = mX[8]+(int)((time/50.0)*(X[8]-mX[8]));
   Form1->FiltrDPMaska9->Top  = mY[8]+(int)((time/50.0)*(Y[8]-mY[8]));
   // zawartosc ramek
   Form1->FiltrDPMaskaT1->Left = mX[0]+10+(int)((time/50.0)*(X[0]-mX[0]));
   Form1->FiltrDPMaskaT1->Top  = mY[0]+ 5+(int)((time/50.0)*(Y[0]-mY[0]));
   Form1->FiltrDPMaskaT2->Left = mX[1]+10+(int)((time/50.0)*(X[1]-mX[1]));
   Form1->FiltrDPMaskaT2->Top  = mY[1]+ 5+(int)((time/50.0)*(Y[1]-mY[1]));
   Form1->FiltrDPMaskaT3->Left = mX[2]+10+(int)((time/50.0)*(X[2]-mX[2]));
   Form1->FiltrDPMaskaT3->Top  = mY[2]+ 5+(int)((time/50.0)*(Y[2]-mY[2]));
   Form1->FiltrDPMaskaT4->Left = mX[3]+10+(int)((time/50.0)*(X[3]-mX[3]));
   Form1->FiltrDPMaskaT4->Top  = mY[3]+ 5+(int)((time/50.0)*(Y[3]-mY[3]));
   Form1->FiltrDPMaskaT5->Left = mX[4]+10+(int)((time/50.0)*(X[4]-mX[4]));
   Form1->FiltrDPMaskaT5->Top  = mY[4]+ 5+(int)((time/50.0)*(Y[4]-mY[4]));
   Form1->FiltrDPMaskaT6->Left = mX[5]+10+(int)((time/50.0)*(X[5]-mX[5]));
   Form1->FiltrDPMaskaT6->Top  = mY[5]+ 5+(int)((time/50.0)*(Y[5]-mY[5]));
   Form1->FiltrDPMaskaT7->Left = mX[6]+10+(int)((time/50.0)*(X[6]-mX[6]));
   Form1->FiltrDPMaskaT7->Top  = mY[6]+ 5+(int)((time/50.0)*(Y[6]-mY[6]));
   Form1->FiltrDPMaskaT8->Left = mX[7]+10+(int)((time/50.0)*(X[7]-mX[7]));
   Form1->FiltrDPMaskaT8->Top  = mY[7]+ 5+(int)((time/50.0)*(Y[7]-mY[7]));
   Form1->FiltrDPMaskaT9->Left = mX[8]+10+(int)((time/50.0)*(X[8]-mX[8]));
   Form1->FiltrDPMaskaT9->Top  = mY[8]+ 5+(int)((time/50.0)*(Y[8]-mY[8]));

   if (time==50) Form1->FiltrDPMaskaTimer->Enabled = false;
}
//---------------------------------------------------------------------------
void WyswietlKolor(int filtr, int x, int y)
{
   int i,j,kolor;

   switch(filtr)
   {
      case FILTR_DP_L:
         kolor = Macierz.FiltrDP_L[y][x];
         if (kolor>128) Form1->FiltrDPImageLeft->Canvas->Font->Color = clBlack;
         else Form1->FiltrDPImageLeft->Canvas->Font->Color = clWhite;
         Form1->FiltrDPImageLeft->Canvas->Brush->Color = (TColor)RGB(kolor,kolor,kolor);;
         Form1->FiltrDPImageLeft->Canvas->TextOutA(x*PIXELSIZE+5, y*PIXELSIZE+5,IntToStr(kolor));
         break;
      case FILTR_GP_L:
         kolor = Macierz.FiltrGP_L[y][x];
         if (kolor>128) Form1->FiltrGPImageLeft->Canvas->Font->Color = clBlack;
         else Form1->FiltrGPImageLeft->Canvas->Font->Color = clWhite;
         Form1->FiltrGPImageLeft->Canvas->Brush->Color = (TColor)RGB(kolor,kolor,kolor);;
         Form1->FiltrGPImageLeft->Canvas->TextOutA(x*PIXELSIZE+5, y*PIXELSIZE+5,IntToStr(kolor));
         break;
       case FILTR_M_L:
         kolor = Macierz.FiltrM_L[y][x];
         if (kolor>128) Form1->FiltrMImageLeft->Canvas->Font->Color = clBlack;
         else Form1->FiltrMImageLeft->Canvas->Font->Color = clWhite;
         Form1->FiltrMImageLeft->Canvas->Brush->Color = (TColor)RGB(kolor,kolor,kolor);;
         Form1->FiltrMImageLeft->Canvas->TextOutA(x*PIXELSIZE+5, y*PIXELSIZE+5,IntToStr(kolor));
         break;
      case FILTR_L_L:
         kolor = Macierz.FiltrL_L[y][x];
         if (kolor>128) Form1->FiltrLImageLeft->Canvas->Font->Color = clBlack;
         else Form1->FiltrLImageLeft->Canvas->Font->Color = clWhite;
         Form1->FiltrLImageLeft->Canvas->Brush->Color = (TColor)RGB(kolor,kolor,kolor);;
         Form1->FiltrLImageLeft->Canvas->TextOutA(x*PIXELSIZE+5, y*PIXELSIZE+5,IntToStr(kolor));
         break;
      default: break;
   }
}

int PoliczPixelW(int filtr, int x, int y)
{
  int kolor,k[9];

  switch(filtr)
   {
      case FILTR_DP_L:
         kolor = Macierz.FiltrDP_L[y][x]   + Macierz.FiltrDP_L[y][x+1]   + Macierz.FiltrDP_L[y][x+2] +
                 Macierz.FiltrDP_L[y+1][x] + Macierz.FiltrDP_L[y+1][x+1] + Macierz.FiltrDP_L[y+1][x+2] +
                 Macierz.FiltrDP_L[y+2][x] + Macierz.FiltrDP_L[y+2][x+1] + Macierz.FiltrDP_L[y+2][x+2];
         kolor = kolor/9;
         return(kolor);
      case FILTR_GP_L:
         kolor =  0*Macierz.FiltrGP_L[y][x]   -   Macierz.FiltrGP_L[y][x+1]     + 0*Macierz.FiltrGP_L[y][x+2]
                 -  Macierz.FiltrGP_L[y+1][x] + 5*Macierz.FiltrGP_L[y+1][x+1]   -   Macierz.FiltrGP_L[y+1][x+2]
                 +0*Macierz.FiltrGP_L[y+2][x] -   Macierz.FiltrGP_L[y+2][x+1]   + 0*Macierz.FiltrGP_L[y+2][x+2];
         if (kolor>255) kolor=255;
         else if (kolor<0) kolor=0;
         return(kolor);
      case FILTR_M_L:
         k[0]=Macierz.FiltrM_L[y][x];   k[1]=Macierz.FiltrM_L[y][x+1];   k[2]=Macierz.FiltrM_L[y][x+2];
         k[3]=Macierz.FiltrM_L[y+1][x]; k[4]=Macierz.FiltrM_L[y+1][x+1]; k[5]=Macierz.FiltrM_L[y+1][x+2];
         k[6]=Macierz.FiltrM_L[y+2][x]; k[7]=Macierz.FiltrM_L[y+2][x+1]; k[8]=Macierz.FiltrM_L[y+2][x+2];
         // sortowanie: Bubble sort
         int p;
         for(int s=8; s>=0; s--)
         {
           for(int l=0; l<s; l++)
           {
             if (GetRValue(k[l])>GetRValue(k[l+1]))
             {
                  // przestaw piksele
                  p=k[l+1];
                  k[l+1]=k[l];
                  k[l]=p;
             }
           }
         }
         return(k[4]);
      case FILTR_L_L:
         kolor = -2*Macierz.FiltrL_L[y][x]   +   Macierz.FiltrL_L[y][x+1]     -2*Macierz.FiltrL_L[y][x+2]
                 +  Macierz.FiltrL_L[y+1][x] + 4*Macierz.FiltrL_L[y+1][x+1]   +  Macierz.FiltrL_L[y+1][x+2]
                 -2*Macierz.FiltrL_L[y+2][x] +   Macierz.FiltrL_L[y+2][x+1]   -2*Macierz.FiltrL_L[y+2][x+2];
         if (kolor>255) kolor=255;
         else if (kolor<0) kolor=0;
         return(kolor);
      default: break;
   }
   return 0;
}

void __fastcall TForm1::FiltrDPMatrixTimerTimer(TObject *Sender)
{
   // wspolrzedne przeznaczenia
   int X[9] = {150, 225, 300, 375, 450, 525, 600, 675, 750};
   int Y[9] = {450, 450, 450, 450, 450, 450, 450, 450, 450};
   // wspolrzedne poczatkowe
   static int mX[9] = {12, 37, 62, 12, 37, 62, 12, 37, 62};
   static int mY[9] = {12, 12, 12, 37, 37, 37, 62, 62, 62};
   static int a=0;  // nr animacji
   static int time=0;
   int kolor[9], kolorT[9];
   int i,j;

   if (time==0)
   {
      for(i=0; i<9; i++)
        if (a>0) mX[i]+=25;
        PoliczPixele(FILTR_DP_L,a,0);
      // blokada przycisku [dalej >]
      Form1->FiltrDPDalej->Enabled = false;
   }

   time++;
   // ramki
   Form1->FiltrDPPixel1->Left = mX[0]+(int)((time/50.0)*(X[0]-mX[0]));
   Form1->FiltrDPPixel1->Top  = mY[0]+(int)((time/50.0)*(Y[0]-mY[0]));
   Form1->FiltrDPPixel2->Left = mX[1]+(int)((time/50.0)*(X[1]-mX[1]));
   Form1->FiltrDPPixel2->Top  = mY[1]+(int)((time/50.0)*(Y[1]-mY[1]));
   Form1->FiltrDPPixel3->Left = mX[2]+(int)((time/50.0)*(X[2]-mX[2]));
   Form1->FiltrDPPixel3->Top  = mY[2]+(int)((time/50.0)*(Y[2]-mY[2]));
   Form1->FiltrDPPixel4->Left = mX[3]+(int)((time/50.0)*(X[3]-mX[3]));
   Form1->FiltrDPPixel4->Top  = mY[3]+(int)((time/50.0)*(Y[3]-mY[3]));
   Form1->FiltrDPPixel5->Left = mX[4]+(int)((time/50.0)*(X[4]-mX[4]));
   Form1->FiltrDPPixel5->Top  = mY[4]+(int)((time/50.0)*(Y[4]-mY[4]));
   Form1->FiltrDPPixel6->Left = mX[5]+(int)((time/50.0)*(X[5]-mX[5]));
   Form1->FiltrDPPixel6->Top  = mY[5]+(int)((time/50.0)*(Y[5]-mY[5]));
   Form1->FiltrDPPixel7->Left = mX[6]+(int)((time/50.0)*(X[6]-mX[6]));
   Form1->FiltrDPPixel7->Top  = mY[6]+(int)((time/50.0)*(Y[6]-mY[6]));
   Form1->FiltrDPPixel8->Left = mX[7]+(int)((time/50.0)*(X[7]-mX[7]));
   Form1->FiltrDPPixel8->Top  = mY[7]+(int)((time/50.0)*(Y[7]-mY[7]));
   Form1->FiltrDPPixel9->Left = mX[8]+(int)((time/50.0)*(X[8]-mX[8]));
   Form1->FiltrDPPixel9->Top  = mY[8]+(int)((time/50.0)*(Y[8]-mY[8]));
    // zawartosc ramek
   Form1->FiltrDPPixelT1->Left = mX[0]+3+(int)((time/50.0)*(X[0]-mX[0]));
   Form1->FiltrDPPixelT1->Top  = mY[0]+5+(int)((time/50.0)*(Y[0]-mY[0]));
   Form1->FiltrDPPixelT2->Left = mX[1]+3+(int)((time/50.0)*(X[1]-mX[1]));
   Form1->FiltrDPPixelT2->Top  = mY[1]+5+(int)((time/50.0)*(Y[1]-mY[1]));
   Form1->FiltrDPPixelT3->Left = mX[2]+3+(int)((time/50.0)*(X[2]-mX[2]));
   Form1->FiltrDPPixelT3->Top  = mY[2]+5+(int)((time/50.0)*(Y[2]-mY[2]));
   Form1->FiltrDPPixelT4->Left = mX[3]+3+(int)((time/50.0)*(X[3]-mX[3]));
   Form1->FiltrDPPixelT4->Top  = mY[3]+5+(int)((time/50.0)*(Y[3]-mY[3]));
   Form1->FiltrDPPixelT5->Left = mX[4]+3+(int)((time/50.0)*(X[4]-mX[4]));
   Form1->FiltrDPPixelT5->Top  = mY[4]+5+(int)((time/50.0)*(Y[4]-mY[4]));
   Form1->FiltrDPPixelT6->Left = mX[5]+3+(int)((time/50.0)*(X[5]-mX[5]));
   Form1->FiltrDPPixelT6->Top  = mY[5]+5+(int)((time/50.0)*(Y[5]-mY[5]));
   Form1->FiltrDPPixelT7->Left = mX[6]+3+(int)((time/50.0)*(X[6]-mX[6]));
   Form1->FiltrDPPixelT7->Top  = mY[6]+5+(int)((time/50.0)*(Y[6]-mY[6]));
   Form1->FiltrDPPixelT8->Left = mX[7]+3+(int)((time/50.0)*(X[7]-mX[7]));
   Form1->FiltrDPPixelT8->Top  = mY[7]+5+(int)((time/50.0)*(Y[7]-mY[7]));
   Form1->FiltrDPPixelT9->Left = mX[8]+3+(int)((time/50.0)*(X[8]-mX[8]));
   Form1->FiltrDPPixelT9->Top  = mY[8]+5+(int)((time/50.0)*(Y[8]-mY[8]));
   if (time==50)
   {
        Form1->FiltrDPMatrixTimer->Enabled = false;
        time=0; a++;
        // odblokowanie przycisku [dalej >]
        Form1->FiltrDPDalej->Enabled = true;
        Form1->FiltrDPDalej->SetFocus();
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrDPPixelWTimerTimer(TObject *Sender)
{
   // wspolrzedne przeznaczenia
   static int X = 687;
   static int Y = 37;
   // wspolrzedne poczatkowe
   static int mX = 850;
   static int mY = 472;
   static int a=0;  // nr animacji
   static int time=0;
   int kolor, kolorT;
   int i,j;

   if (time==0)
   {
        kolor = PoliczPixelW(FILTR_DP_L,0+a,0);
        if (kolor>128) kolorT = 0; else kolorT = 255;
        if (a>0) X+=25;
        Form1->FiltrDPPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrDPPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrDPPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
        Form1->FiltrDPPixelWT->Caption     = IntToStr(kolor);
        Macierz.FiltrDP_R[1][1+a] = kolor;
        // blokada przycisku [dalej >]
        Form1->FiltrDPDalej->Enabled = false;
   }

   time++;
   // ramki
   Form1->FiltrDPPixelW->Left = mX+(int)((time/50.0)*(X-mX));
   Form1->FiltrDPPixelW->Top  = mY+(int)((time/50.0)*(Y-mY));
    // zawartosc ramek
   Form1->FiltrDPPixelWT->Left = mX+3+(int)((time/50.0)*(X-mX));
   Form1->FiltrDPPixelWT->Top  = mY+5+(int)((time/50.0)*(Y-mY));
   if (time==50)
   {
        Form1->FiltrDPPixelWTimer->Enabled = false;
        time=0; a++;
        // odblokowanie przycisku [dalej >]
        Form1->FiltrDPDalej->Enabled = true;
        Form1->FiltrDPDalej->SetFocus();
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrDPAutoTimerTimer(TObject *Sender)
{
   static int time=0;
   int kolor, kolorT;
   int ax,ay;

   if (time==0)
   {
        // blokada przycisku [dalej >]
        Form1->FiltrDPDalej->Enabled = false;
        Form1->FiltrDPPixelW->Left = 850; Form1->FiltrDPPixelW->Top = 472;
        Form1->FiltrDPPixelWT->Left = 853; Form1->FiltrDPPixelWT->Top = 477;
   }
   else
   if (time<8)
   {    // dokonczenie animacji 1 lini
        RysujMacierz(FILTR_DP_L); RysujMacierz(FILTR_DP_R);
        Macierz.OknoFDP_L.x = 2+time; Macierz.OknoFDP_L.y = 0;
        Macierz.OknoFDP_R.x = 3+time; Macierz.OknoFDP_R.y = 1;
        RysujOkno(FILTR_DP_L); RysujOkno(FILTR_DP_R);
        WyswietlKolor(FILTR_DP_L,2+time,0);
        WyswietlKolor(FILTR_DP_L,3+time,0);
        WyswietlKolor(FILTR_DP_L,4+time,0);
        WyswietlKolor(FILTR_DP_L,2+time,1);
        WyswietlKolor(FILTR_DP_L,3+time,1);
        WyswietlKolor(FILTR_DP_L,4+time,1);
        WyswietlKolor(FILTR_DP_L,2+time,2);
        WyswietlKolor(FILTR_DP_L,3+time,2);
        WyswietlKolor(FILTR_DP_L,4+time,2);
        kolor = PoliczPixelW(FILTR_DP_L,2+time,0);
        if (kolor>128) kolorT=0; else kolorT = 255;
        Form1->FiltrDPPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrDPPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrDPPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
        Form1->FiltrDPPixelWT->Caption     = IntToStr(kolor);
        Form1->FiltrDPPixelW->Left = 737+25*time; Form1->FiltrDPPixelW->Top = 37;
        Form1->FiltrDPPixelWT->Left = 740+25*time; Form1->FiltrDPPixelWT->Top = 44;
        Macierz.FiltrDP_R[1][3+time] = kolor;
        PoliczPixele(FILTR_DP_L,2+time,0);
   }
   else
   if (time<98)
   {
        ax=(time-8)%10;
        ay=(time-8)/10;
        RysujMacierz(FILTR_DP_L); RysujMacierz(FILTR_DP_R);
        Macierz.OknoFDP_L.x = ax; Macierz.OknoFDP_L.y = 1+ay;
        Macierz.OknoFDP_R.x = 1+ax; Macierz.OknoFDP_R.y = 2+ay;
        RysujOkno(FILTR_DP_L); RysujOkno(FILTR_DP_R);
        WyswietlKolor(FILTR_DP_L,0+ax,1+ay);
        WyswietlKolor(FILTR_DP_L,1+ax,1+ay);
        WyswietlKolor(FILTR_DP_L,2+ax,1+ay);
        WyswietlKolor(FILTR_DP_L,0+ax,2+ay);
        WyswietlKolor(FILTR_DP_L,1+ax,2+ay);
        WyswietlKolor(FILTR_DP_L,2+ax,2+ay);
        WyswietlKolor(FILTR_DP_L,0+ax,3+ay);
        WyswietlKolor(FILTR_DP_L,1+ax,3+ay);
        WyswietlKolor(FILTR_DP_L,2+ax,3+ay);
        kolor = PoliczPixelW(FILTR_DP_L,ax,1+ay);
        if (kolor>128) kolorT=0; else kolorT = 255;
        Form1->FiltrDPPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrDPPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrDPPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
        Form1->FiltrDPPixelWT->Caption     = IntToStr(kolor);
        Form1->FiltrDPPixelW->Left = 687+25*ax; Form1->FiltrDPPixelW->Top = 62+25*ay;
        Form1->FiltrDPPixelWT->Left = 690+25*ax; Form1->FiltrDPPixelWT->Top = 69+25*ay;
        Macierz.FiltrDP_R[2+ay][1+ax] = kolor;
        PoliczPixele(FILTR_DP_L,ax,1+ay);
   }
   else
   {
                // odblokowanie przycisku [dalej >]
                Form1->FiltrDPDalej->Caption = "Dalej >";
                Form1->FiltrDPDalej->Enabled = true;
                Form1->FiltrDPDalej->SetFocus();
                Form1->FiltrDPAutoTimer->Enabled = false;
                time=0;
   }

   time++;

}
//---------------------------------------------------------------------------

// wylicza i ustawia kolor pikseli animowanych
int PoliczPixele(int filtr, int x, int y)
{
  int kolor[9], kolorT[9];
  int i,j;

  switch(filtr)
  {
      case FILTR_DP_L:
        for(j=0; j<3; j++)
          for(i=0; i<3; i++)
          {
                kolor[j*3+i]=Macierz.FiltrDP_L[y+j][x+i];
                if (kolor[j*3+i]>128) kolorT[j*3+i] = 0; else kolorT[j*3+i] = 255;
          }
      Form1->FiltrDPPixel1->Brush->Color = (TColor)RGB(kolor[0],kolor[0],kolor[0]);
      Form1->FiltrDPPixelT1->Color       = (TColor)RGB(kolor[0],kolor[0],kolor[0]);
      Form1->FiltrDPPixelT1->Font->Color = (TColor)RGB(kolorT[0],kolorT[0],kolorT[0]);
      Form1->FiltrDPPixelT1->Caption     = IntToStr(kolor[0]);
      Form1->FiltrDPPixel2->Brush->Color = (TColor)RGB(kolor[1],kolor[1],kolor[1]);
      Form1->FiltrDPPixelT2->Color       = (TColor)RGB(kolor[1],kolor[1],kolor[1]);
      Form1->FiltrDPPixelT2->Font->Color = (TColor)RGB(kolorT[1],kolorT[1],kolorT[1]);
      Form1->FiltrDPPixelT2->Caption     = IntToStr(kolor[1]);
      Form1->FiltrDPPixel3->Brush->Color = (TColor)RGB(kolor[2],kolor[2],kolor[2]);
      Form1->FiltrDPPixelT3->Color       = (TColor)RGB(kolor[2],kolor[2],kolor[2]);
      Form1->FiltrDPPixelT3->Font->Color = (TColor)RGB(kolorT[2],kolorT[2],kolorT[2]);
      Form1->FiltrDPPixelT3->Caption     = IntToStr(kolor[2]);
      Form1->FiltrDPPixel4->Brush->Color = (TColor)RGB(kolor[3],kolor[3],kolor[3]);
      Form1->FiltrDPPixelT4->Color       = (TColor)RGB(kolor[3],kolor[3],kolor[3]);
      Form1->FiltrDPPixelT4->Font->Color = (TColor)RGB(kolorT[3],kolorT[3],kolorT[3]);
      Form1->FiltrDPPixelT4->Caption     = IntToStr(kolor[3]);
      Form1->FiltrDPPixel5->Brush->Color = (TColor)RGB(kolor[4],kolor[4],kolor[4]);
      Form1->FiltrDPPixelT5->Color       = (TColor)RGB(kolor[4],kolor[4],kolor[4]);
      Form1->FiltrDPPixelT5->Font->Color = (TColor)RGB(kolorT[4],kolorT[4],kolorT[4]);
      Form1->FiltrDPPixelT5->Caption     = IntToStr(kolor[4]);
      Form1->FiltrDPPixel6->Brush->Color = (TColor)RGB(kolor[5],kolor[5],kolor[5]);
      Form1->FiltrDPPixelT6->Color       = (TColor)RGB(kolor[5],kolor[5],kolor[5]);
      Form1->FiltrDPPixelT6->Font->Color = (TColor)RGB(kolorT[5],kolorT[5],kolorT[5]);
      Form1->FiltrDPPixelT6->Caption     = IntToStr(kolor[5]);
      Form1->FiltrDPPixel7->Brush->Color = (TColor)RGB(kolor[6],kolor[6],kolor[6]);
      Form1->FiltrDPPixelT7->Color       = (TColor)RGB(kolor[6],kolor[6],kolor[6]);
      Form1->FiltrDPPixelT7->Font->Color = (TColor)RGB(kolorT[6],kolorT[6],kolorT[6]);
      Form1->FiltrDPPixelT7->Caption     = IntToStr(kolor[6]);
      Form1->FiltrDPPixel8->Brush->Color = (TColor)RGB(kolor[7],kolor[7],kolor[7]);
      Form1->FiltrDPPixelT8->Color       = (TColor)RGB(kolor[7],kolor[7],kolor[7]);
      Form1->FiltrDPPixelT8->Font->Color = (TColor)RGB(kolorT[7],kolorT[7],kolorT[7]);
      Form1->FiltrDPPixelT8->Caption     = IntToStr(kolor[7]);
      Form1->FiltrDPPixel9->Brush->Color = (TColor)RGB(kolor[8],kolor[8],kolor[8]);
      Form1->FiltrDPPixelT9->Color       = (TColor)RGB(kolor[8],kolor[8],kolor[8]);
      Form1->FiltrDPPixelT9->Font->Color = (TColor)RGB(kolorT[8],kolorT[8],kolorT[8]);
      Form1->FiltrDPPixelT9->Caption     = IntToStr(kolor[8]);
      break;
       case FILTR_GP_L:
        for(j=0; j<3; j++)
          for(i=0; i<3; i++)
          {
                kolor[j*3+i]=Macierz.FiltrGP_L[y+j][x+i];
                if (kolor[j*3+i]>128) kolorT[j*3+i] = 0; else kolorT[j*3+i] = 255;
          }
      Form1->FiltrGPPixel1->Brush->Color = (TColor)RGB(kolor[0],kolor[0],kolor[0]);
      Form1->FiltrGPPixelT1->Color       = (TColor)RGB(kolor[0],kolor[0],kolor[0]);
      Form1->FiltrGPPixelT1->Font->Color = (TColor)RGB(kolorT[0],kolorT[0],kolorT[0]);
      Form1->FiltrGPPixelT1->Caption     = IntToStr(kolor[0]);
      Form1->FiltrGPPixel2->Brush->Color = (TColor)RGB(kolor[1],kolor[1],kolor[1]);
      Form1->FiltrGPPixelT2->Color       = (TColor)RGB(kolor[1],kolor[1],kolor[1]);
      Form1->FiltrGPPixelT2->Font->Color = (TColor)RGB(kolorT[1],kolorT[1],kolorT[1]);
      Form1->FiltrGPPixelT2->Caption     = IntToStr(kolor[1]);
      Form1->FiltrGPPixel3->Brush->Color = (TColor)RGB(kolor[2],kolor[2],kolor[2]);
      Form1->FiltrGPPixelT3->Color       = (TColor)RGB(kolor[2],kolor[2],kolor[2]);
      Form1->FiltrGPPixelT3->Font->Color = (TColor)RGB(kolorT[2],kolorT[2],kolorT[2]);
      Form1->FiltrGPPixelT3->Caption     = IntToStr(kolor[2]);
      Form1->FiltrGPPixel4->Brush->Color = (TColor)RGB(kolor[3],kolor[3],kolor[3]);
      Form1->FiltrGPPixelT4->Color       = (TColor)RGB(kolor[3],kolor[3],kolor[3]);
      Form1->FiltrGPPixelT4->Font->Color = (TColor)RGB(kolorT[3],kolorT[3],kolorT[3]);
      Form1->FiltrGPPixelT4->Caption     = IntToStr(kolor[3]);
      Form1->FiltrGPPixel5->Brush->Color = (TColor)RGB(kolor[4],kolor[4],kolor[4]);
      Form1->FiltrGPPixelT5->Color       = (TColor)RGB(kolor[4],kolor[4],kolor[4]);
      Form1->FiltrGPPixelT5->Font->Color = (TColor)RGB(kolorT[4],kolorT[4],kolorT[4]);
      Form1->FiltrGPPixelT5->Caption     = IntToStr(kolor[4]);
      Form1->FiltrGPPixel6->Brush->Color = (TColor)RGB(kolor[5],kolor[5],kolor[5]);
      Form1->FiltrGPPixelT6->Color       = (TColor)RGB(kolor[5],kolor[5],kolor[5]);
      Form1->FiltrGPPixelT6->Font->Color = (TColor)RGB(kolorT[5],kolorT[5],kolorT[5]);
      Form1->FiltrGPPixelT6->Caption     = IntToStr(kolor[5]);
      Form1->FiltrGPPixel7->Brush->Color = (TColor)RGB(kolor[6],kolor[6],kolor[6]);
      Form1->FiltrGPPixelT7->Color       = (TColor)RGB(kolor[6],kolor[6],kolor[6]);
      Form1->FiltrGPPixelT7->Font->Color = (TColor)RGB(kolorT[6],kolorT[6],kolorT[6]);
      Form1->FiltrGPPixelT7->Caption     = IntToStr(kolor[6]);
      Form1->FiltrGPPixel8->Brush->Color = (TColor)RGB(kolor[7],kolor[7],kolor[7]);
      Form1->FiltrGPPixelT8->Color       = (TColor)RGB(kolor[7],kolor[7],kolor[7]);
      Form1->FiltrGPPixelT8->Font->Color = (TColor)RGB(kolorT[7],kolorT[7],kolorT[7]);
      Form1->FiltrGPPixelT8->Caption     = IntToStr(kolor[7]);
      Form1->FiltrGPPixel9->Brush->Color = (TColor)RGB(kolor[8],kolor[8],kolor[8]);
      Form1->FiltrGPPixelT9->Color       = (TColor)RGB(kolor[8],kolor[8],kolor[8]);
      Form1->FiltrGPPixelT9->Font->Color = (TColor)RGB(kolorT[8],kolorT[8],kolorT[8]);
      Form1->FiltrGPPixelT9->Caption     = IntToStr(kolor[8]);
      break;
      case FILTR_M_L:
        for(j=0; j<3; j++)
          for(i=0; i<3; i++)
          {
                kolor[j*3+i]=Macierz.FiltrM_L[y+j][x+i];
                if (kolor[j*3+i]>128) kolorT[j*3+i] = 0; else kolorT[j*3+i] = 255;
          }
      Form1->FiltrMPixel1->Brush->Color = (TColor)RGB(kolor[0],kolor[0],kolor[0]);
      Form1->FiltrMPixelT1->Color       = (TColor)RGB(kolor[0],kolor[0],kolor[0]);
      Form1->FiltrMPixelT1->Font->Color = (TColor)RGB(kolorT[0],kolorT[0],kolorT[0]);
      Form1->FiltrMPixelT1->Caption     = IntToStr(kolor[0]);
      Form1->FiltrMPixel2->Brush->Color = (TColor)RGB(kolor[1],kolor[1],kolor[1]);
      Form1->FiltrMPixelT2->Color       = (TColor)RGB(kolor[1],kolor[1],kolor[1]);
      Form1->FiltrMPixelT2->Font->Color = (TColor)RGB(kolorT[1],kolorT[1],kolorT[1]);
      Form1->FiltrMPixelT2->Caption     = IntToStr(kolor[1]);
      Form1->FiltrMPixel3->Brush->Color = (TColor)RGB(kolor[2],kolor[2],kolor[2]);
      Form1->FiltrMPixelT3->Color       = (TColor)RGB(kolor[2],kolor[2],kolor[2]);
      Form1->FiltrMPixelT3->Font->Color = (TColor)RGB(kolorT[2],kolorT[2],kolorT[2]);
      Form1->FiltrMPixelT3->Caption     = IntToStr(kolor[2]);
      Form1->FiltrMPixel4->Brush->Color = (TColor)RGB(kolor[3],kolor[3],kolor[3]);
      Form1->FiltrMPixelT4->Color       = (TColor)RGB(kolor[3],kolor[3],kolor[3]);
      Form1->FiltrMPixelT4->Font->Color = (TColor)RGB(kolorT[3],kolorT[3],kolorT[3]);
      Form1->FiltrMPixelT4->Caption     = IntToStr(kolor[3]);
      Form1->FiltrMPixel5->Brush->Color = (TColor)RGB(kolor[4],kolor[4],kolor[4]);
      Form1->FiltrMPixelT5->Color       = (TColor)RGB(kolor[4],kolor[4],kolor[4]);
      Form1->FiltrMPixelT5->Font->Color = (TColor)RGB(kolorT[4],kolorT[4],kolorT[4]);
      Form1->FiltrMPixelT5->Caption     = IntToStr(kolor[4]);
      Form1->FiltrMPixel6->Brush->Color = (TColor)RGB(kolor[5],kolor[5],kolor[5]);
      Form1->FiltrMPixelT6->Color       = (TColor)RGB(kolor[5],kolor[5],kolor[5]);
      Form1->FiltrMPixelT6->Font->Color = (TColor)RGB(kolorT[5],kolorT[5],kolorT[5]);
      Form1->FiltrMPixelT6->Caption     = IntToStr(kolor[5]);
      Form1->FiltrMPixel7->Brush->Color = (TColor)RGB(kolor[6],kolor[6],kolor[6]);
      Form1->FiltrMPixelT7->Color       = (TColor)RGB(kolor[6],kolor[6],kolor[6]);
      Form1->FiltrMPixelT7->Font->Color = (TColor)RGB(kolorT[6],kolorT[6],kolorT[6]);
      Form1->FiltrMPixelT7->Caption     = IntToStr(kolor[6]);
      Form1->FiltrMPixel8->Brush->Color = (TColor)RGB(kolor[7],kolor[7],kolor[7]);
      Form1->FiltrMPixelT8->Color       = (TColor)RGB(kolor[7],kolor[7],kolor[7]);
      Form1->FiltrMPixelT8->Font->Color = (TColor)RGB(kolorT[7],kolorT[7],kolorT[7]);
      Form1->FiltrMPixelT8->Caption     = IntToStr(kolor[7]);
      Form1->FiltrMPixel9->Brush->Color = (TColor)RGB(kolor[8],kolor[8],kolor[8]);
      Form1->FiltrMPixelT9->Color       = (TColor)RGB(kolor[8],kolor[8],kolor[8]);
      Form1->FiltrMPixelT9->Font->Color = (TColor)RGB(kolorT[8],kolorT[8],kolorT[8]);
      Form1->FiltrMPixelT9->Caption     = IntToStr(kolor[8]);
      break;
      case FILTR_L_L:
        for(j=0; j<3; j++)
          for(i=0; i<3; i++)
          {
                kolor[j*3+i]=Macierz.FiltrL_L[y+j][x+i];
                if (kolor[j*3+i]>128) kolorT[j*3+i] = 0; else kolorT[j*3+i] = 255;
          }
      Form1->FiltrLPixel1->Brush->Color = (TColor)RGB(kolor[0],kolor[0],kolor[0]);
      Form1->FiltrLPixelT1->Color       = (TColor)RGB(kolor[0],kolor[0],kolor[0]);
      Form1->FiltrLPixelT1->Font->Color = (TColor)RGB(kolorT[0],kolorT[0],kolorT[0]);
      Form1->FiltrLPixelT1->Caption     = IntToStr(kolor[0]);
      Form1->FiltrLPixel2->Brush->Color = (TColor)RGB(kolor[1],kolor[1],kolor[1]);
      Form1->FiltrLPixelT2->Color       = (TColor)RGB(kolor[1],kolor[1],kolor[1]);
      Form1->FiltrLPixelT2->Font->Color = (TColor)RGB(kolorT[1],kolorT[1],kolorT[1]);
      Form1->FiltrLPixelT2->Caption     = IntToStr(kolor[1]);
      Form1->FiltrLPixel3->Brush->Color = (TColor)RGB(kolor[2],kolor[2],kolor[2]);
      Form1->FiltrLPixelT3->Color       = (TColor)RGB(kolor[2],kolor[2],kolor[2]);
      Form1->FiltrLPixelT3->Font->Color = (TColor)RGB(kolorT[2],kolorT[2],kolorT[2]);
      Form1->FiltrLPixelT3->Caption     = IntToStr(kolor[2]);
      Form1->FiltrLPixel4->Brush->Color = (TColor)RGB(kolor[3],kolor[3],kolor[3]);
      Form1->FiltrLPixelT4->Color       = (TColor)RGB(kolor[3],kolor[3],kolor[3]);
      Form1->FiltrLPixelT4->Font->Color = (TColor)RGB(kolorT[3],kolorT[3],kolorT[3]);
      Form1->FiltrLPixelT4->Caption     = IntToStr(kolor[3]);
      Form1->FiltrLPixel5->Brush->Color = (TColor)RGB(kolor[4],kolor[4],kolor[4]);
      Form1->FiltrLPixelT5->Color       = (TColor)RGB(kolor[4],kolor[4],kolor[4]);
      Form1->FiltrLPixelT5->Font->Color = (TColor)RGB(kolorT[4],kolorT[4],kolorT[4]);
      Form1->FiltrLPixelT5->Caption     = IntToStr(kolor[4]);
      Form1->FiltrLPixel6->Brush->Color = (TColor)RGB(kolor[5],kolor[5],kolor[5]);
      Form1->FiltrLPixelT6->Color       = (TColor)RGB(kolor[5],kolor[5],kolor[5]);
      Form1->FiltrLPixelT6->Font->Color = (TColor)RGB(kolorT[5],kolorT[5],kolorT[5]);
      Form1->FiltrLPixelT6->Caption     = IntToStr(kolor[5]);
      Form1->FiltrLPixel7->Brush->Color = (TColor)RGB(kolor[6],kolor[6],kolor[6]);
      Form1->FiltrLPixelT7->Color       = (TColor)RGB(kolor[6],kolor[6],kolor[6]);
      Form1->FiltrLPixelT7->Font->Color = (TColor)RGB(kolorT[6],kolorT[6],kolorT[6]);
      Form1->FiltrLPixelT7->Caption     = IntToStr(kolor[6]);
      Form1->FiltrLPixel8->Brush->Color = (TColor)RGB(kolor[7],kolor[7],kolor[7]);
      Form1->FiltrLPixelT8->Color       = (TColor)RGB(kolor[7],kolor[7],kolor[7]);
      Form1->FiltrLPixelT8->Font->Color = (TColor)RGB(kolorT[7],kolorT[7],kolorT[7]);
      Form1->FiltrLPixelT8->Caption     = IntToStr(kolor[7]);
      Form1->FiltrLPixel9->Brush->Color = (TColor)RGB(kolor[8],kolor[8],kolor[8]);
      Form1->FiltrLPixelT9->Color       = (TColor)RGB(kolor[8],kolor[8],kolor[8]);
      Form1->FiltrLPixelT9->Font->Color = (TColor)RGB(kolorT[8],kolorT[8],kolorT[8]);
      Form1->FiltrLPixelT9->Caption     = IntToStr(kolor[8]);
      break;
      default: break;
   }
   return 0;
}

void __fastcall TForm1::Button1Click(TObject *Sender)
{
        Form1->PageControl1->SelectNextPage(true,true);        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrDP_P1_TimerTimer(TObject *Sender)
{
  static int i=0,j=0;
  int k[9], kWyn;

  for(i=0; i<=Form1->FiltrDP_P1_ImageLeft->Width; i++)
  {
       if(i>0 && j>0) k[0]=Form1->FiltrDP_P1_ImageLeft->Canvas->Pixels[i-1][j-1];
       else k[0]=Form1->FiltrDP_P1_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[1]=Form1->FiltrDP_P1_ImageLeft->Canvas->Pixels[i][j-1];
       else  k[1]=Form1->FiltrDP_P1_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[2]=Form1->FiltrDP_P1_ImageLeft->Canvas->Pixels[i+1][j-1];
       else k[2]=Form1->FiltrDP_P1_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[3]=Form1->FiltrDP_P1_ImageLeft->Canvas->Pixels[i-1][j];
       else k[3]=Form1->FiltrDP_P1_ImageLeft->Canvas->Pixels[i][j];
       k[4]=Form1->FiltrDP_P1_ImageLeft->Canvas->Pixels[i][j];
       k[5]=Form1->FiltrDP_P1_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[6]=Form1->FiltrDP_P1_ImageLeft->Canvas->Pixels[i-1][j+1];
       else k[6]=Form1->FiltrDP_P1_ImageLeft->Canvas->Pixels[i][j+1];
       k[7]=Form1->FiltrDP_P1_ImageLeft->Canvas->Pixels[i][j+1];
       k[8]=Form1->FiltrDP_P1_ImageLeft->Canvas->Pixels[i+1][j+1];
       // Kolor wynikowy
       kWyn=GetRValue(k[0])+GetRValue(k[1])+GetRValue(k[2])
           +GetRValue(k[3])+GetRValue(k[4])+GetRValue(k[5])
           +GetRValue(k[6])+GetRValue(k[7])+GetRValue(k[8]);
       kWyn/=9;
       Form1->FiltrDP_P1_ImageRight->Canvas->Pixels[i][j]=(TColor)RGB(kWyn,kWyn,kWyn);
       Form1->FiltrDP_P1_ImageRight->Canvas->MoveTo(0,j+1);
       Form1->FiltrDP_P1_ImageRight->Canvas->Pen->Color=(TColor)RGB(255,0,0);
       Form1->FiltrDP_P1_ImageRight->Canvas->LineTo(Form1->FiltrDP_P1_ImageLeft->Width,j+1);

  }
  j++;
  if (j>=Form1->FiltrDP_P1_ImageLeft->Height) {j=0; Form1->FiltrDP_P1_Timer->Enabled=false;}

}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrDP_P1_BtnFiltrujClick(TObject *Sender)
{
        Form1->FiltrDP_P1_Timer->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrDP_P2_BtnFiltrujClick(TObject *Sender)
{
        Form1->FiltrDP_P2_Timer->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrDP_P2_TimerTimer(TObject *Sender)
{
  static int i=0,j=0;
  int k[9], kWyn;

  for(i=0; i<=Form1->FiltrDP_P2_ImageLeft->Width; i++)
  {
       if(i>0 && j>0) k[0]=Form1->FiltrDP_P2_ImageLeft->Canvas->Pixels[i-1][j-1];
       else k[0]=Form1->FiltrDP_P2_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[1]=Form1->FiltrDP_P2_ImageLeft->Canvas->Pixels[i][j-1];
       else  k[1]=Form1->FiltrDP_P2_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[2]=Form1->FiltrDP_P2_ImageLeft->Canvas->Pixels[i+1][j-1];
       else k[2]=Form1->FiltrDP_P2_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[3]=Form1->FiltrDP_P2_ImageLeft->Canvas->Pixels[i-1][j];
       else k[3]=Form1->FiltrDP_P2_ImageLeft->Canvas->Pixels[i][j];
       k[4]=Form1->FiltrDP_P2_ImageLeft->Canvas->Pixels[i][j];
       k[5]=Form1->FiltrDP_P2_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[6]=Form1->FiltrDP_P2_ImageLeft->Canvas->Pixels[i-1][j+1];
       else k[6]=Form1->FiltrDP_P2_ImageLeft->Canvas->Pixels[i][j+1];
       k[7]=Form1->FiltrDP_P2_ImageLeft->Canvas->Pixels[i][j+1];
       k[8]=Form1->FiltrDP_P2_ImageLeft->Canvas->Pixels[i+1][j+1];
       // Kolor wynikowy
       kWyn=GetRValue(k[0])+GetRValue(k[1])+GetRValue(k[2])
           +GetRValue(k[3])+GetRValue(k[4])+GetRValue(k[5])
           +GetRValue(k[6])+GetRValue(k[7])+GetRValue(k[8]);
       kWyn/=9;
       Form1->FiltrDP_P2_ImageRight->Canvas->Pixels[i][j]=(TColor)RGB(kWyn,kWyn,kWyn);
       Form1->FiltrDP_P2_ImageRight->Canvas->MoveTo(0,j+1);
       Form1->FiltrDP_P2_ImageRight->Canvas->Pen->Color=(TColor)RGB(255,0,0);
       Form1->FiltrDP_P2_ImageRight->Canvas->LineTo(Form1->FiltrDP_P2_ImageLeft->Width,j+1);

  }
  j++;
  if (j>=Form1->FiltrDP_P2_ImageLeft->Height) {j=0; Form1->FiltrDP_P2_Timer->Enabled=false;}

}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrGP_P1_TimerTimer(TObject *Sender)
{
  static int i=0,j=0;
  int k[9], kWyn;

  for(i=0; i<=Form1->FiltrGP_P1_ImageLeft->Width; i++)
  {
       if(i>0 && j>0) k[0]=Form1->FiltrGP_P1_ImageLeft->Canvas->Pixels[i-1][j-1];
       else k[0]=Form1->FiltrGP_P1_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[1]=Form1->FiltrGP_P1_ImageLeft->Canvas->Pixels[i][j-1];
       else  k[1]=Form1->FiltrGP_P1_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[2]=Form1->FiltrGP_P1_ImageLeft->Canvas->Pixels[i+1][j-1];
       else k[2]=Form1->FiltrGP_P1_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[3]=Form1->FiltrGP_P1_ImageLeft->Canvas->Pixels[i-1][j];
       else k[3]=Form1->FiltrGP_P1_ImageLeft->Canvas->Pixels[i][j];
       k[4]=Form1->FiltrGP_P1_ImageLeft->Canvas->Pixels[i][j];
       k[5]=Form1->FiltrGP_P1_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[6]=Form1->FiltrGP_P1_ImageLeft->Canvas->Pixels[i-1][j+1];
       else k[6]=Form1->FiltrGP_P1_ImageLeft->Canvas->Pixels[i][j+1];
       k[7]=Form1->FiltrGP_P1_ImageLeft->Canvas->Pixels[i][j+1];
       k[8]=Form1->FiltrGP_P1_ImageLeft->Canvas->Pixels[i+1][j+1];
       // Kolor wynikowy
       kWyn=0*GetRValue(k[0])-GetRValue(k[1])+0*GetRValue(k[2])
           -GetRValue(k[3])+5*GetRValue(k[4])-GetRValue(k[5])
           +0*GetRValue(k[6])-GetRValue(k[7])+0*GetRValue(k[8]);
       if (kWyn>255) kWyn=255;
       else if (kWyn<0) kWyn=0;
       Form1->FiltrGP_P1_ImageRight->Canvas->Pixels[i][j]=(TColor)RGB(kWyn,kWyn,kWyn);
       Form1->FiltrGP_P1_ImageRight->Canvas->MoveTo(0,j+1);
       Form1->FiltrGP_P1_ImageRight->Canvas->Pen->Color=(TColor)RGB(255,0,0);
       Form1->FiltrGP_P1_ImageRight->Canvas->LineTo(Form1->FiltrGP_P1_ImageLeft->Width,j+1);

  }
  j++;
  if (j>=Form1->FiltrGP_P1_ImageLeft->Height) {j=0; Form1->FiltrGP_P1_Timer->Enabled=false;}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrGP_P1_BtnFiltrujClick(TObject *Sender)
{
        Form1->FiltrGP_P1_Timer->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrGP_P2_BtnFiltrujClick(TObject *Sender)
{
        Form1->FiltrGP_P2_Timer->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrGP_P2_TimerTimer(TObject *Sender)
{
  static int i=0,j=0;
  int k[9], kWyn;

  for(i=0; i<=Form1->FiltrGP_P2_ImageLeft->Width; i++)
  {
       if(i>0 && j>0) k[0]=Form1->FiltrGP_P2_ImageLeft->Canvas->Pixels[i-1][j-1];
       else k[0]=Form1->FiltrGP_P2_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[1]=Form1->FiltrGP_P2_ImageLeft->Canvas->Pixels[i][j-1];
       else  k[1]=Form1->FiltrGP_P2_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[2]=Form1->FiltrGP_P2_ImageLeft->Canvas->Pixels[i+1][j-1];
       else k[2]=Form1->FiltrGP_P2_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[3]=Form1->FiltrGP_P2_ImageLeft->Canvas->Pixels[i-1][j];
       else k[3]=Form1->FiltrGP_P2_ImageLeft->Canvas->Pixels[i][j];
       k[4]=Form1->FiltrGP_P2_ImageLeft->Canvas->Pixels[i][j];
       k[5]=Form1->FiltrGP_P2_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[6]=Form1->FiltrGP_P2_ImageLeft->Canvas->Pixels[i-1][j+1];
       else k[6]=Form1->FiltrGP_P2_ImageLeft->Canvas->Pixels[i][j+1];
       k[7]=Form1->FiltrGP_P2_ImageLeft->Canvas->Pixels[i][j+1];
       k[8]=Form1->FiltrGP_P2_ImageLeft->Canvas->Pixels[i+1][j+1];
       // Kolor wynikowy
       kWyn=0*GetRValue(k[0])-GetRValue(k[1])+0*GetRValue(k[2])
           -GetRValue(k[3])+5*GetRValue(k[4])-GetRValue(k[5])
           +0*GetRValue(k[6])-GetRValue(k[7])+0*GetRValue(k[8]);
       if (kWyn>255) kWyn=255;
       else if (kWyn<0) kWyn=0;
       Form1->FiltrGP_P2_ImageRight->Canvas->Pixels[i][j]=(TColor)RGB(kWyn,kWyn,kWyn);
       Form1->FiltrGP_P2_ImageRight->Canvas->MoveTo(0,j+1);
       Form1->FiltrGP_P2_ImageRight->Canvas->Pen->Color=(TColor)RGB(255,0,0);
       Form1->FiltrGP_P2_ImageRight->Canvas->LineTo(Form1->FiltrGP_P2_ImageLeft->Width,j+1);

  }
  j++;
  if (j>=Form1->FiltrGP_P2_ImageLeft->Height) {j=0; Form1->FiltrGP_P2_Timer->Enabled=false;}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrL_P1_BtnFiltrujClick(TObject *Sender)
{
         Form1->FiltrL_P1_Timer->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrL_P1_TimerTimer(TObject *Sender)
{
  static int i=0,j=0;
  int k[9], kWyn;

  for(i=0; i<=Form1->FiltrL_P1_ImageLeft->Width; i++)
  {
       if(i>0 && j>0) k[0]=Form1->FiltrL_P1_ImageLeft->Canvas->Pixels[i-1][j-1];
       else k[0]=Form1->FiltrL_P1_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[1]=Form1->FiltrL_P1_ImageLeft->Canvas->Pixels[i][j-1];
       else  k[1]=Form1->FiltrL_P1_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[2]=Form1->FiltrL_P1_ImageLeft->Canvas->Pixels[i+1][j-1];
       else k[2]=Form1->FiltrL_P1_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[3]=Form1->FiltrL_P1_ImageLeft->Canvas->Pixels[i-1][j];
       else k[3]=Form1->FiltrL_P1_ImageLeft->Canvas->Pixels[i][j];
       k[4]=Form1->FiltrL_P1_ImageLeft->Canvas->Pixels[i][j];
       k[5]=Form1->FiltrL_P1_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[6]=Form1->FiltrL_P1_ImageLeft->Canvas->Pixels[i-1][j+1];
       else k[6]=Form1->FiltrL_P1_ImageLeft->Canvas->Pixels[i][j+1];
       k[7]=Form1->FiltrL_P1_ImageLeft->Canvas->Pixels[i][j+1];
       k[8]=Form1->FiltrL_P1_ImageLeft->Canvas->Pixels[i+1][j+1];
       // Kolor wynikowy
       kWyn=-2*GetRValue(k[0])+GetRValue(k[1])-2*GetRValue(k[2])
           +GetRValue(k[3])+4*GetRValue(k[4])+GetRValue(k[5])
           -2*GetRValue(k[6])+GetRValue(k[7])-2*GetRValue(k[8]);
       if (kWyn>255) kWyn=255;
       else if (kWyn<0) kWyn=0;
       Form1->FiltrL_P1_ImageRight->Canvas->Pixels[i][j]=(TColor)RGB(kWyn,kWyn,kWyn);
       Form1->FiltrL_P1_ImageRight->Canvas->MoveTo(0,j+1);
       Form1->FiltrL_P1_ImageRight->Canvas->Pen->Color=(TColor)RGB(255,0,0);
       Form1->FiltrL_P1_ImageRight->Canvas->LineTo(Form1->FiltrL_P1_ImageLeft->Width,j+1);

  }
  j++;
  if (j>=Form1->FiltrL_P1_ImageLeft->Height) {j=0; Form1->FiltrL_P1_Timer->Enabled=false;}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrL_P2_BtnFiltrujClick(TObject *Sender)
{
        Form1->FiltrL_P2_Timer->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrL_P2_TimerTimer(TObject *Sender)
{
  static int i=0,j=0;
  int k[9], kWyn;

  for(i=0; i<=Form1->FiltrL_P2_ImageLeft->Width; i++)
  {
       if(i>0 && j>0) k[0]=Form1->FiltrL_P2_ImageLeft->Canvas->Pixels[i-1][j-1];
       else k[0]=Form1->FiltrL_P2_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[1]=Form1->FiltrL_P2_ImageLeft->Canvas->Pixels[i][j-1];
       else  k[1]=Form1->FiltrL_P2_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[2]=Form1->FiltrL_P2_ImageLeft->Canvas->Pixels[i+1][j-1];
       else k[2]=Form1->FiltrL_P2_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[3]=Form1->FiltrL_P2_ImageLeft->Canvas->Pixels[i-1][j];
       else k[3]=Form1->FiltrL_P2_ImageLeft->Canvas->Pixels[i][j];
       k[4]=Form1->FiltrL_P2_ImageLeft->Canvas->Pixels[i][j];
       k[5]=Form1->FiltrL_P2_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[6]=Form1->FiltrL_P2_ImageLeft->Canvas->Pixels[i-1][j+1];
       else k[6]=Form1->FiltrL_P2_ImageLeft->Canvas->Pixels[i][j+1];
       k[7]=Form1->FiltrL_P2_ImageLeft->Canvas->Pixels[i][j+1];
       k[8]=Form1->FiltrL_P2_ImageLeft->Canvas->Pixels[i+1][j+1];
       // Kolor wynikowy
       kWyn=-2*GetRValue(k[0])+GetRValue(k[1])-2*GetRValue(k[2])
           +GetRValue(k[3])+4*GetRValue(k[4])+GetRValue(k[5])
           -2*GetRValue(k[6])+GetRValue(k[7])-2*GetRValue(k[8]);
       if (kWyn>255) kWyn=255;
       else if (kWyn<0) kWyn=0;
       Form1->FiltrL_P2_ImageRight->Canvas->Pixels[i][j]=(TColor)RGB(kWyn,kWyn,kWyn);
       Form1->FiltrL_P2_ImageRight->Canvas->MoveTo(0,j+1);
       Form1->FiltrL_P2_ImageRight->Canvas->Pen->Color=(TColor)RGB(255,0,0);
       Form1->FiltrL_P2_ImageRight->Canvas->LineTo(Form1->FiltrL_P2_ImageLeft->Width,j+1);

  }
  j++;
  if (j>=Form1->FiltrL_P2_ImageLeft->Height) {j=0; Form1->FiltrL_P2_Timer->Enabled=false;}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrM_P1_BtnFiltrujClick(TObject *Sender)
{
         Form1->FiltrM_P1_Timer->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrM_P1_TimerTimer(TObject *Sender)
{
  static int i=0,j=0;
  int k[9], kWyn, l, s, p;

  for(i=0; i<=Form1->FiltrM_P1_ImageLeft->Width; i++)
  {
       if(i>0 && j>0) k[0]=Form1->FiltrM_P1_ImageLeft->Canvas->Pixels[i-1][j-1];
       else k[0]=Form1->FiltrM_P1_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[1]=Form1->FiltrM_P1_ImageLeft->Canvas->Pixels[i][j-1];
       else  k[1]=Form1->FiltrM_P1_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[2]=Form1->FiltrM_P1_ImageLeft->Canvas->Pixels[i+1][j-1];
       else k[2]=Form1->FiltrM_P1_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[3]=Form1->FiltrM_P1_ImageLeft->Canvas->Pixels[i-1][j];
       else k[3]=Form1->FiltrM_P1_ImageLeft->Canvas->Pixels[i][j];
       k[4]=Form1->FiltrM_P1_ImageLeft->Canvas->Pixels[i][j];
       k[5]=Form1->FiltrM_P1_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[6]=Form1->FiltrM_P1_ImageLeft->Canvas->Pixels[i-1][j+1];
       else k[6]=Form1->FiltrM_P1_ImageLeft->Canvas->Pixels[i][j+1];
       k[7]=Form1->FiltrM_P1_ImageLeft->Canvas->Pixels[i][j+1];
       k[8]=Form1->FiltrM_P1_ImageLeft->Canvas->Pixels[i+1][j+1];
       // sortowanie: Bubble sort
       for(s=8; s>=0; s--)
       {
         for(l=0; l<s; l++)
         {
           if (GetRValue(k[l])>GetRValue(k[l+1]))
           {
                // przestaw piksele
                p=k[l+1];
                k[l+1]=k[l];
                k[l]=p;
           }
         }
       }
       // Kolor wynikowy
       kWyn=GetRValue(k[4]);
       Form1->FiltrM_P1_ImageRight->Canvas->Pixels[i][j]=(TColor)RGB(kWyn,kWyn,kWyn);
       Form1->FiltrM_P1_ImageRight->Canvas->MoveTo(0,j+1);
       Form1->FiltrM_P1_ImageRight->Canvas->Pen->Color=(TColor)RGB(255,0,0);
       Form1->FiltrM_P1_ImageRight->Canvas->LineTo(Form1->FiltrM_P1_ImageLeft->Width,j+1);

  }
  j++;
  if (j>=Form1->FiltrM_P1_ImageLeft->Height) {j=0; Form1->FiltrM_P1_Timer->Enabled=false;}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrM_P2_BtnFiltrujClick(TObject *Sender)
{
          Form1->FiltrM_P2_Timer->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrM_P2_TimerTimer(TObject *Sender)
{
  static int i=0,j=0;
  int k[9], kWyn, l, s, p;

  for(i=0; i<=Form1->FiltrM_P2_ImageLeft->Width; i++)
  {
       if(i>0 && j>0) k[0]=Form1->FiltrM_P2_ImageLeft->Canvas->Pixels[i-1][j-1];
       else k[0]=Form1->FiltrM_P2_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[1]=Form1->FiltrM_P2_ImageLeft->Canvas->Pixels[i][j-1];
       else  k[1]=Form1->FiltrM_P2_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[2]=Form1->FiltrM_P2_ImageLeft->Canvas->Pixels[i+1][j-1];
       else k[2]=Form1->FiltrM_P2_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[3]=Form1->FiltrM_P2_ImageLeft->Canvas->Pixels[i-1][j];
       else k[3]=Form1->FiltrM_P2_ImageLeft->Canvas->Pixels[i][j];
       k[4]=Form1->FiltrM_P2_ImageLeft->Canvas->Pixels[i][j];
       k[5]=Form1->FiltrM_P2_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[6]=Form1->FiltrM_P2_ImageLeft->Canvas->Pixels[i-1][j+1];
       else k[6]=Form1->FiltrM_P2_ImageLeft->Canvas->Pixels[i][j+1];
       k[7]=Form1->FiltrM_P2_ImageLeft->Canvas->Pixels[i][j+1];
       k[8]=Form1->FiltrM_P2_ImageLeft->Canvas->Pixels[i+1][j+1];
       // sortowanie: Bubble sort
       for(s=8; s>=0; s--)
       {
         for(l=0; l<s; l++)
         {
           if (GetRValue(k[l])>GetRValue(k[l+1]))
           {
                // przestaw piksele
                p=k[l+1];
                k[l+1]=k[l];
                k[l]=p;
           }
         }
       }
       // Kolor wynikowy
       kWyn=GetRValue(k[4]);
       Form1->FiltrM_P2_ImageRight->Canvas->Pixels[i][j]=(TColor)RGB(kWyn,kWyn,kWyn);
       Form1->FiltrM_P2_ImageRight->Canvas->MoveTo(0,j+1);
       Form1->FiltrM_P2_ImageRight->Canvas->Pen->Color=(TColor)RGB(255,0,0);
       Form1->FiltrM_P2_ImageRight->Canvas->LineTo(Form1->FiltrM_P2_ImageLeft->Width,j+1);

  }
  j++;
  if (j>=Form1->FiltrM_P2_ImageLeft->Height) {j=0; Form1->FiltrM_P2_Timer->Enabled=false;}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrM_P3_BtnFiltrujClick(TObject *Sender)
{
        Form1->FiltrM_P3_Timer->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrM_P3_TimerTimer(TObject *Sender)
{
  static int i=0,j=0;
  int k[9], kWyn, l, s, p;

  for(i=0; i<=Form1->FiltrM_P3_ImageLeft->Width; i++)
  {
       if(i>0 && j>0) k[0]=Form1->FiltrM_P3_ImageLeft->Canvas->Pixels[i-1][j-1];
       else k[0]=Form1->FiltrM_P3_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[1]=Form1->FiltrM_P3_ImageLeft->Canvas->Pixels[i][j-1];
       else  k[1]=Form1->FiltrM_P3_ImageLeft->Canvas->Pixels[i][j];
       if(j>0) k[2]=Form1->FiltrM_P3_ImageLeft->Canvas->Pixels[i+1][j-1];
       else k[2]=Form1->FiltrM_P3_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[3]=Form1->FiltrM_P3_ImageLeft->Canvas->Pixels[i-1][j];
       else k[3]=Form1->FiltrM_P3_ImageLeft->Canvas->Pixels[i][j];
       k[4]=Form1->FiltrM_P3_ImageLeft->Canvas->Pixels[i][j];
       k[5]=Form1->FiltrM_P3_ImageLeft->Canvas->Pixels[i+1][j];
       if(i>0) k[6]=Form1->FiltrM_P3_ImageLeft->Canvas->Pixels[i-1][j+1];
       else k[6]=Form1->FiltrM_P3_ImageLeft->Canvas->Pixels[i][j+1];
       k[7]=Form1->FiltrM_P3_ImageLeft->Canvas->Pixels[i][j+1];
       k[8]=Form1->FiltrM_P3_ImageLeft->Canvas->Pixels[i+1][j+1];
       // sortowanie: Bubble sort
       for(s=8; s>=0; s--)
       {
         for(l=0; l<s; l++)
         {
           if (GetRValue(k[l])>GetRValue(k[l+1]))
           {
                // przestaw piksele
                p=k[l+1];
                k[l+1]=k[l];
                k[l]=p;
           }
         }
       }
       // Kolor wynikowy
       kWyn=GetRValue(k[4]);
       Form1->FiltrM_P3_ImageRight->Canvas->Pixels[i][j]=(TColor)RGB(kWyn,kWyn,kWyn);
       Form1->FiltrM_P3_ImageRight->Canvas->MoveTo(0,j+1);
       Form1->FiltrM_P3_ImageRight->Canvas->Pen->Color=(TColor)RGB(255,0,0);
       Form1->FiltrM_P3_ImageRight->Canvas->LineTo(Form1->FiltrM_P3_ImageLeft->Width,j+1);

  }
  j++;
  if (j>=Form1->FiltrM_P3_ImageLeft->Height) {j=0; Form1->FiltrM_P3_Timer->Enabled=false;}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrGPMatrixTimerTimer(TObject *Sender)
{
   // wspolrzedne przeznaczenia
   int X[9] = {150, 225, 300, 375, 450, 525, 600, 675, 750};
   int Y[9] = {450, 450, 450, 450, 450, 450, 450, 450, 450};
   // wspolrzedne poczatkowe
   static int mX[9] = {12, 37, 62, 12, 37, 62, 12, 37, 62};
   static int mY[9] = {12, 12, 12, 37, 37, 37, 62, 62, 62};
   static int a=0;  // nr animacji
   static int time=0;
   int kolor[9], kolorT[9];
   int i,j;

   if (time==0)
   {
      for(i=0; i<9; i++)
        if (a>0) mX[i]+=25;
        PoliczPixele(FILTR_GP_L,a,0);
      // blokada przycisku [dalej >]
      Form1->FiltrGPDalej->Enabled = false;
   }

   time++;
   // ramki
   Form1->FiltrGPPixel1->Left = mX[0]+(int)((time/50.0)*(X[0]-mX[0]));
   Form1->FiltrGPPixel1->Top  = mY[0]+(int)((time/50.0)*(Y[0]-mY[0]));
   Form1->FiltrGPPixel2->Left = mX[1]+(int)((time/50.0)*(X[1]-mX[1]));
   Form1->FiltrGPPixel2->Top  = mY[1]+(int)((time/50.0)*(Y[1]-mY[1]));
   Form1->FiltrGPPixel3->Left = mX[2]+(int)((time/50.0)*(X[2]-mX[2]));
   Form1->FiltrGPPixel3->Top  = mY[2]+(int)((time/50.0)*(Y[2]-mY[2]));
   Form1->FiltrGPPixel4->Left = mX[3]+(int)((time/50.0)*(X[3]-mX[3]));
   Form1->FiltrGPPixel4->Top  = mY[3]+(int)((time/50.0)*(Y[3]-mY[3]));
   Form1->FiltrGPPixel5->Left = mX[4]+(int)((time/50.0)*(X[4]-mX[4]));
   Form1->FiltrGPPixel5->Top  = mY[4]+(int)((time/50.0)*(Y[4]-mY[4]));
   Form1->FiltrGPPixel6->Left = mX[5]+(int)((time/50.0)*(X[5]-mX[5]));
   Form1->FiltrGPPixel6->Top  = mY[5]+(int)((time/50.0)*(Y[5]-mY[5]));
   Form1->FiltrGPPixel7->Left = mX[6]+(int)((time/50.0)*(X[6]-mX[6]));
   Form1->FiltrGPPixel7->Top  = mY[6]+(int)((time/50.0)*(Y[6]-mY[6]));
   Form1->FiltrGPPixel8->Left = mX[7]+(int)((time/50.0)*(X[7]-mX[7]));
   Form1->FiltrGPPixel8->Top  = mY[7]+(int)((time/50.0)*(Y[7]-mY[7]));
   Form1->FiltrGPPixel9->Left = mX[8]+(int)((time/50.0)*(X[8]-mX[8]));
   Form1->FiltrGPPixel9->Top  = mY[8]+(int)((time/50.0)*(Y[8]-mY[8]));
    // zawartosc ramek
   Form1->FiltrGPPixelT1->Left = mX[0]+3+(int)((time/50.0)*(X[0]-mX[0]));
   Form1->FiltrGPPixelT1->Top  = mY[0]+5+(int)((time/50.0)*(Y[0]-mY[0]));
   Form1->FiltrGPPixelT2->Left = mX[1]+3+(int)((time/50.0)*(X[1]-mX[1]));
   Form1->FiltrGPPixelT2->Top  = mY[1]+5+(int)((time/50.0)*(Y[1]-mY[1]));
   Form1->FiltrGPPixelT3->Left = mX[2]+3+(int)((time/50.0)*(X[2]-mX[2]));
   Form1->FiltrGPPixelT3->Top  = mY[2]+5+(int)((time/50.0)*(Y[2]-mY[2]));
   Form1->FiltrGPPixelT4->Left = mX[3]+3+(int)((time/50.0)*(X[3]-mX[3]));
   Form1->FiltrGPPixelT4->Top  = mY[3]+5+(int)((time/50.0)*(Y[3]-mY[3]));
   Form1->FiltrGPPixelT5->Left = mX[4]+3+(int)((time/50.0)*(X[4]-mX[4]));
   Form1->FiltrGPPixelT5->Top  = mY[4]+5+(int)((time/50.0)*(Y[4]-mY[4]));
   Form1->FiltrGPPixelT6->Left = mX[5]+3+(int)((time/50.0)*(X[5]-mX[5]));
   Form1->FiltrGPPixelT6->Top  = mY[5]+5+(int)((time/50.0)*(Y[5]-mY[5]));
   Form1->FiltrGPPixelT7->Left = mX[6]+3+(int)((time/50.0)*(X[6]-mX[6]));
   Form1->FiltrGPPixelT7->Top  = mY[6]+5+(int)((time/50.0)*(Y[6]-mY[6]));
   Form1->FiltrGPPixelT8->Left = mX[7]+3+(int)((time/50.0)*(X[7]-mX[7]));
   Form1->FiltrGPPixelT8->Top  = mY[7]+5+(int)((time/50.0)*(Y[7]-mY[7]));
   Form1->FiltrGPPixelT9->Left = mX[8]+3+(int)((time/50.0)*(X[8]-mX[8]));
   Form1->FiltrGPPixelT9->Top  = mY[8]+5+(int)((time/50.0)*(Y[8]-mY[8]));
   if (time==50)
   {
        Form1->FiltrGPMatrixTimer->Enabled = false;
        time=0; a++;
        // odblokowanie przycisku [dalej >]
        Form1->FiltrGPDalej->Enabled = true;
        Form1->FiltrGPDalej->SetFocus();
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrGPMaskaTimerTimer(TObject *Sender)
{
 // wspolrzedne przeznaczenia
   int X[9] = {180, 255, 330, 405, 480, 555, 630, 705, 780};
   int Y[9] = {450, 450, 450, 450, 450, 450, 450, 450, 450};
   // wspolrzedne poczatkowe
   int mX[9] = {450, 474, 498, 450, 474, 498, 450, 474, 498};
   int mY[9] = {120, 120, 120, 144, 144, 144, 168, 168, 168};
   static int time=0;

   time++;
   // ramki
   Form1->FiltrGPMaska1->Left = mX[0]+(int)((time/50.0)*(X[0]-mX[0]));
   Form1->FiltrGPMaska1->Top  = mY[0]+(int)((time/50.0)*(Y[0]-mY[0]));
   Form1->FiltrGPMaska2->Left = mX[1]+(int)((time/50.0)*(X[1]-mX[1]));
   Form1->FiltrGPMaska2->Top  = mY[1]+(int)((time/50.0)*(Y[1]-mY[1]));
   Form1->FiltrGPMaska3->Left = mX[2]+(int)((time/50.0)*(X[2]-mX[2]));
   Form1->FiltrGPMaska3->Top  = mY[2]+(int)((time/50.0)*(Y[2]-mY[2]));
   Form1->FiltrGPMaska4->Left = mX[3]+(int)((time/50.0)*(X[3]-mX[3]));
   Form1->FiltrGPMaska4->Top  = mY[3]+(int)((time/50.0)*(Y[3]-mY[3]));
   Form1->FiltrGPMaska5->Left = mX[4]+(int)((time/50.0)*(X[4]-mX[4]));
   Form1->FiltrGPMaska5->Top  = mY[4]+(int)((time/50.0)*(Y[4]-mY[4]));
   Form1->FiltrGPMaska6->Left = mX[5]+(int)((time/50.0)*(X[5]-mX[5]));
   Form1->FiltrGPMaska6->Top  = mY[5]+(int)((time/50.0)*(Y[5]-mY[5]));
   Form1->FiltrGPMaska7->Left = mX[6]+(int)((time/50.0)*(X[6]-mX[6]));
   Form1->FiltrGPMaska7->Top  = mY[6]+(int)((time/50.0)*(Y[6]-mY[6]));
   Form1->FiltrGPMaska8->Left = mX[7]+(int)((time/50.0)*(X[7]-mX[7]));
   Form1->FiltrGPMaska8->Top  = mY[7]+(int)((time/50.0)*(Y[7]-mY[7]));
   Form1->FiltrGPMaska9->Left = mX[8]+(int)((time/50.0)*(X[8]-mX[8]));
   Form1->FiltrGPMaska9->Top  = mY[8]+(int)((time/50.0)*(Y[8]-mY[8]));
   // zawartosc ramek
   Form1->FiltrGPMaskaT1->Left = mX[0]+10+(int)((time/50.0)*(X[0]-mX[0]));
   Form1->FiltrGPMaskaT1->Top  = mY[0]+ 5+(int)((time/50.0)*(Y[0]-mY[0]));
   Form1->FiltrGPMaskaT2->Left = mX[1]+10+(int)((time/50.0)*(X[1]-mX[1]));
   Form1->FiltrGPMaskaT2->Top  = mY[1]+ 5+(int)((time/50.0)*(Y[1]-mY[1]));
   Form1->FiltrGPMaskaT3->Left = mX[2]+10+(int)((time/50.0)*(X[2]-mX[2]));
   Form1->FiltrGPMaskaT3->Top  = mY[2]+ 5+(int)((time/50.0)*(Y[2]-mY[2]));
   Form1->FiltrGPMaskaT4->Left = mX[3]+10+(int)((time/50.0)*(X[3]-mX[3]));
   Form1->FiltrGPMaskaT4->Top  = mY[3]+ 5+(int)((time/50.0)*(Y[3]-mY[3]));
   Form1->FiltrGPMaskaT5->Left = mX[4]+10+(int)((time/50.0)*(X[4]-mX[4]));
   Form1->FiltrGPMaskaT5->Top  = mY[4]+ 5+(int)((time/50.0)*(Y[4]-mY[4]));
   Form1->FiltrGPMaskaT6->Left = mX[5]+10+(int)((time/50.0)*(X[5]-mX[5]));
   Form1->FiltrGPMaskaT6->Top  = mY[5]+ 5+(int)((time/50.0)*(Y[5]-mY[5]));
   Form1->FiltrGPMaskaT7->Left = mX[6]+10+(int)((time/50.0)*(X[6]-mX[6]));
   Form1->FiltrGPMaskaT7->Top  = mY[6]+ 5+(int)((time/50.0)*(Y[6]-mY[6]));
   Form1->FiltrGPMaskaT8->Left = mX[7]+10+(int)((time/50.0)*(X[7]-mX[7]));
   Form1->FiltrGPMaskaT8->Top  = mY[7]+ 5+(int)((time/50.0)*(Y[7]-mY[7]));
   Form1->FiltrGPMaskaT9->Left = mX[8]+10+(int)((time/50.0)*(X[8]-mX[8]));
   Form1->FiltrGPMaskaT9->Top  = mY[8]+ 5+(int)((time/50.0)*(Y[8]-mY[8]));

   if (time==50) Form1->FiltrGPMaskaTimer->Enabled = false;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrGPPixelWTimerTimer(TObject *Sender)
{
  // wspolrzedne przeznaczenia
   static int X = 687;
   static int Y = 37;
   // wspolrzedne poczatkowe
   static int mX = 850;
   static int mY = 472;
   static int a=0;  // nr animacji
   static int time=0;
   int kolor, kolorT;
   int i,j;

   if (time==0)
   {
        kolor = PoliczPixelW(FILTR_GP_L,0+a,0);
        if (kolor>128) kolorT = 0; else kolorT = 255;
        if (a>0) X+=25;
        Form1->FiltrGPPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrGPPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrGPPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
        Form1->FiltrGPPixelWT->Caption     = IntToStr(kolor);
        Macierz.FiltrGP_R[1][1+a] = kolor;
        // blokada przycisku [dalej >]
        Form1->FiltrGPDalej->Enabled = false;
   }

   time++;
   // ramki
   Form1->FiltrGPPixelW->Left = mX+(int)((time/50.0)*(X-mX));
   Form1->FiltrGPPixelW->Top  = mY+(int)((time/50.0)*(Y-mY));
    // zawartosc ramek
   Form1->FiltrGPPixelWT->Left = mX+3+(int)((time/50.0)*(X-mX));
   Form1->FiltrGPPixelWT->Top  = mY+5+(int)((time/50.0)*(Y-mY));
   if (time==50)
   {
        Form1->FiltrGPPixelWTimer->Enabled = false;
        time=0; a++;
        // odblokowanie przycisku [dalej >]
        Form1->FiltrGPDalej->Enabled = true;
        Form1->FiltrGPDalej->SetFocus();
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrGPAutoTimerTimer(TObject *Sender)
{
   static int time=0;
   int kolor, kolorT;
   int ax,ay;

   if (time==0)
   {
        // blokada przycisku [dalej >]
        Form1->FiltrGPDalej->Enabled = false;
        Form1->FiltrGPPixelW->Left = 850; Form1->FiltrGPPixelW->Top = 472;
        Form1->FiltrGPPixelWT->Left = 853; Form1->FiltrGPPixelWT->Top = 477;
   }
   else
   if (time<8)
   {    // dokonczenie animacji 1 lini
        RysujMacierz(FILTR_GP_L); RysujMacierz(FILTR_GP_R);
        Macierz.OknoFGP_L.x = 2+time; Macierz.OknoFGP_L.y = 0;
        Macierz.OknoFGP_R.x = 3+time; Macierz.OknoFGP_R.y = 1;
        RysujOkno(FILTR_GP_L); RysujOkno(FILTR_GP_R);
        WyswietlKolor(FILTR_GP_L,2+time,0);
        WyswietlKolor(FILTR_GP_L,3+time,0);
        WyswietlKolor(FILTR_GP_L,4+time,0);
        WyswietlKolor(FILTR_GP_L,2+time,1);
        WyswietlKolor(FILTR_GP_L,3+time,1);
        WyswietlKolor(FILTR_GP_L,4+time,1);
        WyswietlKolor(FILTR_GP_L,2+time,2);
        WyswietlKolor(FILTR_GP_L,3+time,2);
        WyswietlKolor(FILTR_GP_L,4+time,2);
        kolor = PoliczPixelW(FILTR_GP_L,2+time,0);
        if (kolor>128) kolorT=0; else kolorT = 255;
        Form1->FiltrGPPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrGPPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrGPPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
        Form1->FiltrGPPixelWT->Caption     = IntToStr(kolor);
        Form1->FiltrGPPixelW->Left = 737+25*time; Form1->FiltrGPPixelW->Top = 37;
        Form1->FiltrGPPixelWT->Left = 740+25*time; Form1->FiltrGPPixelWT->Top = 44;
        Macierz.FiltrGP_R[1][3+time] = kolor;
        PoliczPixele(FILTR_GP_L,2+time,0);
   }
   else
   if (time<98)
   {
        ax=(time-8)%10;
        ay=(time-8)/10;
        RysujMacierz(FILTR_GP_L); RysujMacierz(FILTR_GP_R);
        Macierz.OknoFGP_L.x = ax; Macierz.OknoFGP_L.y = 1+ay;
        Macierz.OknoFGP_R.x = 1+ax; Macierz.OknoFGP_R.y = 2+ay;
        RysujOkno(FILTR_GP_L); RysujOkno(FILTR_GP_R);
        WyswietlKolor(FILTR_GP_L,0+ax,1+ay);
        WyswietlKolor(FILTR_GP_L,1+ax,1+ay);
        WyswietlKolor(FILTR_GP_L,2+ax,1+ay);
        WyswietlKolor(FILTR_GP_L,0+ax,2+ay);
        WyswietlKolor(FILTR_GP_L,1+ax,2+ay);
        WyswietlKolor(FILTR_GP_L,2+ax,2+ay);
        WyswietlKolor(FILTR_GP_L,0+ax,3+ay);
        WyswietlKolor(FILTR_GP_L,1+ax,3+ay);
        WyswietlKolor(FILTR_GP_L,2+ax,3+ay);
        kolor = PoliczPixelW(FILTR_GP_L,ax,1+ay);
        if (kolor>128) kolorT=0; else kolorT = 255;
        Form1->FiltrGPPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrGPPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrGPPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
        Form1->FiltrGPPixelWT->Caption     = IntToStr(kolor);
        Form1->FiltrGPPixelW->Left = 687+25*ax; Form1->FiltrGPPixelW->Top = 62+25*ay;
        Form1->FiltrGPPixelWT->Left = 690+25*ax; Form1->FiltrGPPixelWT->Top = 69+25*ay;
        Macierz.FiltrGP_R[2+ay][1+ax] = kolor;
        PoliczPixele(FILTR_GP_L,ax,1+ay);
   }
   else
   {
                // odblokowanie przycisku [dalej >]
                Form1->FiltrGPDalej->Caption = "Dalej >";
                Form1->FiltrGPDalej->Enabled = true;
                Form1->FiltrGPDalej->SetFocus();
                Form1->FiltrGPAutoTimer->Enabled = false;
                time=0;
   }

   time++;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrLMatrixTimerTimer(TObject *Sender)
{
   // wspolrzedne przeznaczenia
   int X[9] = {150, 225, 300, 375, 450, 525, 600, 675, 750};
   int Y[9] = {450, 450, 450, 450, 450, 450, 450, 450, 450};
   // wspolrzedne poczatkowe
   static int mX[9] = {12, 37, 62, 12, 37, 62, 12, 37, 62};
   static int mY[9] = {12, 12, 12, 37, 37, 37, 62, 62, 62};
   static int a=0;  // nr animacji
   static int time=0;
   int kolor[9], kolorT[9];
   int i,j;

   if (time==0)
   {
      for(i=0; i<9; i++)
        if (a>0) mX[i]+=25;
        PoliczPixele(FILTR_L_L,a,0);
      // blokada przycisku [dalej >]
      Form1->FiltrLDalej->Enabled = false;
   }

   time++;
   // ramki
   Form1->FiltrLPixel1->Left = mX[0]+(int)((time/50.0)*(X[0]-mX[0]));
   Form1->FiltrLPixel1->Top  = mY[0]+(int)((time/50.0)*(Y[0]-mY[0]));
   Form1->FiltrLPixel2->Left = mX[1]+(int)((time/50.0)*(X[1]-mX[1]));
   Form1->FiltrLPixel2->Top  = mY[1]+(int)((time/50.0)*(Y[1]-mY[1]));
   Form1->FiltrLPixel3->Left = mX[2]+(int)((time/50.0)*(X[2]-mX[2]));
   Form1->FiltrLPixel3->Top  = mY[2]+(int)((time/50.0)*(Y[2]-mY[2]));
   Form1->FiltrLPixel4->Left = mX[3]+(int)((time/50.0)*(X[3]-mX[3]));
   Form1->FiltrLPixel4->Top  = mY[3]+(int)((time/50.0)*(Y[3]-mY[3]));
   Form1->FiltrLPixel5->Left = mX[4]+(int)((time/50.0)*(X[4]-mX[4]));
   Form1->FiltrLPixel5->Top  = mY[4]+(int)((time/50.0)*(Y[4]-mY[4]));
   Form1->FiltrLPixel6->Left = mX[5]+(int)((time/50.0)*(X[5]-mX[5]));
   Form1->FiltrLPixel6->Top  = mY[5]+(int)((time/50.0)*(Y[5]-mY[5]));
   Form1->FiltrLPixel7->Left = mX[6]+(int)((time/50.0)*(X[6]-mX[6]));
   Form1->FiltrLPixel7->Top  = mY[6]+(int)((time/50.0)*(Y[6]-mY[6]));
   Form1->FiltrLPixel8->Left = mX[7]+(int)((time/50.0)*(X[7]-mX[7]));
   Form1->FiltrLPixel8->Top  = mY[7]+(int)((time/50.0)*(Y[7]-mY[7]));
   Form1->FiltrLPixel9->Left = mX[8]+(int)((time/50.0)*(X[8]-mX[8]));
   Form1->FiltrLPixel9->Top  = mY[8]+(int)((time/50.0)*(Y[8]-mY[8]));
    // zawartosc ramek
   Form1->FiltrLPixelT1->Left = mX[0]+3+(int)((time/50.0)*(X[0]-mX[0]));
   Form1->FiltrLPixelT1->Top  = mY[0]+5+(int)((time/50.0)*(Y[0]-mY[0]));
   Form1->FiltrLPixelT2->Left = mX[1]+3+(int)((time/50.0)*(X[1]-mX[1]));
   Form1->FiltrLPixelT2->Top  = mY[1]+5+(int)((time/50.0)*(Y[1]-mY[1]));
   Form1->FiltrLPixelT3->Left = mX[2]+3+(int)((time/50.0)*(X[2]-mX[2]));
   Form1->FiltrLPixelT3->Top  = mY[2]+5+(int)((time/50.0)*(Y[2]-mY[2]));
   Form1->FiltrLPixelT4->Left = mX[3]+3+(int)((time/50.0)*(X[3]-mX[3]));
   Form1->FiltrLPixelT4->Top  = mY[3]+5+(int)((time/50.0)*(Y[3]-mY[3]));
   Form1->FiltrLPixelT5->Left = mX[4]+3+(int)((time/50.0)*(X[4]-mX[4]));
   Form1->FiltrLPixelT5->Top  = mY[4]+5+(int)((time/50.0)*(Y[4]-mY[4]));
   Form1->FiltrLPixelT6->Left = mX[5]+3+(int)((time/50.0)*(X[5]-mX[5]));
   Form1->FiltrLPixelT6->Top  = mY[5]+5+(int)((time/50.0)*(Y[5]-mY[5]));
   Form1->FiltrLPixelT7->Left = mX[6]+3+(int)((time/50.0)*(X[6]-mX[6]));
   Form1->FiltrLPixelT7->Top  = mY[6]+5+(int)((time/50.0)*(Y[6]-mY[6]));
   Form1->FiltrLPixelT8->Left = mX[7]+3+(int)((time/50.0)*(X[7]-mX[7]));
   Form1->FiltrLPixelT8->Top  = mY[7]+5+(int)((time/50.0)*(Y[7]-mY[7]));
   Form1->FiltrLPixelT9->Left = mX[8]+3+(int)((time/50.0)*(X[8]-mX[8]));
   Form1->FiltrLPixelT9->Top  = mY[8]+5+(int)((time/50.0)*(Y[8]-mY[8]));
   if (time==50)
   {
        Form1->FiltrLMatrixTimer->Enabled = false;
        time=0; a++;
        // odblokowanie przycisku [dalej >]
        Form1->FiltrLDalej->Enabled = true;
        Form1->FiltrLDalej->SetFocus();
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrLMaskaTimerTimer(TObject *Sender)
{
   // wspolrzedne przeznaczenia
   int X[9] = {180, 255, 330, 405, 480, 555, 630, 705, 780};
   int Y[9] = {450, 450, 450, 450, 450, 450, 450, 450, 450};
   // wspolrzedne poczatkowe
   int mX[9] = {450, 474, 498, 450, 474, 498, 450, 474, 498};
   int mY[9] = {120, 120, 120, 144, 144, 144, 168, 168, 168};
   static int time=0;

   time++;
   // ramki
   Form1->FiltrLMaska1->Left = mX[0]+(int)((time/50.0)*(X[0]-mX[0]));
   Form1->FiltrLMaska1->Top  = mY[0]+(int)((time/50.0)*(Y[0]-mY[0]));
   Form1->FiltrLMaska2->Left = mX[1]+(int)((time/50.0)*(X[1]-mX[1]));
   Form1->FiltrLMaska2->Top  = mY[1]+(int)((time/50.0)*(Y[1]-mY[1]));
   Form1->FiltrLMaska3->Left = mX[2]+(int)((time/50.0)*(X[2]-mX[2]));
   Form1->FiltrLMaska3->Top  = mY[2]+(int)((time/50.0)*(Y[2]-mY[2]));
   Form1->FiltrLMaska4->Left = mX[3]+(int)((time/50.0)*(X[3]-mX[3]));
   Form1->FiltrLMaska4->Top  = mY[3]+(int)((time/50.0)*(Y[3]-mY[3]));
   Form1->FiltrLMaska5->Left = mX[4]+(int)((time/50.0)*(X[4]-mX[4]));
   Form1->FiltrLMaska5->Top  = mY[4]+(int)((time/50.0)*(Y[4]-mY[4]));
   Form1->FiltrLMaska6->Left = mX[5]+(int)((time/50.0)*(X[5]-mX[5]));
   Form1->FiltrLMaska6->Top  = mY[5]+(int)((time/50.0)*(Y[5]-mY[5]));
   Form1->FiltrLMaska7->Left = mX[6]+(int)((time/50.0)*(X[6]-mX[6]));
   Form1->FiltrLMaska7->Top  = mY[6]+(int)((time/50.0)*(Y[6]-mY[6]));
   Form1->FiltrLMaska8->Left = mX[7]+(int)((time/50.0)*(X[7]-mX[7]));
   Form1->FiltrLMaska8->Top  = mY[7]+(int)((time/50.0)*(Y[7]-mY[7]));
   Form1->FiltrLMaska9->Left = mX[8]+(int)((time/50.0)*(X[8]-mX[8]));
   Form1->FiltrLMaska9->Top  = mY[8]+(int)((time/50.0)*(Y[8]-mY[8]));
   // zawartosc ramek
   Form1->FiltrLMaskaT1->Left = mX[0]+10+(int)((time/50.0)*(X[0]-mX[0]));
   Form1->FiltrLMaskaT1->Top  = mY[0]+ 5+(int)((time/50.0)*(Y[0]-mY[0]));
   Form1->FiltrLMaskaT2->Left = mX[1]+10+(int)((time/50.0)*(X[1]-mX[1]));
   Form1->FiltrLMaskaT2->Top  = mY[1]+ 5+(int)((time/50.0)*(Y[1]-mY[1]));
   Form1->FiltrLMaskaT3->Left = mX[2]+10+(int)((time/50.0)*(X[2]-mX[2]));
   Form1->FiltrLMaskaT3->Top  = mY[2]+ 5+(int)((time/50.0)*(Y[2]-mY[2]));
   Form1->FiltrLMaskaT4->Left = mX[3]+10+(int)((time/50.0)*(X[3]-mX[3]));
   Form1->FiltrLMaskaT4->Top  = mY[3]+ 5+(int)((time/50.0)*(Y[3]-mY[3]));
   Form1->FiltrLMaskaT5->Left = mX[4]+10+(int)((time/50.0)*(X[4]-mX[4]));
   Form1->FiltrLMaskaT5->Top  = mY[4]+ 5+(int)((time/50.0)*(Y[4]-mY[4]));
   Form1->FiltrLMaskaT6->Left = mX[5]+10+(int)((time/50.0)*(X[5]-mX[5]));
   Form1->FiltrLMaskaT6->Top  = mY[5]+ 5+(int)((time/50.0)*(Y[5]-mY[5]));
   Form1->FiltrLMaskaT7->Left = mX[6]+10+(int)((time/50.0)*(X[6]-mX[6]));
   Form1->FiltrLMaskaT7->Top  = mY[6]+ 5+(int)((time/50.0)*(Y[6]-mY[6]));
   Form1->FiltrLMaskaT8->Left = mX[7]+10+(int)((time/50.0)*(X[7]-mX[7]));
   Form1->FiltrLMaskaT8->Top  = mY[7]+ 5+(int)((time/50.0)*(Y[7]-mY[7]));
   Form1->FiltrLMaskaT9->Left = mX[8]+10+(int)((time/50.0)*(X[8]-mX[8]));
   Form1->FiltrLMaskaT9->Top  = mY[8]+ 5+(int)((time/50.0)*(Y[8]-mY[8]));

   if (time==50) Form1->FiltrLMaskaTimer->Enabled = false;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrLPixelWTimerTimer(TObject *Sender)
{
   // wspolrzedne przeznaczenia
   static int X = 687;
   static int Y = 37;
   // wspolrzedne poczatkowe
   static int mX = 850;
   static int mY = 472;
   static int a=0;  // nr animacji
   static int time=0;
   int kolor, kolorT;
   int i,j;

   if (time==0)
   {
        kolor = PoliczPixelW(FILTR_L_L,0+a,0);
        if (kolor>128) kolorT = 0; else kolorT = 255;
        if (a>0) X+=25;
        Form1->FiltrLPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrLPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrLPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
        Form1->FiltrLPixelWT->Caption     = IntToStr(kolor);
        Macierz.FiltrL_R[1][1+a] = kolor;
        // blokada przycisku [dalej >]
        Form1->FiltrLDalej->Enabled = false;
   }

   time++;
   // ramki
   Form1->FiltrLPixelW->Left = mX+(int)((time/50.0)*(X-mX));
   Form1->FiltrLPixelW->Top  = mY+(int)((time/50.0)*(Y-mY));
    // zawartosc ramek
   Form1->FiltrLPixelWT->Left = mX+3+(int)((time/50.0)*(X-mX));
   Form1->FiltrLPixelWT->Top  = mY+5+(int)((time/50.0)*(Y-mY));
   if (time==50)
   {
        Form1->FiltrLPixelWTimer->Enabled = false;
        time=0; a++;
        // odblokowanie przycisku [dalej >]
        Form1->FiltrLDalej->Enabled = true;
        Form1->FiltrLDalej->SetFocus();
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrLAutoTimerTimer(TObject *Sender)
{
   static int time=0;
   int kolor, kolorT;
   int ax,ay;

   if (time==0)
   {
        // blokada przycisku [dalej >]
        Form1->FiltrLDalej->Enabled = false;
        Form1->FiltrLPixelW->Left = 850; Form1->FiltrLPixelW->Top = 472;
        Form1->FiltrLPixelWT->Left = 853; Form1->FiltrLPixelWT->Top = 477;
   }
   else
   if (time<8)
   {    // dokonczenie animacji 1 lini
        RysujMacierz(FILTR_L_L); RysujMacierz(FILTR_L_R);
        Macierz.OknoFL_L.x = 2+time; Macierz.OknoFL_L.y = 0;
        Macierz.OknoFL_R.x = 3+time; Macierz.OknoFL_R.y = 1;
        RysujOkno(FILTR_L_L); RysujOkno(FILTR_L_R);
        WyswietlKolor(FILTR_L_L,2+time,0);
        WyswietlKolor(FILTR_L_L,3+time,0);
        WyswietlKolor(FILTR_L_L,4+time,0);
        WyswietlKolor(FILTR_L_L,2+time,1);
        WyswietlKolor(FILTR_L_L,3+time,1);
        WyswietlKolor(FILTR_L_L,4+time,1);
        WyswietlKolor(FILTR_L_L,2+time,2);
        WyswietlKolor(FILTR_L_L,3+time,2);
        WyswietlKolor(FILTR_L_L,4+time,2);
        kolor = PoliczPixelW(FILTR_L_L,2+time,0);
        if (kolor>128) kolorT=0; else kolorT = 255;
        Form1->FiltrLPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrLPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrLPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
        Form1->FiltrLPixelWT->Caption     = IntToStr(kolor);
        Form1->FiltrLPixelW->Left = 737+25*time; Form1->FiltrLPixelW->Top = 37;
        Form1->FiltrLPixelWT->Left = 740+25*time; Form1->FiltrLPixelWT->Top = 44;
        Macierz.FiltrL_R[1][3+time] = kolor;
        PoliczPixele(FILTR_L_L,2+time,0);
   }
   else
   if (time<98)
   {
        ax=(time-8)%10;
        ay=(time-8)/10;
        RysujMacierz(FILTR_L_L); RysujMacierz(FILTR_L_R);
        Macierz.OknoFL_L.x = ax; Macierz.OknoFL_L.y = 1+ay;
        Macierz.OknoFL_R.x = 1+ax; Macierz.OknoFL_R.y = 2+ay;
        RysujOkno(FILTR_L_L); RysujOkno(FILTR_L_R);
        WyswietlKolor(FILTR_L_L,0+ax,1+ay);
        WyswietlKolor(FILTR_L_L,1+ax,1+ay);
        WyswietlKolor(FILTR_L_L,2+ax,1+ay);
        WyswietlKolor(FILTR_L_L,0+ax,2+ay);
        WyswietlKolor(FILTR_L_L,1+ax,2+ay);
        WyswietlKolor(FILTR_L_L,2+ax,2+ay);
        WyswietlKolor(FILTR_L_L,0+ax,3+ay);
        WyswietlKolor(FILTR_L_L,1+ax,3+ay);
        WyswietlKolor(FILTR_L_L,2+ax,3+ay);
        kolor = PoliczPixelW(FILTR_L_L,ax,1+ay);
        if (kolor>128) kolorT=0; else kolorT = 255;
        Form1->FiltrLPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrLPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrLPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
        Form1->FiltrLPixelWT->Caption     = IntToStr(kolor);
        Form1->FiltrLPixelW->Left = 687+25*ax; Form1->FiltrLPixelW->Top = 62+25*ay;
        Form1->FiltrLPixelWT->Left = 690+25*ax; Form1->FiltrLPixelWT->Top = 69+25*ay;
        Macierz.FiltrL_R[2+ay][1+ax] = kolor;
        PoliczPixele(FILTR_L_L,ax,1+ay);
   }
   else
   {
                // odblokowanie przycisku [dalej >]
                Form1->FiltrLDalej->Caption = "Dalej >";
                Form1->FiltrLDalej->Enabled = true;
                Form1->FiltrLDalej->SetFocus();
                Form1->FiltrLAutoTimer->Enabled = false;
                time=0;
   }

   time++;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrLDalejClick(TObject *Sender)
{
   Slajdy.FiltrLnrSlajdu++;
   Prezentacja(FILTR_L_L);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrMMatrixTimerTimer(TObject *Sender)
{
   // wspolrzedne przeznaczenia
   int X[9] = {150, 225, 300, 375, 450, 525, 600, 675, 750};
   int Y[9] = {450, 450, 450, 450, 450, 450, 450, 450, 450};
   // wspolrzedne poczatkowe
   static int mX[9] = {12, 37, 62, 12, 37, 62, 12, 37, 62};
   static int mY[9] = {12, 12, 12, 37, 37, 37, 62, 62, 62};
   static int a=0;  // nr animacji
   static int time=0;
   int kolor[9], kolorT[9];
   int i,j;

   if (time==0)
   {
      for(i=0; i<9; i++)
        if (a>0) mX[i]+=25;
        PoliczPixele(FILTR_M_L,a,0);
      // blokada przycisku [dalej >]
      Form1->FiltrMDalej->Enabled = false;
   }
   time++;
   // ramki
   Form1->FiltrMPixel1->Left = mX[0]+(int)((time/50.0)*(X[0]-mX[0]));
   Form1->FiltrMPixel1->Top  = mY[0]+(int)((time/50.0)*(Y[0]-mY[0]));
   Form1->FiltrMPixel2->Left = mX[1]+(int)((time/50.0)*(X[1]-mX[1]));
   Form1->FiltrMPixel2->Top  = mY[1]+(int)((time/50.0)*(Y[1]-mY[1]));
   Form1->FiltrMPixel3->Left = mX[2]+(int)((time/50.0)*(X[2]-mX[2]));
   Form1->FiltrMPixel3->Top  = mY[2]+(int)((time/50.0)*(Y[2]-mY[2]));
   Form1->FiltrMPixel4->Left = mX[3]+(int)((time/50.0)*(X[3]-mX[3]));
   Form1->FiltrMPixel4->Top  = mY[3]+(int)((time/50.0)*(Y[3]-mY[3]));
   Form1->FiltrMPixel5->Left = mX[4]+(int)((time/50.0)*(X[4]-mX[4]));
   Form1->FiltrMPixel5->Top  = mY[4]+(int)((time/50.0)*(Y[4]-mY[4]));
   Form1->FiltrMPixel6->Left = mX[5]+(int)((time/50.0)*(X[5]-mX[5]));
   Form1->FiltrMPixel6->Top  = mY[5]+(int)((time/50.0)*(Y[5]-mY[5]));
   Form1->FiltrMPixel7->Left = mX[6]+(int)((time/50.0)*(X[6]-mX[6]));
   Form1->FiltrMPixel7->Top  = mY[6]+(int)((time/50.0)*(Y[6]-mY[6]));
   Form1->FiltrMPixel8->Left = mX[7]+(int)((time/50.0)*(X[7]-mX[7]));
   Form1->FiltrMPixel8->Top  = mY[7]+(int)((time/50.0)*(Y[7]-mY[7]));
   Form1->FiltrMPixel9->Left = mX[8]+(int)((time/50.0)*(X[8]-mX[8]));
   Form1->FiltrMPixel9->Top  = mY[8]+(int)((time/50.0)*(Y[8]-mY[8]));
    // zawartosc ramek
   Form1->FiltrMPixelT1->Left = mX[0]+3+(int)((time/50.0)*(X[0]-mX[0]));
   Form1->FiltrMPixelT1->Top  = mY[0]+5+(int)((time/50.0)*(Y[0]-mY[0]));
   Form1->FiltrMPixelT2->Left = mX[1]+3+(int)((time/50.0)*(X[1]-mX[1]));
   Form1->FiltrMPixelT2->Top  = mY[1]+5+(int)((time/50.0)*(Y[1]-mY[1]));
   Form1->FiltrMPixelT3->Left = mX[2]+3+(int)((time/50.0)*(X[2]-mX[2]));
   Form1->FiltrMPixelT3->Top  = mY[2]+5+(int)((time/50.0)*(Y[2]-mY[2]));
   Form1->FiltrMPixelT4->Left = mX[3]+3+(int)((time/50.0)*(X[3]-mX[3]));
   Form1->FiltrMPixelT4->Top  = mY[3]+5+(int)((time/50.0)*(Y[3]-mY[3]));
   Form1->FiltrMPixelT5->Left = mX[4]+3+(int)((time/50.0)*(X[4]-mX[4]));
   Form1->FiltrMPixelT5->Top  = mY[4]+5+(int)((time/50.0)*(Y[4]-mY[4]));
   Form1->FiltrMPixelT6->Left = mX[5]+3+(int)((time/50.0)*(X[5]-mX[5]));
   Form1->FiltrMPixelT6->Top  = mY[5]+5+(int)((time/50.0)*(Y[5]-mY[5]));
   Form1->FiltrMPixelT7->Left = mX[6]+3+(int)((time/50.0)*(X[6]-mX[6]));
   Form1->FiltrMPixelT7->Top  = mY[6]+5+(int)((time/50.0)*(Y[6]-mY[6]));
   Form1->FiltrMPixelT8->Left = mX[7]+3+(int)((time/50.0)*(X[7]-mX[7]));
   Form1->FiltrMPixelT8->Top  = mY[7]+5+(int)((time/50.0)*(Y[7]-mY[7]));
   Form1->FiltrMPixelT9->Left = mX[8]+3+(int)((time/50.0)*(X[8]-mX[8]));
   Form1->FiltrMPixelT9->Top  = mY[8]+5+(int)((time/50.0)*(Y[8]-mY[8]));

   if (time==50)
   {
        Form1->FiltrMMatrixTimer->Enabled = false;
        time=0; a++;
        // odblokowanie przycisku [dalej >]
        Form1->FiltrMDalej->Enabled = true;
        Form1->FiltrMDalej->SetFocus();
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrMPixelWTimerTimer(TObject *Sender)
{
   // wspolrzedne przeznaczenia
   static int X = 687;
   static int Y = 37;
   // wspolrzedne poczatkowe
   static int mX = 850;
   static int mY = 450;
   static int a=0;  // nr animacji
   static int time=0;
   int kolor, kolorT;
   int i,j;

   if (time==0)
   {
        kolor = PoliczPixelW(FILTR_M_L,0+a,0);
        if (kolor>128) kolorT = 0; else kolorT = 255;
        if (a>0) X+=25;
        Form1->FiltrMPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrMPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrMPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
        Form1->FiltrMPixelWT->Caption     = IntToStr(kolor);
        Macierz.FiltrM_R[1][1+a] = kolor;
        // blokada przycisku [dalej >]
        Form1->FiltrMDalej->Enabled = false;
   }

   time++;
   // ramki
   Form1->FiltrMPixelW->Left = mX+(int)((time/50.0)*(X-mX));
   Form1->FiltrMPixelW->Top  = mY+(int)((time/50.0)*(Y-mY));
    // zawartosc ramek
   Form1->FiltrMPixelWT->Left = mX+3+(int)((time/50.0)*(X-mX));
   Form1->FiltrMPixelWT->Top  = mY+5+(int)((time/50.0)*(Y-mY));
   if (time==50)
   {
        Form1->FiltrMPixelWTimer->Enabled = false;
        time=0; a++;
        // odblokowanie przycisku [dalej >]
        Form1->FiltrMDalej->Enabled = true;
        Form1->FiltrMDalej->SetFocus();
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrMAutoTimerTimer(TObject *Sender)
{
   static int time=0;
   int kolor, kolorT;
   int ax,ay;

   if (time==0)
   {
        // blokada przycisku [dalej >]
        Form1->FiltrMDalej->Enabled = false;
        Form1->FiltrMPixelW->Left = 850; Form1->FiltrMPixelW->Top = 450;
        Form1->FiltrMPixelWT->Left = 853; Form1->FiltrMPixelWT->Top = 455;
   }
   else
   if (time<8)
   {    // dokonczenie animacji 1 lini
        RysujMacierz(FILTR_M_L); RysujMacierz(FILTR_M_R);
        Macierz.OknoFM_L.x = 2+time; Macierz.OknoFM_L.y = 0;
        Macierz.OknoFM_R.x = 3+time; Macierz.OknoFM_R.y = 1;
        RysujOkno(FILTR_M_L); RysujOkno(FILTR_M_R);
        WyswietlKolor(FILTR_M_L,2+time,0);
        WyswietlKolor(FILTR_M_L,3+time,0);
        WyswietlKolor(FILTR_M_L,4+time,0);
        WyswietlKolor(FILTR_M_L,2+time,1);
        WyswietlKolor(FILTR_M_L,3+time,1);
        WyswietlKolor(FILTR_M_L,4+time,1);
        WyswietlKolor(FILTR_M_L,2+time,2);
        WyswietlKolor(FILTR_M_L,3+time,2);
        WyswietlKolor(FILTR_M_L,4+time,2);
        kolor = PoliczPixelW(FILTR_M_L,2+time,0);
        if (kolor>128) kolorT=0; else kolorT = 255;
        Form1->FiltrMPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrMPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrMPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
        Form1->FiltrMPixelWT->Caption     = IntToStr(kolor);
        Form1->FiltrMPixelW->Left = 737+25*time; Form1->FiltrMPixelW->Top = 37;
        Form1->FiltrMPixelWT->Left = 740+25*time; Form1->FiltrMPixelWT->Top = 44;
        Macierz.FiltrM_R[1][3+time] = kolor;
        PoliczPixele(FILTR_M_L,2+time,0);
        SortujPixele();
   }
   else
   if (time<98)
   {
        ax=(time-8)%10;
        ay=(time-8)/10;
        RysujMacierz(FILTR_M_L); RysujMacierz(FILTR_M_R);
        Macierz.OknoFM_L.x = ax; Macierz.OknoFM_L.y = 1+ay;
        Macierz.OknoFM_R.x = 1+ax; Macierz.OknoFM_R.y = 2+ay;
        RysujOkno(FILTR_M_L); RysujOkno(FILTR_M_R);
        WyswietlKolor(FILTR_M_L,0+ax,1+ay);
        WyswietlKolor(FILTR_M_L,1+ax,1+ay);
        WyswietlKolor(FILTR_M_L,2+ax,1+ay);
        WyswietlKolor(FILTR_M_L,0+ax,2+ay);
        WyswietlKolor(FILTR_M_L,1+ax,2+ay);
        WyswietlKolor(FILTR_M_L,2+ax,2+ay);
        WyswietlKolor(FILTR_M_L,0+ax,3+ay);
        WyswietlKolor(FILTR_M_L,1+ax,3+ay);
        WyswietlKolor(FILTR_M_L,2+ax,3+ay);
        kolor = PoliczPixelW(FILTR_M_L,ax,1+ay);
        if (kolor>128) kolorT=0; else kolorT = 255;
        Form1->FiltrMPixelW->Brush->Color = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrMPixelWT->Color       = (TColor)RGB(kolor,kolor,kolor);
        Form1->FiltrMPixelWT->Font->Color = (TColor)RGB(kolorT,kolorT,kolorT);
        Form1->FiltrMPixelWT->Caption     = IntToStr(kolor);
        Form1->FiltrMPixelW->Left = 687+25*ax; Form1->FiltrMPixelW->Top = 62+25*ay;
        Form1->FiltrMPixelWT->Left = 690+25*ax; Form1->FiltrMPixelWT->Top = 69+25*ay;
        Macierz.FiltrM_R[2+ay][1+ax] = kolor;
        PoliczPixele(FILTR_M_L,ax,1+ay);
        SortujPixele();
   }
   else
   {
                // odblokowanie przycisku [dalej >]
                Form1->FiltrMDalej->Caption = "Dalej >";
                Form1->FiltrMDalej->Enabled = true;
                Form1->FiltrMDalej->SetFocus();
                Form1->FiltrMAutoTimer->Enabled = false;
                time=0;
   }

   time++;
}
//---------------------------------------------------------------------------


void __fastcall TForm1::FiltrMDalejClick(TObject *Sender)
{
   Slajdy.FiltrMnrSlajdu++;
   Prezentacja(FILTR_M_L);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrMSortTimerTimer(TObject *Sender)
{
   // wspolrzedne poczatkowe
   static int Xp[9] = {150, 225, 300, 375, 450, 525, 600, 675, 750};
   static int Yp[9] = {450, 450, 450, 450, 450, 450, 450, 450, 450};
   static int Xk[9];
   static int Yk[9] = {450, 450, 450, 450, 450, 450, 450, 450, 450};
   static int k[9], pos[9], posW[9];
   static int time=0;
   int i,j;

   if (time==0)
   {
      k[0]=StrToInt(FiltrMPixelT1->Caption); k[1]=StrToInt(FiltrMPixelT2->Caption); k[2]=StrToInt(FiltrMPixelT3->Caption);
      k[3]=StrToInt(FiltrMPixelT4->Caption); k[4]=StrToInt(FiltrMPixelT5->Caption); k[5]=StrToInt(FiltrMPixelT6->Caption);
      k[6]=StrToInt(FiltrMPixelT7->Caption); k[7]=StrToInt(FiltrMPixelT8->Caption); k[8]=StrToInt(FiltrMPixelT9->Caption);
      int p;
         for(i=0; i<9; i++)
           pos[i]=i;
         for(i=8; i>=0; i--)
         {
           for(j=0; j<i; j++)
           {
             if (GetRValue(k[j])>GetRValue(k[j+1]))
             {
                  // przestaw piksele
                  p=k[j+1];
                  k[j+1]=k[j];
                  k[j]=p;
                  p=pos[j+1];
                  pos[j+1]=pos[j];
                  pos[j]=p;
             }
           }
         }
         for(i=0; i<9; i++)
           posW[pos[i]]=i;
         for(i=0; i<9; i++)
           Xk[i]=150+75*posW[i];

   }
   time++;
   // ramki
   Form1->FiltrMPixel1->Left = Xp[0]+(int)((time/50.0)*(Xk[0]-Xp[0]));
   Form1->FiltrMPixel1->Top  = Yp[0]+(int)(-100*sin(M_PI*((Form1->FiltrMPixel1->Left-Xp[0])/(double)(Xk[0]-Xp[0]+1))));
   Form1->FiltrMPixel2->Left = Xp[1]+(int)((time/50.0)*(Xk[1]-Xp[1]));
   Form1->FiltrMPixel2->Top  = Yp[1]+(int)(-100*sin(M_PI*((Form1->FiltrMPixel2->Left-Xp[1])/(double)(Xk[1]-Xp[1]+1))));
   Form1->FiltrMPixel3->Left = Xp[2]+(int)((time/50.0)*(Xk[2]-Xp[2]));
   Form1->FiltrMPixel3->Top  = Yp[2]+(int)(-100*sin(M_PI*((Form1->FiltrMPixel3->Left-Xp[2])/(double)(Xk[2]-Xp[2]+1))));
   Form1->FiltrMPixel4->Left = Xp[3]+(int)((time/50.0)*(Xk[3]-Xp[3]));
   Form1->FiltrMPixel4->Top  = Yp[3]+(int)(-100*sin(M_PI*((Form1->FiltrMPixel4->Left-Xp[3])/(double)(Xk[3]-Xp[3]+1))));
   Form1->FiltrMPixel5->Left = Xp[4]+(int)((time/50.0)*(Xk[4]-Xp[4]));
   Form1->FiltrMPixel5->Top  = Yp[4]+(int)(-100*sin(M_PI*((Form1->FiltrMPixel5->Left-Xp[4])/(double)(Xk[4]-Xp[4]+1))));
   Form1->FiltrMPixel6->Left = Xp[5]+(int)((time/50.0)*(Xk[5]-Xp[5]));
   Form1->FiltrMPixel6->Top  = Yp[5]+(int)(-100*sin(M_PI*((Form1->FiltrMPixel6->Left-Xp[5])/(double)(Xk[5]-Xp[5]+1))));
   Form1->FiltrMPixel7->Left = Xp[6]+(int)((time/50.0)*(Xk[6]-Xp[6]));
   Form1->FiltrMPixel7->Top  = Yp[6]+(int)(-100*sin(M_PI*((Form1->FiltrMPixel7->Left-Xp[6])/(double)(Xk[6]-Xp[6]+1))));
   Form1->FiltrMPixel8->Left = Xp[7]+(int)((time/50.0)*(Xk[7]-Xp[7]));
   Form1->FiltrMPixel8->Top  = Yp[7]+(int)(-100*sin(M_PI*((Form1->FiltrMPixel8->Left-Xp[7])/(double)(Xk[7]-Xp[7]+1))));
   Form1->FiltrMPixel9->Left = Xp[8]+(int)((time/50.0)*(Xk[8]-Xp[8]));
   Form1->FiltrMPixel9->Top  = Yp[8]+(int)(-100*sin(M_PI*((Form1->FiltrMPixel9->Left-Xp[8])/(double)(Xk[8]-Xp[8]+1))));
    // zawartosc ramek
   Form1->FiltrMPixelT1->Left = Xp[0]+3+(int)((time/50.0)*(Xk[0]-Xp[0]));
   Form1->FiltrMPixelT1->Top  = Yp[0]+5+(int)(-100*sin(M_PI*((Form1->FiltrMPixel1->Left-Xp[0])/(double)(Xk[0]-Xp[0]+1))));
   Form1->FiltrMPixelT2->Left = Xp[1]+3+(int)((time/50.0)*(Xk[1]-Xp[1]));
   Form1->FiltrMPixelT2->Top  = Yp[1]+5+(int)(-100*sin(M_PI*((Form1->FiltrMPixel2->Left-Xp[1])/(double)(Xk[1]-Xp[1]+1))));
   Form1->FiltrMPixelT3->Left = Xp[2]+3+(int)((time/50.0)*(Xk[2]-Xp[2]));
   Form1->FiltrMPixelT3->Top  = Yp[2]+5+(int)(-100*sin(M_PI*((Form1->FiltrMPixel3->Left-Xp[2])/(double)(Xk[2]-Xp[2]+1))));
   Form1->FiltrMPixelT4->Left = Xp[3]+3+(int)((time/50.0)*(Xk[3]-Xp[3]));
   Form1->FiltrMPixelT4->Top  = Yp[3]+5+(int)(-100*sin(M_PI*((Form1->FiltrMPixel4->Left-Xp[3])/(double)(Xk[3]-Xp[3]+1))));
   Form1->FiltrMPixelT5->Left = Xp[4]+3+(int)((time/50.0)*(Xk[4]-Xp[4]));
   Form1->FiltrMPixelT5->Top  = Yp[4]+5+(int)(-100*sin(M_PI*((Form1->FiltrMPixel5->Left-Xp[4])/(double)(Xk[4]-Xp[4]+1))));
   Form1->FiltrMPixelT6->Left = Xp[5]+3+(int)((time/50.0)*(Xk[5]-Xp[5]));
   Form1->FiltrMPixelT6->Top  = Yp[5]+5+(int)(-100*sin(M_PI*((Form1->FiltrMPixel6->Left-Xp[5])/(double)(Xk[5]-Xp[5]+1))));
   Form1->FiltrMPixelT7->Left = Xp[6]+3+(int)((time/50.0)*(Xk[6]-Xp[6]));
   Form1->FiltrMPixelT7->Top  = Yp[6]+5+(int)(-100*sin(M_PI*((Form1->FiltrMPixel7->Left-Xp[6])/(double)(Xk[6]-Xp[6]+1))));
   Form1->FiltrMPixelT8->Left = Xp[7]+3+(int)((time/50.0)*(Xk[7]-Xp[7]));
   Form1->FiltrMPixelT8->Top  = Yp[7]+5+(int)(-100*sin(M_PI*((Form1->FiltrMPixel8->Left-Xp[7])/(double)(Xk[7]-Xp[7]+1))));
   Form1->FiltrMPixelT9->Left = Xp[8]+3+(int)((time/50.0)*(Xk[8]-Xp[8]));
   Form1->FiltrMPixelT9->Top  = Yp[8]+5+(int)(-100*sin(M_PI*((Form1->FiltrMPixel9->Left-Xp[8])/(double)(Xk[8]-Xp[8]+1))));

   if (time==50)
   {
        // wycentrowanie w Y
        Form1->FiltrMPixel1->Top = Yk[0];
        Form1->FiltrMPixel2->Top = Yk[1];
        Form1->FiltrMPixel3->Top = Yk[2];
        Form1->FiltrMPixel4->Top = Yk[3];
        Form1->FiltrMPixel5->Top = Yk[4];
        Form1->FiltrMPixel6->Top = Yk[5];
        Form1->FiltrMPixel7->Top = Yk[6];
        Form1->FiltrMPixel8->Top = Yk[7];
        Form1->FiltrMPixel9->Top = Yk[8];
        Form1->FiltrMPixelT1->Top = Yk[0]+5;
        Form1->FiltrMPixelT2->Top = Yk[1]+5;
        Form1->FiltrMPixelT3->Top = Yk[2]+5;
        Form1->FiltrMPixelT4->Top = Yk[3]+5;
        Form1->FiltrMPixelT5->Top = Yk[4]+5;
        Form1->FiltrMPixelT6->Top = Yk[5]+5;
        Form1->FiltrMPixelT7->Top = Yk[6]+5;
        Form1->FiltrMPixelT8->Top = Yk[7]+5;
        Form1->FiltrMPixelT9->Top = Yk[8]+5;
        Form1->FiltrMSortTimer->Enabled = false;
        time=0;
        // odblokowanie przycisku [dalej >]
        Form1->FiltrMDalej->Enabled = true;
        Form1->FiltrMDalej->SetFocus();
   }
}
//---------------------------------------------------------------------------

// wylicza i ustawia kolor pikseli animowanych
void SortujPixele()
{
   static int Xk[9];
   static int k[9], pos[9], posW[9];
   int i,j;

      k[0]=StrToInt(Form1->FiltrMPixelT1->Caption); k[1]=StrToInt(Form1->FiltrMPixelT2->Caption); k[2]=StrToInt(Form1->FiltrMPixelT3->Caption);
      k[3]=StrToInt(Form1->FiltrMPixelT4->Caption); k[4]=StrToInt(Form1->FiltrMPixelT5->Caption); k[5]=StrToInt(Form1->FiltrMPixelT6->Caption);
      k[6]=StrToInt(Form1->FiltrMPixelT7->Caption); k[7]=StrToInt(Form1->FiltrMPixelT8->Caption); k[8]=StrToInt(Form1->FiltrMPixelT9->Caption);
      int p;
         for(i=0; i<9; i++)
           pos[i]=i;
         for(i=8; i>=0; i--)
         {
           for(j=0; j<i; j++)
           {
             if (GetRValue(k[j])>GetRValue(k[j+1]))
             {
                  // przestaw piksele
                  p=k[j+1];
                  k[j+1]=k[j];
                  k[j]=p;
                  p=pos[j+1];
                  pos[j+1]=pos[j];
                  pos[j]=p;
             }
           }
         }
         for(i=0; i<9; i++)
           posW[pos[i]]=i;
         for(i=0; i<9; i++)
           Xk[i]=150+75*posW[i];

   // ramki
   Form1->FiltrMPixel1->Left = Xk[0];
   Form1->FiltrMPixel2->Left = Xk[1];
   Form1->FiltrMPixel3->Left = Xk[2];
   Form1->FiltrMPixel4->Left = Xk[3];
   Form1->FiltrMPixel5->Left = Xk[4];
   Form1->FiltrMPixel6->Left = Xk[5];
   Form1->FiltrMPixel7->Left = Xk[6];
   Form1->FiltrMPixel8->Left = Xk[7];
   Form1->FiltrMPixel9->Left = Xk[8];
    // zawartosc ramek
   Form1->FiltrMPixelT1->Left = Xk[0]+3;
   Form1->FiltrMPixelT2->Left = Xk[1]+3;
   Form1->FiltrMPixelT3->Left = Xk[2]+3;
   Form1->FiltrMPixelT4->Left = Xk[3]+3;
   Form1->FiltrMPixelT5->Left = Xk[4]+3;
   Form1->FiltrMPixelT6->Left = Xk[5]+3;
   Form1->FiltrMPixelT7->Left = Xk[6]+3;
   Form1->FiltrMPixelT8->Left = Xk[7]+3;
   Form1->FiltrMPixelT9->Left = Xk[8]+3;
}
void __fastcall TForm1::FiltrDP_P1_PrzepiszClick(TObject *Sender)
{
        Form1->FiltrDP_P1_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P1.bmp");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrDP_P2_PrzepiszClick(TObject *Sender)
{
        Form1->FiltrDP_P2_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P2.bmp");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrGP_P1_PrzepiszClick(TObject *Sender)
{
        Form1->FiltrGP_P1_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P1.bmp");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrGP_P2_PrzepiszClick(TObject *Sender)
{
      Form1->FiltrGP_P2_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P2.bmp");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrM_P1_PrzepiszClick(TObject *Sender)
{
     Form1->FiltrM_P1_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P1.bmp");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrM_P2_PrzepiszClick(TObject *Sender)
{
     Form1->FiltrM_P2_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P2.bmp");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrM_P3_PrzepiszClick(TObject *Sender)
{
        Form1->FiltrM_P3_ImageRight->Picture->Bitmap->LoadFromFile("images\\zaszumiony.bmp");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrL_P1_PrzepiszClick(TObject *Sender)
{
        Form1->FiltrL_P1_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P1.bmp");        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FiltrL_P2_PrzepiszClick(TObject *Sender)
{
        Form1->FiltrL_P2_ImageRight->Picture->Bitmap->LoadFromFile("images\\FDP_P2.bmp");
}
//---------------------------------------------------------------------------

