//ObrazJedi.java: 

import java.awt.event.*; 
import java.awt.image.*; 
import java.awt.*; 
import javax.swing.*;

public class ObrazJedi extends Frame { 

	Image ob; 

    ObrazJedi () { 
         super ("Obraz"); 
         setSize(400, 430); 
         ob=stworzObraz(); 
    }//ObrazJedi 

    public Image stworzObraz(){ 
        int w = 300;  //szeroko obrazu
        int h = 300;   //wysoko obrazu
        int pix[] = new int[w * h]; //tablica wartoci prbek
        int index = 0; 
        //generacja przykadowego obrazu 
        for (int y = 0; y < h; y++) { 
            int red = (y * 255) / (h - 1); 
            for (int x = 0; x < w; x++) { 
                int blue = (x * 255) / (w - 1); 
                pix[index++] = (255 << 24) | (red << 16) | blue; 
            } 
        } 
        Image img = createImage(new MemoryImageSource(w, h, pix, 0, w)); 
        //tworzony jest obraz w RGB o szerokoci w, wysokoci h,
        //na podstawie tablicy prUbek pix, bez przesunicia w tej tablicy z w elementami w linii 
        return img; 
    }//stworzObraz()

    public void paint (Graphics g) { 
       Insets insets = getInsets(); 
       g.translate (insets.left, insets.top); 
       g.drawImage(ob,50,50,this); 
    }//paint()

    public static void main (String [] args) { 
    	SwingUtilities.invokeLater(new Runnable() {//interfejs 
      		public void run() {//
	         Frame f = new ObrazJedi();				
	         f.addWindowListener(new WindowAdapter(){ 
	              public void windowClosing(WindowEvent e){ 
	                   System.out.println("Dziekujemy za prace z programem..."); 
	                   System.exit(0); 
	              }//windowClosing() 
	        }); 
	        f.setVisible(true);
	       }//run()
	    });//invokeLater() 		
    }//main()

}//koniec public class ObrazJedi extends Frame 

