import javax.swing.*;
import java.awt.*;

/**
 * Translucent progress bar
 * Na podstawie Filthy Rich Clients, autorzy: Chet Haase i Romain Guy
 */
public class GlassPaneProgressBar extends JComponent {
    private static  int pBarWidth = 200;
    private static  int pBarHeight = 16;
    
    private static  Color infoColor = new Color(0x0000FF);
    private static  Color borderColor = new Color(0x0000FF);
    private static  Color bg1COLOR = Color.WHITE;
    private static  Color bg2COLOR = Color.GRAY;
    
    private static final float[] GRADIENTS = new float[] {
        0.0f, 0.49f, 0.5f, 1.0f
    };
    private static final Color[] GRADIENT_COLORS = new Color[] {
        Color.GRAY, Color.DARK_GRAY, Color.BLACK, Color.GRAY
    };
    private static float alphaFraction=0.70f;
    
    private Font f=new Font("Default", Font.BOLD, 18);
    private int progress = 0;
    private int roundSize=16;
    private String info = "Pobieram dane...";
    
    
    public GlassPaneProgressBar() {
        setBackground(bg1COLOR);
        setFont(f);
    }
    
    /**
     * Fonts setter
     * @param fonts
     */
    public void setInfoFonts(Font fonts){
        f=fonts;
    }
    /**
     * Size setter
     * @param width
     * @param height
     */
    public void setPBSize(int width, int height){
        pBarWidth = width;
        pBarHeight=height;
    }
    /**
     * Background color setter
     * @param c1
     * @param c2
     */
    public void setbgColors(Color c1, Color c2){
        bg1COLOR=c1;
        bg2COLOR=c2;
    }
    /**
     * Text color setter
     * @param c
     */
    public void setInfoColor(Color c){
        infoColor=c;
    }
    /**
     * Border color seter
     * @param c
     */
    public void setBorderColor(Color c){
        borderColor=c;
    }
    /**
     * Set alpha fraction (progress bar to background)
     * @param fraction
     */
    public void setAlphaFraction(Float fraction){
        alphaFraction=fraction;
    }

    /**
     * Progress getter
     * @return
     */
    public int getProgress() {
        return progress;
    }

    /**
     * Set the actual progress, compute the required area and repaint progress bar
     * @param progress
     */
    public void setProgress(int progress) {
        int oldProgress = this.progress;
        this.progress = progress;
        
        FontMetrics metrics = getGraphics().getFontMetrics(getFont()); 
        int w = (int) (pBarWidth * ((float) oldProgress / 100.0f));
        //int x = w + (getWidth() - pBarWidth) / 2;
        int x =  (getWidth() - pBarWidth) / 2;
        int y = (getHeight() - pBarHeight) / 2;
        y += metrics.getDescent() / 2;
        
       //w = (int) (pBarWidth * ((float) progress / 100.0f)) - w;
        w = (int) (pBarWidth * ((float) progress / 100.0f)) ;
        int h = pBarHeight;
        
        repaint(x, y, w, h);
    }//end public void setProgress(int progress) {
    
    /**
     * Paint the translunced progress bar with anti-aliasing 
     * @param g
     */
    @Override
    protected void paintComponent(Graphics g) {
        // enables anti-aliasing
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        
        Rectangle clip = g.getClipBounds();
        AlphaComposite alpha = AlphaComposite.SrcOver.derive(alphaFraction);
        Composite composite = g2.getComposite();
        g2.setComposite(alpha);
        
        g2.setColor(getBackground());
        g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        
        FontMetrics metrics = g.getFontMetrics();        
        int x = (getWidth() - pBarWidth) / 2;
        int y = (getHeight() - pBarHeight - metrics.getDescent()) / 2;
        
        g2.setColor(infoColor);
        g2.drawString(info, x, y);
        
        y += metrics.getDescent();
        
        int w = (int) (pBarWidth * ((float) progress / 100.0f));
        int h = pBarHeight;
        
        Paint paint = g2.getPaint();
        
        Paint gradient = new GradientPaint(x, y, bg2COLOR,
                x, y + h, bg1COLOR);
        g2.setPaint(gradient);
        g2.fillRoundRect(x, y, pBarWidth, pBarHeight,roundSize,roundSize);
        
        gradient = new LinearGradientPaint(x, y, x, y + h,
                GRADIENTS, GRADIENT_COLORS);
        g2.setPaint(gradient);
        g2.fillRoundRect(x, y, w, h,roundSize,roundSize);
        g2.setPaint(paint);
        g2.drawRoundRect(x, y, pBarWidth, pBarHeight,roundSize,roundSize);
        g2.setComposite(composite);
    }//end paintComponent()
}//end class
